/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestriction;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestrictionTimeCondition;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;

public class InetServRestrictionDao
extends AbstractDao<InetServRestriction> {
    private static final Set<Integer> ALL_DAYS_OF_WEEK = IntStream.rangeClosed(1, 7).boxed().collect(Collectors.toSet());
    private static final Set<Integer> ALL_DAYS_OF_MONTH = IntStream.rangeClosed(1, 31).boxed().collect(Collectors.toSet());
    private static Reader reader;
    private static final ObjectMapper mapper;
    private int queryCount = 0;
    private int count = -1;
    private Map<Integer, List<InetServRestriction>> cache = null;

    private static final ObjectMapper initMapper() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
            reader = (data, clazz) -> mapper.readValue(data, clazz);
            return mapper;
        }
        catch (Throwable t) {
            LogManager.getLogger().error(t.getMessage(), t);
            return null;
        }
    }

    public InetServRestrictionDao(Connection con, int mid) {
        super(con, mid, "inet_serv_restriction");
    }

    protected InetServRestriction getFromRS(ResultSet rs) throws SQLException, BGException {
        InetServRestriction result = new InetServRestriction();
        result.setId(rs.getInt("id"));
        result.setInetServId(rs.getInt("servId"));
        result.setDateFrom(TimeUtils.convertSqlDateToDate((Date)rs.getDate("dateFrom")));
        result.setDateTo(TimeUtils.convertSqlDateToDate((Date)rs.getDate("dateTo")));
        result.setType(rs.getInt("type"));
        result.setServiceIds(Utils.toIntegerSet((String)rs.getString("serviceIds")));
        result.setAmount(rs.getBigDecimal("amount"));
        result.setComment(rs.getString("comment"));
        try {
            switch (result.getType()) {
                case 0: {
                    String config = rs.getString("config");
                    if (config == null || reader == null) break;
                    result.setConfig(reader.read(config, InetServRestrictionTimeCondition.class));
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private int count() throws BGException {
        try {
            int result = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(*) FROM " + this.tableName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<InetServRestriction> list(int servId) throws BGException {
        ++this.queryCount;
        if (this.cache != null) {
            return this.cache.getOrDefault(servId, Collections.emptyList());
        }
        if (this.queryCount > 20 && this.count < 1000) {
            if (this.count < 0) {
                this.count = this.count();
            }
            if (this.count < 1000) {
                List list = this.list(null, null, new Object[0]);
                this.cache = list.stream().collect(Collectors.groupingBy(r -> r.getInetServId()));
                return this.cache.getOrDefault(servId, Collections.emptyList());
            }
        }
        return this.list("servId=?", null, new Object[]{servId});
    }

    public void update(int inetServId, List<InetServRestriction> servRestrictionList) throws BGException {
        this.cache = null;
        try {
            PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (servId, dateFrom, dateTo, type, serviceIds, amount, comment, config) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", 1);
            PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET dateFrom=?, dateTo=?, type=?, serviceIds=?, amount=?, comment=?, config=? WHERE id=?");
            HashSet<Integer> ids = new HashSet<Integer>();
            if (servRestrictionList != null) {
                for (InetServRestriction restriction : servRestrictionList) {
                    this.update(inetServId, restriction, insertPS, updatePS);
                    ids.add(restriction.getId());
                }
            }
            ids.add(-1);
            PreparedStatement deletePS = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE servId=? AND id NOT IN (" + Utils.toString(ids) + ")");
            deletePS.setInt(1, inetServId);
            deletePS.executeUpdate();
            insertPS.close();
            updatePS.close();
            deletePS.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void update(int inetServId, InetServRestriction restriction, PreparedStatement insertPS, PreparedStatement updatePS) throws SQLException, BGIllegalArgumentException {
        String config = "";
        try {
            switch (restriction.getType()) {
                case 0: {
                    InetServRestrictionTimeCondition condition = this.checkTimeRestriction(restriction);
                    StringWriter sw = new StringWriter();
                    mapper.writeValue((Writer)sw, (Object)condition);
                    config = sw.toString();
                    break;
                }
            }
        }
        catch (IOException ex) {
            this.getLogger().warn(ex.getMessage(), (Throwable)ex);
        }
        if (restriction.getId() > 0) {
            updatePS.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)restriction.getDateFrom()));
            updatePS.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)restriction.getDateTo()));
            updatePS.setInt(3, restriction.getType());
            updatePS.setString(4, Utils.toString((Iterable)restriction.getServiceIds()));
            updatePS.setBigDecimal(5, restriction.getAmount());
            updatePS.setString(6, restriction.getComment());
            updatePS.setString(7, config);
            updatePS.setInt(8, restriction.getId());
            if (updatePS.executeUpdate() == 0) {
                restriction.setId(-1);
            }
        }
        if (restriction.getId() <= 0) {
            insertPS.setInt(1, inetServId);
            insertPS.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)restriction.getDateFrom()));
            insertPS.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)restriction.getDateTo()));
            insertPS.setInt(4, restriction.getType());
            insertPS.setString(5, Utils.toString((Iterable)restriction.getServiceIds()));
            insertPS.setBigDecimal(6, restriction.getAmount());
            insertPS.setString(7, restriction.getComment());
            insertPS.setString(8, config);
            insertPS.executeUpdate();
            restriction.setId(ServerUtils.lastInsertId((PreparedStatement)insertPS));
        }
    }

    private InetServRestrictionTimeCondition checkTimeRestriction(InetServRestriction restriction) throws BGIllegalArgumentException {
        InetServRestrictionTimeCondition condition;
        if (restriction.getConfig() == null) {
            throw new BGIllegalArgumentException("config");
        }
        if (restriction.getAmount() == null) {
            restriction.setAmount(BigDecimal.ZERO);
        }
        if ((condition = (InetServRestrictionTimeCondition)restriction.getConfig()).getDaysOfMonth() != null && condition.getDaysOfMonth().size() > 0) {
            condition.getDaysOfMonth().retainAll(ALL_DAYS_OF_MONTH);
        }
        if (condition.getDaysOfWeek() != null && condition.getDaysOfWeek().size() > 0) {
            condition.getDaysOfWeek().retainAll(ALL_DAYS_OF_WEEK);
        }
        return condition;
    }

    protected void updateImpl(InetServRestriction b) throws BGException, SQLException {
        throw new UnsupportedOperationException();
    }

    static {
        mapper = InetServRestrictionDao.initMapper();
    }

    @FunctionalInterface
    public static interface Reader {
        public Object read(String var1, Class<?> var2) throws Exception;
    }
}

