/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetInterface;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InvDevice;
import ru.bitel.bgbilling.modules.inet.common.event.InetDeviceModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.manage.InetDeviceManageEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaDeviceInitEvent;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceTypeDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InvDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTreeFilter;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;
import ru.bitel.oss.systems.inventory.resource.server.service.AbstractDeviceServiceImpl;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService")
@XmlSeeAlso(value={InetDevice.class, InvDevice.class, InetDeviceType.class})
public class InetDeviceServiceImpl
extends AbstractDeviceServiceImpl<InvDevice, InetDeviceType>
implements InetDeviceService {
    @Resource
    private ResourceService resourceService;
    @Resource
    private DeviceInterfaceService devicePortService;
    @Resource
    private InetServService inetServService;
    private InetDeviceDao inetDeviceDao;

    @PostConstruct
    protected void init() throws BGException {
        super.init();
    }

    public InetDeviceType deviceTypeGet(int id) throws BGException {
        InetDeviceType result = (InetDeviceType)this.deviceTypeDirectory.get(id);
        if (result == null) {
            if (id == 0) {
                result = new InetDeviceType(0, "\u041f\u0430\u043f\u043a\u0430");
            } else {
                result = new InetDeviceType();
                result.setId(id);
            }
        }
        return result;
    }

    public int deviceTypeUpdate(InetDeviceType inetDeviceType) throws BGException {
        InetDeviceType oldType = null;
        if (inetDeviceType.getId() > 0) {
            oldType = (InetDeviceType)this.deviceTypeDirectory.get(inetDeviceType.getId());
        }
        if (!inetDeviceType.isUniqueInterfaces()) {
            List list = this.deviceList(inetDeviceType.getId());
            for (InetInterface iface : inetDeviceType.getInterfaceList()) {
                boolean needChange = true;
                if (oldType != null) {
                    for (InetInterface oldIface : oldType.getInterfaceList()) {
                        if (oldIface.getId() != iface.getId()) continue;
                        needChange = oldIface.getTitle() != null && !oldIface.getTitle().equals(iface.getTitle());
                        break;
                    }
                }
                if (!needChange) continue;
                for (InvDevice device : list) {
                    List devicePortList = this.devicePortService.devicePortList(device.getId(), false);
                    boolean found = false;
                    for (DeviceInterface port : devicePortList) {
                        if (port.getPort() != iface.getId()) continue;
                        if (port.getTitle() != null && !port.getTitle().equals(iface.getTitle())) {
                            port.setTitle(iface.getTitle());
                            this.devicePortService.devicePortUpdate(port, true);
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    DeviceInterface port = new DeviceInterface();
                    port.setPort(iface.getId());
                    port.setDeviceId(device.getId());
                    port.setTitle(iface.getTitle());
                    port.setStatus(1);
                    this.devicePortService.devicePortUpdate(port, true);
                }
            }
            Map<Integer, InetInterface> delMap = this.getDeletedInterfaces(inetDeviceType, oldType);
            for (InetInterface iface : delMap.values()) {
                for (InvDevice device : list) {
                    this.devicePortService.devicePortDelete(device.getId(), iface.getId());
                }
            }
        }
        this.deviceTypeDirectory.update((Id)inetDeviceType);
        return inetDeviceType.getId();
    }

    public void deviceTypeDelete(int id) throws BGException {
        if (this.deviceDao.listByType(id, false).size() > 0) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        }
        List list = this.deviceList(id);
        InetDeviceType type = (InetDeviceType)this.deviceTypeDirectory.get(id);
        if (type != null) {
            for (InetInterface iface : type.getInterfaceList()) {
                for (InvDevice device : list) {
                    this.devicePortService.devicePortDelete(device.getId(), iface.getId());
                }
            }
        }
        this.deviceTypeDirectory.delete(id);
    }

    protected DeviceDao<InvDevice, InetDeviceType> getDeviceDao() throws BGException {
        return new InvDeviceDao(this.getConnection(), this.moduleId, this.userId);
    }

    protected DeviceTypeDao<InetDeviceType> getDeviceTypeDao() throws BGException {
        return new InetDeviceTypeDao(this.getConnection(), this.moduleId);
    }

    protected Directory<InetDeviceType> getDeviceTypeDirectory() throws BGException {
        return this.context.getDirectory(InetDeviceType.class, this.moduleId);
    }

    public InvDevice deviceGet(int id) throws BGException {
        return (InvDevice)this.deviceDao.get(id);
    }

    public String deviceConfigPreview(int id) throws BGException {
        InetDeviceMap deviceMap = InetDeviceMap.getInstance(this.moduleId);
        InetDeviceMap.InetDeviceMapItem device = deviceMap.get(id);
        if (device == null) {
            return "";
        }
        return String.valueOf(device.getConfig());
    }

    public int deviceUpdate(InvDevice device) throws BGException {
        return this.deviceUpdate(device, -1);
    }

    private int deviceUpdate(InvDevice device, int initiatorInetDeviceId) throws BGException {
        InetDeviceType newType;
        InvDevice oldDevice = (InvDevice)this.deviceDao.get(device.getId());
        this.deviceDao.update((Device)device);
        InetDeviceType oldType = null;
        if (oldDevice != null) {
            oldType = (InetDeviceType)this.deviceTypeDirectory.get(oldDevice.getDeviceTypeId());
        }
        if (!((newType = this.deviceTypeGet(device.getDeviceTypeId())).isUniqueInterfaces() || oldDevice != null && oldDevice.getDeviceTypeId() == device.getDeviceTypeId())) {
            List devicePortList = this.devicePortService.devicePortList(device.getId(), false);
            InetDeviceType type = null;
            if (device.getDeviceTypeId() > 0) {
                type = (InetDeviceType)this.deviceTypeDirectory.get(device.getDeviceTypeId());
                for (InetInterface iface : type.getInterfaceList()) {
                    boolean found = false;
                    for (DeviceInterface port : devicePortList) {
                        if (port.getPort() != iface.getId()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    DeviceInterface port = new DeviceInterface();
                    port.setPort(iface.getId());
                    port.setDeviceId(device.getId());
                    port.setTitle(iface.getTitle());
                    port.setStatus(1);
                    this.devicePortService.devicePortUpdate(port, false);
                }
            }
            Map<Integer, InetInterface> delMap = this.getDeletedInterfaces(type, oldType);
            for (InetInterface iface : delMap.values()) {
                this.devicePortService.devicePortDelete(device.getId(), iface.getId());
            }
        }
        List<InetDevice> inetDeviceList = this.getInetDeviceDao().listByInvDeviceId(device.getId());
        for (InetDevice inetDevice : inetDeviceList) {
            if (inetDevice.getId() == initiatorInetDeviceId) continue;
            this.inetDeviceUpdate(inetDevice, false);
        }
        return device.getId();
    }

    private Map<Integer, InetInterface> getDeletedInterfaces(InetDeviceType type, InetDeviceType oldType) {
        HashMap<Integer, InetInterface> delMap = new HashMap<Integer, InetInterface>();
        if (oldType != null) {
            for (InetInterface iface1 : oldType.getInterfaceList()) {
                boolean found1 = false;
                if (type != null) {
                    for (InetInterface iface2 : type.getInterfaceList()) {
                        if (iface2.getId() != iface1.getId()) continue;
                        found1 = true;
                        break;
                    }
                }
                if (found1) continue;
                delMap.put(iface1.getId(), iface1);
            }
        }
        return delMap;
    }

    public void deviceDelete(int id) throws BGException {
        for (DeviceInterface iface : this.devicePortService.devicePortList(id, false)) {
            this.devicePortService.devicePortDelete(id, iface.getPort());
        }
        for (InetDevice inetDevice : this.getInetDeviceDao().listByInvDeviceId(id)) {
            this.checkDeviceUsage(inetDevice.getId());
            this.getInetDeviceDao().delete(inetDevice.getId());
        }
        this.deviceDao.delete(id);
    }

    public void deviceReload() throws BGException {
        this.deviceReload(0);
    }

    public void deviceReload(int rootDeviceId) throws BGException {
        EventProcessor.getInstance().publish((Event)new InetReloadEvent(this.moduleId, this.userId, rootDeviceId));
    }

    public void deviceSaReinit(int id) throws BGException {
        EventProcessor.getInstance().publish((Event)new InetSaDeviceInitEvent(this.moduleId, this.userId, id, 0));
    }

    public String deviceManage(int invDeviceId, String operation, int servId, int connectionId, long timeout) throws BGException {
        return this.deviceManage(invDeviceId, 0, operation, servId, connectionId, timeout);
    }

    public String deviceManage(int invDeviceId, int inetDeviceId, String operation, int servId, int connectionId, long timeout) throws BGException {
        timeout = timeout <= 0L ? 30000L : Math.max(Math.min(timeout, TimeUnit.MINUTES.toMillis(5L)), TimeUnit.SECONDS.toMillis(10L));
        InetDeviceManageEvent e = new InetDeviceManageEvent(this.moduleId, this.userId, invDeviceId, inetDeviceId, operation, servId, connectionId);
        e = (InetDeviceManageEvent)EventProcessor.getInstance().request((Event)e, timeout);
        if (e == null) {
            throw new BGMessageException("\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e Access \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.");
        }
        return String.valueOf(e.getResult());
    }

    public List<InetServ> getContracts(int deviceId) throws BGException {
        try (InetServDao servDao = new InetServDao(this.getConnection(), this.moduleId);){
            List<InetServ> serv = servDao.listDevice(deviceId);
            ArrayList<InetServ> result = new ArrayList<InetServ>();
            int previous = -1;
            for (InetServ current : serv) {
                if (current.getContractId() == previous) continue;
                result.add(current);
                previous = current.getContractId();
            }
            ArrayList<InetServ> arrayList = result;
            return arrayList;
        }
    }

    private InetDeviceDao getInetDeviceDao() throws BGException {
        if (this.inetDeviceDao == null) {
            this.inetDeviceDao = new InetDeviceDao(this.getConnection(), this.moduleId);
        }
        return this.inetDeviceDao;
    }

    public int inetDeviceUpdate(InetDevice device, boolean updateInvDevice) throws BGException {
        InetDeviceType deviceType;
        InvDevice invDevice;
        int invDeviceId = device.getInvDeviceId();
        if (invDeviceId <= 0) {
            invDevice = device.toInvDevice();
            InetDevice parent = this.inetDeviceGet(device.getParentId());
            int parentInvDeviceId = parent != null ? parent.getInvDeviceId() : 0;
            invDevice.setParentId(parentInvDeviceId);
            deviceType = this.deviceTypeGet(invDevice.getDeviceTypeId());
            invDevice.setTitle(Device.generateTitle((String)invDevice.getIdentifier(), (String)invDevice.getHost(), (String)deviceType.getGuiTitle()));
            this.deviceUpdate(invDevice);
            invDeviceId = invDevice.getId();
            device.setInvDeviceId(invDeviceId);
        } else {
            InvDevice oldInvDevice = this.deviceGet(invDeviceId);
            invDevice = device.toInvDevice();
            invDevice.setParentId(oldInvDevice.getParentId());
            if (!updateInvDevice) {
                invDevice.setEntityAttributes(oldInvDevice.getEntityAttributes());
            }
            InetDeviceType deviceType2 = this.deviceTypeGet(invDevice.getDeviceTypeId());
            invDevice.setTitle(Device.generateTitle((String)invDevice.getIdentifier(), (String)invDevice.getHost(), (String)deviceType2.getGuiTitle()));
            if (updateInvDevice) {
                this.deviceUpdate(invDevice, device.getId());
            }
        }
        if (device.getDeviceTypeId() == invDevice.getDeviceTypeId()) {
            device.setDeviceTypeId(-1);
        }
        if (Utils.isBlankString((String)device.getIdentifier()) || invDevice.getIdentifier().equals(device.getIdentifier())) {
            device.setIdentifier(null);
        }
        if (Utils.isBlankString((String)device.getHost()) || invDevice.getHost().equals(device.getHost())) {
            device.setHost(null);
        }
        if (Utils.isBlankString((String)device.getConfig()) || invDevice.getConfig().equals(device.getConfig())) {
            device.setConfig("");
        }
        InetDeviceDao inetDeviceDao = this.getInetDeviceDao();
        InetDevice oldDevice = inetDeviceDao.get(device.getId());
        if (!updateInvDevice) {
            device.setEntityAttributes(invDevice.getEntityAttributes());
        }
        deviceType = this.deviceTypeGet(device.getDeviceTypeId());
        device.setTitle(InetDevice.generateTitle((String)device.getIdentifier(), (String)device.getHost(), (String)deviceType.getGuiTitle()));
        inetDeviceDao.update((Entity)device);
        if (oldDevice != null && oldDevice.getSvlan() >= 0 && oldDevice.getSvlan() != device.getSvlan()) {
            this.resourceService.vlanResourceUnsubscribe((short)2, device.getId());
        }
        if (device.getSvlan() >= 0) {
            Set<Integer> vlanResourceCategoryId = this.svlanResourceCategoryIds(device.getParentId());
            if (!this.resourceService.vlanResourceSubscribe(device.getSvlan(), (short)2, device.getId(), device.getTitle(), device.getDateFrom(), device.getDateTo(), vlanResourceCategoryId, true)) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 VLAN-\u0440\u0435\u0441\u0443\u0440\u0441!");
            }
        }
        this.context.publishAfterCommit((Event)new InetDeviceModifiedEvent(this.moduleId, this.userId, oldDevice, device));
        return device.getId();
    }

    public InetDevice inetDeviceGet(int id) throws BGException {
        return this.getInetDeviceDao().get(id);
    }

    public void inetDeviceDelete(int id) throws BGException {
        this.checkDeviceUsage(id);
        InetDevice oldDevice = this.inetDeviceGet(id);
        if (oldDevice == null) {
            throw new BGIllegalArgumentException("id");
        }
        if (oldDevice.getSvlan() >= 0) {
            this.resourceService.vlanResourceUnsubscribe((short)2, id);
        }
        this.getInetDeviceDao().delete(id);
    }

    private void checkDeviceUsage(int id) throws BGException, BGMessageException {
        try (InetServDao inetServDao = new InetServDao(this.getConnection(), this.moduleId);){
            List<InetServ> servList = inetServDao.listDevice(id);
            if (servList != null && servList.size() > 0) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e, \u0442.\u043a. \u043e\u043d\u043e \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043e \u043a \u043e\u0434\u043d\u043e\u043c\u0443 \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0443.");
            }
        }
        InetConnectionDao connectionDao = new InetConnectionDao(this.getConnection(), this.moduleId);
        List<InetConnection> connectionList = connectionDao.list(Collections.singleton(id), true);
        if (connectionList != null && connectionList.size() > 0) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u0435\u0441\u0441\u0438\u0438.");
        }
    }

    public void inetDeviceMove(int id, Set<Integer> children) throws BGException {
        this.getInetDeviceDao().move(id, children);
    }

    public InetDevice inetDeviceRoot(DeviceTreeFilter deviceTreeFilter, boolean loadAncestors) throws BGException {
        return this.getInetDeviceDao().root(deviceTreeFilter, loadAncestors);
    }

    public JSONObject inetDeviceTree() throws BGException {
        JSONObject root = new JSONObject();
        root.put("id", 0);
        root.put("title", (Object)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        root.put("deviceTypeId", 0);
        this.buildTree(0, root, this.getInetDeviceDao().inetDeviceList());
        return root;
    }

    private void buildTree(int parentId, JSONObject parent, List<InetDevice> devices) {
        for (InetDevice inetDevice : devices) {
            if (inetDevice.getParentId() != parentId) continue;
            JSONObject child = new JSONObject();
            child.put("id", inetDevice.getId());
            child.put("parentId", parentId);
            child.put("invDeviceId", inetDevice.getInvDeviceId());
            child.put("title", (Object)inetDevice.getTitle());
            child.put("comment", (Object)inetDevice.getComment());
            child.put("deviceTypeId", inetDevice.getDeviceTypeId());
            this.buildTree(inetDevice.getId(), child, devices);
            JSONArray children = parent.optJSONArray("children");
            if (children == null) {
                children = new JSONArray();
                parent.put("children", (Object)children);
            }
            children.put((Object)child);
        }
    }

    public InetDevice deviceSourceRoot() throws BGException {
        return this.getInetDeviceDao().rootSource();
    }

    public List<InetDevice> deviceSourceList() throws BGException {
        return this.getInetDeviceDao().listSource();
    }

    public List<InetDevice> inetDeviceList(int deviceTypeId) throws BGException {
        return this.getInetDeviceDao().inetDeviceList(deviceTypeId);
    }

    public boolean isUniqueInterface(int deviceTypeId) throws BGException {
        return ((InetDeviceType)this.getDeviceTypeDao().get(deviceTypeId)).isUniqueInterfaces();
    }

    public void deviceGroupDelete(int id) throws BGException {
        List inetServTypeList = this.inetServService.inetServTypeList();
        boolean isUseGroup = false;
        for (InetServType inetServType : inetServTypeList) {
            Set deviceGroupsIds = inetServType.getDeviceGroupIds();
            if (deviceGroupsIds == null || !deviceGroupsIds.contains(id)) continue;
            isUseGroup = true;
            break;
        }
        if (isUseGroup) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443, \u0442.\u043a. \u043a \u043d\u0435\u0439 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u044b \u0442\u0438\u043f\u044b \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432");
        }
        super.deviceGroupDelete(id);
    }

    public Set<Integer> svlanResourceCategoryIds(int deviceId) throws BGException, BGMessageException {
        if (deviceId <= 0) {
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u043a\u0430\u0437\u0430\u0442\u044c SVLAN \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430\u0445 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0443\u0440\u043e\u0432\u043d\u044f!");
        }
        InetDeviceMap.InetDeviceMapItem deviceMapItem = InetDeviceMap.getInstance(this.moduleId).get(deviceId);
        if (deviceMapItem == null) {
            throw new BGMessageException("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430 SVLAN \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430!");
        }
        Set vlanResourceCategoryIds = Utils.toIntegerSet((String)deviceMapItem.getConfig().get("svlan.resource.category", null));
        vlanResourceCategoryIds.remove(-1);
        if (vlanResourceCategoryIds.size() == 0) {
            throw new BGMessageException("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430 SVLAN \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430!");
        }
        return vlanResourceCategoryIds;
    }

    public boolean deviceTreeReorder(int srcDeviceId, int parentDeviceId, int step) throws BGException {
        return this.getInetDeviceDao().reorder(srcDeviceId, parentDeviceId, step);
    }
}

