/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.IpField;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.inet.IpRange;

public class InetSearchPanel
extends BGUTabPanel {
    private IpField ip = new IpField();
    private JTextField login = new JTextField();
    private JTextField vlan = new JTextField();
    private JTextField identifier = new JTextField();
    private JTextField macAddress = new JTextField();
    private JTextField title = new JTextField();
    private InetServTableModel model = new InetServTableModel();
    private BGUComboBox<InetServType> serviceType = new BGUComboBox();
    private InetServService inetServService = null;

    public InetSearchPanel(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InetSearchPanel.this.openContract(((InetServ)InetSearchPanel.this.model.getSelectedRow()).getContractId());
                }
            }
        });
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.setBorder((Border)new BGTitleBorder("\u0422\u0438\u043f \u0441\u0435\u0440\u0432\u0438\u0441\u0430"));
        typePanel.add((Component)this.serviceType, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel topSearchPanel = new JPanel(new GridLayout(1, 3));
        topSearchPanel.add((Component)this.getFieldPanel("\u041b\u043e\u0433\u0438\u043d", this.login), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        topSearchPanel.add((Component)this.getFieldPanel("IP \u0430\u0434\u0440\u0435\u0441", (JTextField)this.ip), new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        topSearchPanel.add((Component)this.getFieldPanel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.title), new GridBagConstraints(2, 0, 1, 1, 0.3, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel lowerSearchPanel = new JPanel(new GridLayout(1, 3));
        lowerSearchPanel.add((Component)this.getFieldPanel("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", this.identifier), new GridBagConstraints(0, 0, 1, 1, 0.8, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        lowerSearchPanel.add((Component)this.getFieldPanel("MAC-\u0430\u0434\u0440\u0435\u0441", this.macAddress), new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        lowerSearchPanel.add((Component)this.getFieldPanel("VLAN", this.vlan), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(topSearchPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(lowerSearchPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(typePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new BGButton(this.getActionMap().get("find")), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(8, 5, 2, 5), 0, 0));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getFieldPanel(String title, JTextField field) {
        field.setAction(this.getActionMap().get("find"));
        field.setHorizontalAlignment(0);
        BGButton clearButton = new BGButton("X");
        clearButton.addActionListener((ActionListener)new ClearActionListener(field));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(title));
        panel.add((Component)field, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)clearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private InetServService getInetServService() {
        if (this.inetServService == null) {
            this.inetServService = (InetServService)((ClientContext)this.getContext()).getPort(InetServService.class);
        }
        return this.inetServService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            List typeList = this.getInetServService().inetServTypeList();
            InetServType anyType = new InetServType();
            anyType.setTitle("\u041b\u044e\u0431\u043e\u0439");
            anyType.setId(0);
            typeList.add(0, anyType);
            this.serviceType.setData(typeList);
        });
        new AbstractBGUPanel.DefaultAction("find", "\u041d\u0430\u0439\u0442\u0438"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetServType selectedType = (InetServType)InetSearchPanel.this.serviceType.getSelectedItem();
                int vlanInt = Utils.parseInt((String)InetSearchPanel.this.vlan.getText(), (int)-1);
                if (!Utils.isBlankString((String)InetSearchPanel.this.vlan.getText()) && vlanInt == -1) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d VLAN!");
                    return;
                }
                InetSearchPanel.this.model.setData(InetSearchPanel.this.getInetServService().searchInetServ(InetSearchPanel.this.login.getText(), InetSearchPanel.this.ip.getAddressRange(), selectedType != null ? selectedType.getId() : 0, vlanInt, InetSearchPanel.this.title.getText(), InetSearchPanel.this.identifier.getText(), InetSearchPanel.this.macAddress.getText(), false));
            }
        };
    }

    class InetServTableModel
    extends BGTableModel<InetServ> {
        public InetServTableModel() {
            super(InetServTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 120, 150, -1, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 120, 150, -1, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 140, 200, 240, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432", 120, 350, 380, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(InetServ val, int column) throws BGException {
            switch (column) {
                case 1: {
                    return val.getContractTitle();
                }
                case 2: {
                    return val.getContractComment();
                }
                case 4: {
                    return TimeUtils.formatPeriod((Date)val.getDateFrom(), (Date)val.getDateTo());
                }
                case 5: {
                    if (val.getAddressFrom() != null || val.getAddressTo() != null) {
                        return IpRange.toString((byte[])val.getAddressFrom(), (byte[])val.getAddressTo());
                    }
                    return "";
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class ClearActionListener
    implements ActionListener {
        private JTextField field;

        public ClearActionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.field.setText("");
        }
    }
}

