/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAccountingPeriod;
import ru.bitel.bgbilling.modules.inet.common.service.AccountingPeriodService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class InetAccountingPeriodPanel
extends BGUPanel {
    private InetAccountingPeriodTableModel model = new InetAccountingPeriodTableModel();
    private AccountingPeriodService accountingPeriodService = null;

    public InetAccountingPeriodPanel() {
        super((LayoutManager)new BorderLayout());
    }

    private AccountingPeriodService getAccountingPeriodService() {
        if (this.accountingPeriodService == null) {
            this.accountingPeriodService = (AccountingPeriodService)((ClientContext)this.getContext()).getPort(AccountingPeriodService.class);
        }
        return this.accountingPeriodService;
    }

    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent((Component)((Object)this));
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), "Center");
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(this.getAccountingPeriodService().periodList(((ClientContext)this.getContext()).getContractId()))));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new PeriodEditor("\u041d\u043e\u0432\u044b\u0439 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", new InetAccountingPeriod(((ClientContext)this.getContext()).getContractId())).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.model, PeriodEditor.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            InetAccountingPeriod inetAccountingPeriod = (InetAccountingPeriod)this.model.getSelectedRow();
            if (inetAccountingPeriod == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (BGSwingUtilites.confirmDelete((String)"\u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", (Object)inetAccountingPeriod)) {
                this.getAccountingPeriodService().periodDelete(inetAccountingPeriod.getId());
                this.performAction("refresh");
            }
        });
    }

    private class InetAccountingPeriodTableModel
    extends BGTableModel<InetAccountingPeriod> {
        private Directory<UserInfo> directory;

        public InetAccountingPeriodTableModel() {
            super(InetAccountingPeriodTableModel.class.getName());
            try {
                this.directory = ((ClientContext)InetAccountingPeriodPanel.this.getContext()).getDirectory(UserInfo.class, 0);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", 200, 200, 200, "dateFrom", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", 200, 200, 200, "dateTo", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", -1, -1, -1, "userId", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(InetAccountingPeriod inetAccountingPeriod, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("dateFrom".equals(identifier)) {
                return TimeUtils.format((Date)inetAccountingPeriod.getDateFrom(), (String)"dd.MM.yyyy HH:mm:ss");
            }
            if ("dateTo".equals(identifier)) {
                return TimeUtils.format((Date)inetAccountingPeriod.getDateTo(), (String)"dd.MM.yyyy HH:mm:ss");
            }
            if ("userId".equals(identifier)) {
                UserInfo userInfo = this.directory != null ? (UserInfo)this.directory.get(inetAccountingPeriod.getUserId()) : null;
                return userInfo != null ? userInfo.getName() : "??? [ID=" + inetAccountingPeriod.getUserId() + "]";
            }
            return super.getValue((Object)inetAccountingPeriod, column);
        }
    }

    public class PeriodEditor
    extends BGEditorDialog<InetAccountingPeriod> {
        private BGCalendarButton dateFrom;
        private BGTextField timeFrom;
        private BGCalendarButton dateTo;
        private BGTextField timeTo;

        public PeriodEditor(String title, InetAccountingPeriod data) {
            super(title, (Object)data);
            this.dateFrom = new BGCalendarButton();
            this.timeFrom = new BGTextField(8);
            this.dateTo = new BGCalendarButton();
            this.timeTo = new BGTextField(8);
        }

        public void doDialogPanel() {
            this.timeFrom.setHorizontalAlignment(0);
            this.timeTo.setHorizontalAlignment(0);
            this.panel.add((Component)new JLabel("\u0441"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 5, 5), 0, 0));
            this.panel.add((Component)this.dateFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 3), 0, 0));
            this.panel.add((Component)this.timeFrom, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 5), 0, 0));
            this.panel.add((Component)this.dateTo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 3), 0, 0));
            this.panel.add((Component)this.timeTo, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 3), 0, 0));
            this.dateFrom.setLocalDate(TimeUtils.convertDateToLocalDate((Date)((InetAccountingPeriod)this.data).getDateFrom()));
            this.dateFrom.setEnabled(true);
            this.timeFrom.setText(((InetAccountingPeriod)this.data).getDateFrom() == null ? "00:00:00" : TimeUtils.format((Date)((InetAccountingPeriod)this.data).getDateFrom(), (String)"HH:mm:ss"));
            this.timeFrom.setEnabled(true);
            this.dateTo.setLocalDate(TimeUtils.convertDateToLocalDate((Date)((InetAccountingPeriod)this.data).getDateTo()));
            this.dateTo.setEnabled(true);
            this.timeTo.setText(((InetAccountingPeriod)this.data).getDateTo() == null ? "23:59:59" : TimeUtils.format((Date)((InetAccountingPeriod)this.data).getDateTo(), (String)"HH:mm:ss"));
            this.timeTo.setEnabled(true);
        }

        public boolean doApply() throws Exception {
            Date timeTo;
            Calendar timeToCalendar;
            Calendar timeFromCalendar = this.dateFrom.getCalendar();
            if (timeFromCalendar != null) {
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeFromCalendar);
                Calendar timeFromCalendar2 = TimeUtils.parseCalendar((String)this.timeFrom.getText(), (String)"HH:mm:ss");
                if (timeFromCalendar2 != null) {
                    timeFromCalendar.set(11, timeFromCalendar2.get(11));
                    timeFromCalendar.set(12, timeFromCalendar2.get(12));
                    timeFromCalendar.set(13, timeFromCalendar2.get(13));
                }
            }
            if ((timeToCalendar = this.dateTo.getCalendar()) != null) {
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeToCalendar);
                Calendar timeToCalendar2 = TimeUtils.parseCalendar((String)this.timeTo.getText(), (String)"HH:mm:ss");
                if (timeToCalendar2 != null) {
                    timeToCalendar.set(11, timeToCalendar2.get(11));
                    timeToCalendar.set(12, timeToCalendar2.get(12));
                    timeToCalendar.set(13, timeToCalendar2.get(13));
                }
            }
            Date timeFrom = timeFromCalendar != null ? timeFromCalendar.getTime() : null;
            Date date = timeTo = timeToCalendar != null ? timeToCalendar.getTime() : null;
            if (timeFrom == null || timeToCalendar == null || timeFrom.after(timeTo)) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d \u043f\u0435\u0440\u0438\u043e\u0434!");
                return false;
            }
            ((InetAccountingPeriod)this.data).setDateFrom(timeFrom);
            ((InetAccountingPeriod)this.data).setDateTo(timeTo);
            InetAccountingPeriodPanel.this.getAccountingPeriodService().periodUpdate((InetAccountingPeriod)this.data);
            InetAccountingPeriodPanel.this.performAction("refresh");
            return true;
        }
    }
}

