/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.ServiceLinkEditor;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class IPNServiceConfigServiceLink
extends ServiceConfigTabbedPanel {
    private boolean wasInit = false;
    private ServiceLinkEditor editor = new ServiceLinkEditor();
    private BGTable table = new BGTable();
    private BGComboBox<ComboBoxItem> planCb = new BGComboBox();
    private BGTextField planTf = new BGTextField();
    private BGComboBox<ComboBoxItem> service_CB = new BGComboBox();
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();

    public IPNServiceConfigServiceLink() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "service_link");
        this.editor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                IPNServiceConfigServiceLink.this.setData();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    IPNServiceConfigServiceLink.this.editItem();
                }
            }
        });
        this.service_CB.addActionListener(e -> this.setData());
        this.date.setLocalDate(LocalDate.now());
        this.date.addActionListener(e -> this.setData());
        this.planCb.addActionListener(e -> this.setData());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.editor.setVisible(false);
        JPanel planPanel = new JPanel(new GridBagLayout());
        planPanel.setBorder((Border)new BGTitleBorder(" \u041f\u043b\u0430\u043d \u043f\u0440\u0438\u0432\u044f\u0437\u043e\u043a "));
        JButton deleteButton = new JButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        deleteButton.setMargin(new Insets(2, 2, 2, 2));
        JButton cloneButton = new JButton("\u041a\u043b\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        cloneButton.setMargin(new Insets(2, 2, 2, 2));
        JButton createButton = new JButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        createButton.setMargin(new Insets(2, 2, 2, 2));
        JButton renameButton = new JButton("\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c");
        renameButton.setMargin(new Insets(2, 2, 2, 2));
        planPanel.add((Component)this.planCb, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        planPanel.add((Component)this.planTf, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        planPanel.add((Component)cloneButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        planPanel.add((Component)deleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        planPanel.add((Component)createButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        planPanel.add((Component)renameButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel serviceFilterPanel = new JPanel(new GridBagLayout());
        serviceFilterPanel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        serviceFilterPanel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        serviceFilterPanel.add((Component)this.service_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        serviceFilterPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        serviceFilterPanel.add((Component)this.date, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(planPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(serviceFilterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.editor), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPNServiceConfigServiceLink.this.deletePlan();
            }
        });
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPNServiceConfigServiceLink.this.createPlan();
            }
        });
        renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPNServiceConfigServiceLink.this.renamePlan();
            }
        });
        cloneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPNServiceConfigServiceLink.this.clonePlan();
            }
        });
        this.editor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                IPNServiceConfigServiceLink.this.stopEdit();
            }
        });
    }

    public void setData() {
        this.init();
        String planId = ClientUtils.getIdFromComboBox(this.planCb);
        Request req = new Request();
        req.setModule("ipn");
        req.setModuleId(this.getModuleId());
        req.setAction("ServiceLinkInfo");
        req.setAttribute("plan", planId);
        ComboBoxItem service = (ComboBoxItem)this.service_CB.getSelectedItem();
        if (service != null) {
            req.setAttribute("sid", (String)service.getObject());
        }
        req.setAttribute("date", this.date.getDateString());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }

    private void loadPlanList() {
        this.planCb.removeAllItems();
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("ServiceLinkPlanList");
        req.setModuleId(this.getModuleId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.planCb, (Node)XMLUtils.getElement((Document)doc, (String)"list"), (String)"");
        }
        this.planCb.insertItemAt((Object)new ComboBoxItem((Object)"0", "\u041f\u043b\u0430\u043d \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"), 0);
    }

    private void init() {
        if (!this.wasInit) {
            this.loadPlanList();
            this.planCb.setSelectedIndex(0);
            Request req = new Request();
            req.setModule("contract");
            req.setModuleId(this.getModuleId());
            req.setAction("ModuleServices");
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.service_CB.setModel((ComboBoxModel)ClientUtils.buildComboBox((Node)XMLUtils.getNode((Document)doc, (String)"services"), (String)""));
            }
            this.service_CB.insertItemAt((Object)new ComboBoxItem((Object)"0", "---"), 0);
            this.service_CB.setSelectedIndex(0);
            this.wasInit = true;
        }
    }

    public void deleteItem() {
        String id = ClientUtils.getRowId((BGTable)this.table, null, (String)"id");
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule("ipn");
            request.setAction("DeleteServiceLink");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", String.valueOf(id));
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void editItem() {
        String id = ClientUtils.getRowId((BGTable)this.table, null, (String)"id");
        if (id != null) {
            this.startEdit(id);
        }
    }

    public void newItem() {
        this.startEdit("new");
    }

    private void startEdit(String id) {
        this.editor.init("ipn", this.getModuleId());
        this.editor.setId(id);
        if (!id.equals("new")) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("GetServiceLink");
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element serviceLink = XMLUtils.getElement((Document)doc, (String)"service_link");
                this.editor.setData(serviceLink.getAttribute("data"));
                this.editor.setVisible(true);
            }
        } else {
            this.editor.setData(null);
            this.editor.setVisible(true);
        }
    }

    private void stopEdit() {
        if (this.editor.getData() != null) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("UpdateServiceLink");
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.editor.getId());
            req.setAttribute("data", this.editor.getData());
            req.setAttribute("plan", ClientUtils.getIdFromComboBox(this.planCb));
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setData();
            } else {
                this.editor.setVisible(true);
            }
        }
    }

    private void deletePlan() {
        String id = ClientUtils.getIdFromComboBox(this.planCb);
        if (id.equals("0")) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043b\u0430\u043d \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043b\u0430\u043d?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ServiceLinkPlanDelete");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.loadPlanList();
                this.planCb.setSelectedIndex(0);
                this.setData();
            }
        }
    }

    private void clonePlan() {
        String id = ClientUtils.getIdFromComboBox(this.planCb);
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041a\u043b\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043b\u0430\u043d?", "\u041a\u043b\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ServiceLinkPlanClone");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                id = doc.getDocumentElement().getAttribute("id");
                this.loadPlanList();
                ClientUtils.setComboBoxSelection(this.planCb, (Object)id);
                this.setData();
            }
        }
    }

    private void createPlan() {
        String title = this.planTf.getText();
        if (Utils.isBlankString((String)title)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043b\u0430\u043d\u0430!");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ServiceLinkPlanUpdate");
        request.setModuleId(this.getModuleId());
        request.setAttribute("id", 0);
        request.setAttribute("title", title);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            String id = doc.getDocumentElement().getAttribute("id");
            this.loadPlanList();
            ClientUtils.setComboBoxSelection(this.planCb, (Object)id);
            this.setData();
        }
    }

    private void renamePlan() {
        String id = ClientUtils.getIdFromComboBox(this.planCb);
        String title = this.planTf.getText();
        if (Utils.isBlankString((String)title)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043b\u0430\u043d\u0430!");
            return;
        }
        if (id.equals("0")) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u043f\u043b\u0430\u043d \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e!");
            return;
        }
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("ServiceLinkPlanUpdate");
        req.setModuleId(this.getModuleId());
        req.setAttribute("id", id);
        req.setAttribute("title", title);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.loadPlanList();
            ClientUtils.setComboBoxSelection(this.planCb, (Object)id);
        }
    }
}

