/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.netflow.ipn.AdminPortListener;
import bitel.billing.server.netflow.ipn.IPNSnmpWorker;
import bitel.billing.server.netflow.ipn.NetFlowSetup;
import bitel.billing.server.netflow.ipn.Processor;
import bitel.billing.server.netflow.ipn.SourceSelector;
import bitel.billing.server.netflow.ipn.TaskGenerator;
import bitel.billing.server.netflow.ipn.detail.DetailMaker;
import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.AlarmTask;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.flow.SnmpFlowRecord;
import ru.bitel.bgbilling.modules.ipn.server.collector.IPNFlowListener;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.logging.LoggingPrintStream;
import ru.bitel.common.worker.WorkerThreadFactory;

public class Collector {
    private static final Logger logger = LogManager.getLogger();
    private Processor processor = null;

    public Collector(NetFlowSetup setup) {
        File logDirFile;
        String logDir;
        LoggingPrintStream.assignToOutput();
        AlarmSender.initSender((DefaultServerSetup)setup);
        AlarmSender.registerAlarmTask((AlarmTask)new DatabaseCheckTask());
        logger.info("Starting flow collector for IPN...");
        if (setup.getModuleId() < 0) {
            logger.error("incorrect collector.mid!");
            System.exit(3);
        }
        if (Utils.isBlankString((String)(logDir = setup.get("log.dir", null)))) {
            logger.error("log.dir is not defined in properties");
            System.exit(4);
        }
        if (!(logDirFile = new File(logDir)).exists() || !logDirFile.isDirectory()) {
            logger.error("Datalog directory " + logDir + " not exist or is not directory");
            System.exit(5);
        }
        int portAdmin = setup.getInt("port.admin", 2003);
        boolean load = setup.getInt("load", 0) > 0;
        boolean process = setup.getInt("process", 0) > 0;
        logger.info("Load => " + load + "; process => " + process);
        SnmpFlowRecord.FIX_OVERFLOW = setup.getInt("collector.capture.snmp.fixZeroOverflow", 0) > 0;
        ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(1, (ThreadFactory)new WorkerThreadFactory("hrlydtlggr", "flowListener", null));
        IPHourlyDataLogger dataLogger = new IPHourlyDataLogger((ParameterMap)setup, threadPool);
        ArrayList<IPNFlowListener> listeners = new ArrayList<IPNFlowListener>();
        ArrayList<SourceSelector> sourceSelectors = new ArrayList<SourceSelector>();
        String sources = setup.get("process.sources", setup.get("sources", null));
        SourceSelector ss = null;
        SourceSelector processSourceSelector = null;
        if (sources != null) {
            processSourceSelector = ss = new SourceSelector(setup, sources, 3, 4);
            sourceSelectors.add(ss);
        }
        if (load) {
            int recvBufferSize = setup.getInt("netflow.receive.buffer.capacity", 0x200000);
            recvBufferSize = setup.getInt("collector.capture.flow.buffer.capacity", recvBufferSize);
            int soRCVBUF = setup.getInt("netflow.receive.socket.buffer.size", 524288);
            soRCVBUF = setup.getInt("collector.capture.flow.socket.buffer.capacity", soRCVBUF);
            int threadCount = setup.getInt("netflow.thread.count", 8);
            threadCount = setup.getInt("collector.capture.flow.thread.count", threadCount);
            int portNetFlow = setup.getInt("port.netflow", -1);
            if (portNetFlow > 0) {
                if (ss == null) {
                    ss = new SourceSelector(setup, sources, 3, 4);
                    sourceSelectors.add(ss);
                }
                listeners.add(this.addFlowListener(0, setup, dataLogger, ss, portNetFlow, (ParameterMap)setup, threadCount, recvBufferSize, soRCVBUF, sourceSelectors, true));
            }
            SortedMap values = setup.subIndexed("collector.capture.flow.port.");
            for (Map.Entry e : values.entrySet()) {
                ParameterMap params = (ParameterMap)e.getValue();
                portNetFlow = params.getInt("", -1);
                if (portNetFlow <= 0) continue;
                listeners.add(this.addFlowListener((Integer)e.getKey(), setup, dataLogger, ss, portNetFlow, params, threadCount, recvBufferSize, soRCVBUF, sourceSelectors, false));
            }
            if (setup.getInt("collector.capture.snmp", 0) > 0) {
                ParameterMap params = setup.sub("collector.capture.snmp.");
                String snmpSources = params.get("sources", sources);
                SourceSelector snmpSourceSelector = new SourceSelector(setup, snmpSources, 5);
                sourceSelectors.add(snmpSourceSelector);
                IPNSnmpWorker snmpWorker = new IPNSnmpWorker(setup, snmpSourceSelector, dataLogger);
                ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
                scheduledExecutorService.scheduleAtFixedRate((Runnable)((Object)snmpWorker), 5L, params.getLong("period", 60L), TimeUnit.SECONDS);
            }
        }
        TaskGenerator taskGenerator = new TaskGenerator(setup, sourceSelectors, dataLogger, load);
        if (process) {
            this.processor = new Processor(setup);
        }
        new AdminPortListener(listeners, dataLogger, setup, portAdmin, taskGenerator, processSourceSelector, this.processor);
        for (SourceSelector sourceSelector : sourceSelectors) {
            sourceSelector.start();
        }
        if (setup.getBoolean("process.detail", true)) {
            new DetailMaker(setup);
        }
    }

    private IPNFlowListener addFlowListener(int index, NetFlowSetup setup, IPHourlyDataLogger dataLogger, SourceSelector ss, int port, ParameterMap params, int threadCount, int recvBufferSize, int soRCVBUF, List<SourceSelector> sourceSelectors, boolean old) {
        logger.info("Starting FlowListener on port " + port + " [recv_buf_size=" + recvBufferSize + "]");
        String sources = params.get("sources", "0");
        recvBufferSize = params.getInt("buffer.capacity", recvBufferSize);
        soRCVBUF = params.getInt("socket.buffer.capacity", soRCVBUF);
        threadCount = params.getInt("thread.count", threadCount);
        Integer sourceType = null;
        if (old) {
            if (!sources.equals(setup.get("sources", "0"))) {
                ss = new SourceSelector(setup, sources, 3, 4);
                sourceSelectors.add(ss);
            }
        } else {
            sourceType = Source.nameToType((String)params.get("type", ""));
            if (!Source.checkSourceType((int)sourceType)) {
                logger.error("collector.capture.flow.port." + index + ".type=" + params.get("type", null) + " (must be 'netflow' or 'sflow')");
                throw new IllegalArgumentException("type=" + params.get("type", null));
            }
            ss = new SourceSelector(setup, sources, sourceType);
            sourceSelectors.add(ss);
        }
        IPNFlowListener l = IPNFlowListener.newInstance(setup, port, threadCount, recvBufferSize, soRCVBUF, ss, dataLogger, sourceType, sources);
        l.init();
        l.startListener();
        return l;
    }

    public static void main(String[] args) {
        BGNestedContext.push((String)"collector");
        Preferences setup = new Preferences("netflow_ipn");
        int portAdmin = setup.getInt("port.admin", 2000);
        if (args.length > 0) {
            if (args[0].trim().equals("start")) {
                try {
                    NetFlowSetup netFlowSetup = new NetFlowSetup("netflow_ipn");
                    Setup.setSetup((Setup)netFlowSetup);
                    new Collector(netFlowSetup);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                Collector.executeCommand(args, portAdmin);
            }
        } else {
            Collector.showHelp();
        }
    }

    public static void exit() {
        String[] cmd = new String[]{"stop"};
        Collector.main(cmd);
    }

    private static void executeCommand(String[] args, int port) {
        try {
            StringBuffer command = new StringBuffer(args[0]);
            for (int i = 1; i < args.length; ++i) {
                command.append(" ");
                command.append(args[i]);
            }
            byte[] data = command.toString().getBytes("ISO-8859-1");
            DatagramPacket packet = new DatagramPacket(data, data.length);
            packet.setAddress(InetAddress.getByName("127.0.0.1"));
            packet.setPort(port);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            byte[] buffer = new byte[1000000];
            DatagramPacket responsePacket = new DatagramPacket(buffer, buffer.length);
            socket.setSoTimeout(10000);
            socket.receive(responsePacket);
            socket.close();
            System.out.println(new String(responsePacket.getData(), 0, responsePacket.getLength(), "ISO-8859-1"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: [start|stop|status|save|help]");
        sb.append("\nParameters:");
        sb.append("\n\t help                                      - show this help");
        sb.append("\n\t start                                     - starting NetFlow collector");
        sb.append("\n\t stop                                      - stopping NetFlow collector");
        sb.append("\n\t status                                    - current status");
        sb.append("\n\t isload <source_id> <yyyy-MM-dd-HH>        - mark source is load");
        sb.append("\n\t save <source_id> <yyyy-MM-dd-HH> <path>   - save binary log to text on path");
        sb.append("\n\t sourcelist                                - get ip and source id list for external loader");
        System.out.println(sb.toString());
    }
}

