/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;

@XmlRootElement
public class SearchResult<L> {
    private Page page = new Page();
    private PeriodWithTime period = new PeriodWithTime();
    private List<L> list = new ArrayList<L>();
    private String[] sort = new String[0];
    private String[][] attrs = new String[0][0];
    private BigDecimal sum = BigDecimal.ZERO;

    public SearchResult() {
    }

    public SearchResult(SearchParam searchParam) {
        this.setPeriod(searchParam.getPeriod());
        this.setPage(searchParam.getPage());
        this.setSort(searchParam.getSort());
    }

    public SearchResult(Page page) {
        this.setPage(page);
    }

    public SearchResult(Page page, String[] sort) {
        this();
        this.setPage(page);
        this.setSort(sort);
    }

    public SearchResult(Period period, Page page) {
        this();
        this.setPeriod(this.toPeriodWithTime(period));
        this.setPage(page);
    }

    public SearchResult(Period period, Page page, String[] sort) {
        this();
        this.setPage(page);
        this.setSort(sort);
        this.setPeriod(this.toPeriodWithTime(period));
    }

    public SearchResult(PeriodWithTime period, Page page) {
        this();
        this.setPeriod(period);
        this.setPage(page);
    }

    public SearchResult(PeriodWithTime period, Page page, String[] sort) {
        this();
        this.setPage(page);
        this.setSort(sort);
        this.setPeriod(period);
    }

    @XmlElement
    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    @XmlElement
    public Period getPeriod() {
        if (this.period == null) {
            return null;
        }
        Period period2 = new Period();
        if (this.period.getLocalDateTimeFrom() != null) {
            period2.setLocalDateFrom(this.period.getLocalDateTimeFrom().toLocalDate());
        }
        if (this.period.getLocalDateTimeTo() != null) {
            period2.setLocalDateTo(this.period.getLocalDateTimeTo().toLocalDate());
        }
        return period2;
    }

    public PeriodWithTime getPeriodWithTime() {
        return this.period;
    }

    public void setPeriod(PeriodWithTime period) {
        this.period = period;
    }

    public void setPeriod(Period period) {
        this.period = this.toPeriodWithTime(period);
    }

    public void setList(List<L> list) {
        this.list = list;
    }

    @XmlElement
    public List<L> getList() {
        return this.list;
    }

    @XmlElement
    public String[] getSort() {
        return this.sort;
    }

    public void setSort(String[] sort) {
        this.sort = sort;
    }

    public void setAttribute(String key, String value) {
        if (key != null && value != null) {
            boolean result = false;
            for (String[] attr : this.attrs) {
                if (!attr[0].equals(key)) continue;
                attr[1] = value;
                result = true;
                break;
            }
            if (!result) {
                int i = 0;
                String[][] array = new String[this.attrs.length + 1][];
                for (String[] attr : this.attrs) {
                    array[i++] = attr;
                }
                array[i] = new String[]{key, value};
                this.attrs = array;
            }
        }
    }

    public String getAttribute(String key) {
        String value = null;
        if (key != null) {
            for (String[] attr : this.attrs) {
                if (!attr[0].equals(key)) continue;
                value = attr[1];
                break;
            }
        }
        return value;
    }

    public void setAttributes(String[][] attrs) {
        this.attrs = attrs;
    }

    public String[][] getAttributes() {
        return this.attrs;
    }

    @XmlElement
    public BigDecimal getSum() {
        return this.sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    protected PeriodWithTime toPeriodWithTime(Period period) {
        PeriodWithTime periodWithTime = null;
        if (period != null) {
            periodWithTime = new PeriodWithTime();
            if (period.getLocalDateFrom() != null) {
                periodWithTime.setLocalDateTimeFrom(period.getLocalDateFrom().atStartOfDay());
            }
            if (period.getLocalDateTo() != null) {
                periodWithTime.setLocalDateTimeTo(period.getLocalDateTo().atStartOfDay());
            }
        }
        return periodWithTime;
    }

    public static class Builder<T> {
        private SearchResult<T> searchResult = new SearchResult();

        public Builder<T> setPeriod(PeriodWithTime period) {
            this.searchResult.period = period;
            return this;
        }

        public Builder<T> setPeriod(Period period) {
            this.searchResult.period = this.searchResult.toPeriodWithTime(period);
            return this;
        }

        public Builder<T> setPage(Page page) {
            this.searchResult.page = page;
            return this;
        }

        public Builder<T> setSort(String[] sort) {
            this.searchResult.sort = sort;
            return this;
        }

        public Builder<T> setSum(BigDecimal sum) {
            this.searchResult.sum = sum;
            return this;
        }

        public SearchResult<T> build() {
            return this.searchResult;
        }
    }
}

