/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.server.call.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.TimeUtils;

public class ActionNASList
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int mid = this.getIntParameter("mid", -1);
        if (mid < 0) {
            return;
        }
        Element list = this.createElement(this.rootNode, "nas_list");
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        String query = "SELECT id, identifier, ipaddr, type, comment, date1, date2 FROM nas_" + mid + " ORDER BY identifier";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Element element = this.createElement(data, "row");
            element.setAttribute("f0", rs.getString(1));
            element.setAttribute("f1", rs.getString(2));
            element.setAttribute("f2", IPUtils.convertLongIpToString((long)rs.getLong(3)));
            element.setAttribute("f3", rs.getInt(4) == 2 ? "TACACS" : "RADIUS");
            element.setAttribute("f4", TimeUtils.formatPeriod((Date)rs.getDate(6), (Date)rs.getDate(7)));
            element.setAttribute("f5", rs.getString(5));
            Element item = this.createElement(list, "item");
            item.setAttribute("id", rs.getString(1));
            item.setAttribute("title", rs.getString(2) + " (" + rs.getString(5) + ")");
        }
        rs.close();
        ps.close();
    }
}

