/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.bean;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.util.MonthForRecalc;
import bitel.billing.server.util.db.ColumnValue;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public abstract class LoginManager {
    protected Connection con;
    protected String tableName;
    protected int mid;
    private ContractManager contractManager;

    public static LoginManager getLoginManager(String module, Connection con, int moduleId) {
        LoginManager result = null;
        Class<?> clazz = null;
        try {
            if (module.equals("dialup")) {
                clazz = Class.forName("ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginManager");
            } else if (module.equals("voiceip")) {
                clazz = Class.forName("ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLoginManager");
            }
            if (clazz != null) {
                result = (LoginManager)clazz.getConstructors()[0].newInstance(con, moduleId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public LoginManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = "user_login_" + mid;
        this.contractManager = new ContractManager(con);
    }

    public void deleteLogin(int id) {
        try {
            Object query = null;
            PreparedStatement ps = null;
            query = "DELETE FROM user_login_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM user_alias_" + this.mid + " WHERE login_id =?";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM log_login_pswd WHERE mid=? AND lid=?";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, this.mid);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM radius_pair_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            if (ServerUtils.tableExists(this.con, "radius_pair_set_" + this.mid)) {
                query = "DELETE FROM radius_pair_set_" + this.mid + " WHERE id=?";
                ps = this.con.prepareStatement((String)query);
                ps.setInt(1, id);
                ps.executeUpdate();
                ps.close();
            }
            if (ServerUtils.tableExists(this.con, "radius_pair_ip_" + this.mid)) {
                query = "DELETE FROM radius_pair_ip_" + this.mid + " WHERE id=?";
                ps = this.con.prepareStatement((String)query);
                ps.setInt(1, id);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Login getLoginById(int id) {
        Login result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getLoginFromResultSet(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void moveLogin(Login login, int cidFrom, int cidTo, int objectTo, int userId) throws BGException {
        if (login.getDate1() == null) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043b\u043e\u0433\u0438\u043d. \u041d\u0435\u0442 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.");
        }
        if (login.getDate2() == null) {
            login.setDate2(new java.util.Date());
        }
        try {
            this.moveLoginData(login, cidFrom, cidTo);
            String query = "UPDATE user_login_" + this.mid + " SET cid=?, object_id=? WHERE id=?";
            PreparedStatement psMoveLogin = this.con.prepareStatement(query);
            psMoveLogin.setInt(1, cidTo);
            psMoveLogin.setInt(2, objectTo);
            psMoveLogin.setInt(3, login.getId());
            psMoveLogin.executeUpdate();
            psMoveLogin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430: " + e.getMessage());
        }
        ContractUtils cu = new ContractUtils(this.con);
        StringBuilder memoText = new StringBuilder(300);
        memoText.append("\u041b\u043e\u0433\u0438\u043d ");
        memoText.append(login.getLogin());
        memoText.append(" \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ");
        memoText.append(cu.getContractTitle(cidFrom, true));
        memoText.append(" \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ");
        memoText.append(cu.getContractTitle(cidTo, true));
        try (ContractNoteDao contractNoteDao = new ContractNoteDao(this.con);){
            ContractNote contractNote = ContractNote.builder().setTitle("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u043b\u043e\u0433\u0438\u043d").setComment(memoText.toString()).setUserId(userId).setContractId(cidFrom).build();
            contractNoteDao.update((Object)contractNote);
            contractNote.setId(0);
            contractNote.setContractId(cidTo);
            contractNoteDao.update((Object)contractNote);
        }
    }

    public void wrapLogin(Login login, int cidTo, int objectTo, java.util.Date dateClose, java.util.Date dateOpen, int userId) throws BGException, SQLException {
        String attributeSetTable;
        if (login.getDate1() == null) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043b\u043e\u0433\u0438\u043d. \u041d\u0435\u0442 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.");
        }
        if (login.getDate2() != null && TimeUtils.dateBeforeOrEq((java.util.Date)login.getDate2(), (java.util.Date)dateClose)) {
            return;
        }
        if (TimeUtils.dateBeforeOrEq((java.util.Date)dateOpen, (java.util.Date)login.getDate1())) {
            this.moveLogin(login, login.getContractId(), cidTo, objectTo, userId);
            return;
        }
        TableCopier tableCopier = new TableCopier(this.con);
        HashMap<String, ColumnValue> valueMap = new HashMap<String, ColumnValue>();
        valueMap.put("cid", new ColumnValue(true, cidTo));
        valueMap.put("date1", new ColumnValue(true, dateOpen));
        valueMap.put("object_id", new ColumnValue(true, objectTo));
        int newLoginId = tableCopier.copyRecord("user_login_" + this.mid, "id=" + login.getId(), valueMap);
        tableCopier.updateColumn("user_login_" + this.mid, "date2", TimeUtils.formatSQLDate((java.util.Date)dateClose), "id=" + login.getId());
        login.setDate2(dateClose);
        Login loginTo = this.getLoginById(newLoginId);
        String aliasTable = "user_alias_" + this.mid;
        valueMap.clear();
        valueMap.put("login_id", new ColumnValue(true, newLoginId));
        tableCopier.copyRecord(aliasTable, "login_id=" + login.getId(), valueMap);
        String radiusAttributesTable = "radius_pair_" + this.mid;
        if (ServerUtils.tableExists(this.con, radiusAttributesTable)) {
            valueMap.clear();
            valueMap.put("id", new ColumnValue(true, newLoginId));
            tableCopier.copyRecord(radiusAttributesTable, "id=" + login.getId(), valueMap);
        }
        if (ServerUtils.tableExists(this.con, attributeSetTable = "radius_pair_set_" + this.mid)) {
            valueMap.clear();
            valueMap.put("id", new ColumnValue(true, newLoginId));
            tableCopier.copyRecord(attributeSetTable, "id=" + login.getId(), valueMap);
        }
        this.doSpecificWrapActions(newLoginId, dateOpen, dateClose, login, tableCopier);
        ContractUtils cu = new ContractUtils(this.con);
        StringBuilder memoText = new StringBuilder(300);
        memoText.append("\u041b\u043e\u0433\u0438\u043d ");
        memoText.append(login.getLogin());
        memoText.append(" \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ");
        memoText.append(cu.getContractTitle(login.getContractId(), true));
        memoText.append(" \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ");
        memoText.append(cu.getContractTitle(cidTo, true));
        memoText.append(" \u0441 \u0434\u0430\u0442\u044b ");
        memoText.append(TimeUtils.formatDate((java.util.Date)dateOpen));
        try (ContractNoteDao contractNoteDao = new ContractNoteDao(this.con);){
            ContractNote contractNote = ContractNote.builder().setTitle("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u043b\u043e\u0433\u0438\u043d \u0441 \u0434\u0430\u0442\u044b").setComment(memoText.toString()).setUserId(userId).setContractId(login.getContractId()).build();
            contractNoteDao.update((Object)contractNote);
            contractNote.setId(0);
            contractNote.setContractId(cidTo);
            contractNoteDao.update((Object)contractNote);
        }
        this.wrapLoginData(login, loginTo);
    }

    protected abstract void doSpecificWrapActions(int var1, java.util.Date var2, java.util.Date var3, Login var4, TableCopier var5) throws SQLException;

    protected abstract void moveLoginData(Login var1, int var2, int var3) throws SQLException;

    protected abstract void wrapLoginData(Login var1, Login var2) throws SQLException;

    public abstract void recalcAfterMove(MonthForRecalc var1, int var2, int var3) throws SQLException;

    public boolean hasActiveSessions(int loginId) {
        return false;
    }

    public String getLoginAliases(int lid) {
        StringBuffer aliases = new StringBuffer();
        PreparedStatement ps = null;
        String tableName = "user_alias_" + this.mid;
        try {
            if (ServerUtils.tableExists(this.con, tableName)) {
                aliases.append("[ ");
                String query = "SELECT login_alias FROM " + tableName + " WHERE login_id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, lid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    aliases.append((String)(rs.isLast() ? rs.getString(1) : rs.getString(1) + ", "));
                }
                aliases.append(" ]");
                ps.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aliases.toString();
    }

    public List<Login> getContractLogins(int contractId) {
        ArrayList<Login> result = new ArrayList<Login>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? ORDER BY login";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getLoginFromResultSet(rs));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void loginsList(Element logins, int cid) {
        this.loginsList(logins, cid, null, null);
    }

    public void loginsList(Element logins, int cid, java.util.Date dateFrom, java.util.Date dateTo) {
        Document doc = logins.getOwnerDocument();
        for (Login login : this.getContractLogins(cid)) {
            if (dateFrom != null && dateTo != null && !TimeUtils.checkDateIntervalsIntersection((java.util.Date)login.getDate1(), (java.util.Date)login.getDate2(), (java.util.Date)dateFrom, (java.util.Date)dateTo)) continue;
            String id = String.valueOf(login.getId());
            String title = login.getLogin() + this.getLoginAliases(login.getId());
            Element item = doc.createElement("item");
            logins.appendChild(item);
            item.setAttribute("id", id);
            item.setAttribute("title", title);
            item.setAttribute("date1", TimeUtils.formatDate((java.util.Date)login.getDate1()));
            item.setAttribute("date2", TimeUtils.formatDate((java.util.Date)login.getDate2()));
        }
    }

    public String getLoginTitle(int lid) {
        String title = "";
        Login login = this.getLoginById(lid);
        if (login != null) {
            title = String.valueOf(login.getLogin());
        }
        return title;
    }

    public void updatePassword(int lid, String pswd, int userId) {
        try {
            String query = "UPDATE user_login_" + this.mid + " SET pswd=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, pswd);
            ps.setInt(2, lid);
            if (ps.executeUpdate() > 0) {
                ps.close();
                this.logPswdChange(lid, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logPswdChange(int loginId, int userId) {
        String query = "INSERT INTO log_login_pswd VALUES ( now(), ?, ?, ? )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, userId);
            ps.setInt(2, this.mid);
            ps.setInt(3, loginId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void updateAttributes(int lid, List<String[]> attributes) throws SQLException {
        String query = "DELETE FROM radius_pair_" + this.mid + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        ps.executeUpdate();
        ps.close();
        query = "INSERT INTO radius_pair_" + this.mid + " ( id, pair_name, pair_value, pair_realm ) VALUES ( ?, ?, ?, ? )";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        assert (attributes != null);
        for (String[] attr : attributes) {
            assert (attr.length == 3);
            String name = attr[0].trim();
            String value = attr[1].trim();
            String realm = attr[2].trim();
            ps.setString(2, name);
            ps.setString(3, value);
            ps.setString(4, realm);
            ps.executeUpdate();
        }
        ps.close();
    }

    public final Map<String, List<String[]>> loadAVPPairs(Login login) {
        HashMap<String, List<String[]>> avp = new HashMap<String, List<String[]>>();
        try {
            StringBuilder query_sb = new StringBuilder();
            query_sb.append("SELECT pair_name, pair_value, pair_realm FROM radius_pair_");
            query_sb.append(this.mid);
            query_sb.append(" WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query_sb.toString());
            ps.setInt(1, login.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String[]> pairs;
                String pair_realm = rs.getString(3).trim().toLowerCase();
                if (pair_realm.length() == 0) {
                    pair_realm = "default";
                }
                if ((pairs = (ArrayList<String[]>)avp.get(pair_realm)) == null) {
                    pairs = new ArrayList<String[]>();
                    avp.put(pair_realm, pairs);
                }
                pairs.add(new String[]{rs.getString(1), rs.getString(2)});
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return avp;
    }

    public abstract Login addLogin(Login var1, Preferences var2);

    public abstract void updateLogin(Login var1);

    public String checkLoginAvailable(Preferences moduleSetup) {
        String result = null;
        String query = null;
        PreparedStatement ps = null;
        try {
            int login = 0;
            int topNocardLogin = moduleSetup.getInt("top.nocard.login", 10000);
            query = "SELECT MAX(login) FROM user_login_" + this.mid + " WHERE login<" + topNocardLogin;
            ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                login = rs.getInt(1);
            }
            ps.close();
            login = login <= 0 ? 0 : ++login;
            if (login > topNocardLogin) {
                result = "\u041d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 top.nocard.login=" + topNocardLogin;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String checkLogin(Login login) {
        Date sqlDate1 = TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate1());
        Date sqlDate2 = TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate2());
        String query = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            query = "SELECT id FROM " + this.tableName + " WHERE login=? AND id!=?  AND (date1 IS NULL OR ? IS NULL OR date1<=?) AND (date2 IS NULL OR ? IS NULL OR date2>=?)  LIMIT 1";
            ps = this.con.prepareStatement(query);
            ps.setLong(1, login.getLogin());
            ps.setInt(2, login.getId());
            ps.setDate(3, sqlDate2);
            ps.setDate(4, sqlDate2);
            ps.setDate(5, sqlDate1);
            ps.setDate(6, sqlDate1);
            rs = ps.executeQuery();
            if (rs.next()) {
                Contract contract;
                StringBuilder error = new StringBuilder(200);
                error.append("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043b\u043e\u0433\u0438\u043d\u0430 ");
                Login conflictLogin = this.getLoginById(rs.getInt(1));
                if (conflictLogin != null && (contract = this.contractManager.getContractById(conflictLogin.getContractId())) != null) {
                    error.append(", \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ");
                    error.append(contract.getTitle());
                }
                return error.toString();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u041e\u0448\u0438\u0431\u043a\u0430 " + e.getMessage();
        }
        return null;
    }

    public String checkConflictAliases(Login login, Set<String> aliases) {
        Date sqlDate1 = TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate1());
        Date sqlDate2 = TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate2());
        String query = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            query = "SELECT alias.login_id FROM user_alias_" + this.mid + " AS alias  INNER JOIN user_login_" + this.mid + " AS login ON alias.login_id=login.id  WHERE LCASE(alias.login_alias)=LCASE(?) AND alias.login_id!=?  AND (login.date1 IS NULL OR ? IS NULL OR login.date1<=?) AND (login.date2 IS NULL OR ? IS NULL OR login.date2>=?)  LIMIT 1";
            ps = this.con.prepareStatement(query);
            ps.setInt(2, login.getId());
            ps.setDate(3, sqlDate2);
            ps.setDate(4, sqlDate2);
            ps.setDate(5, sqlDate1);
            ps.setDate(6, sqlDate1);
            for (String token : aliases) {
                ps.setString(1, token);
                rs = ps.executeQuery();
                if (rs.next()) {
                    Contract contract;
                    StringBuilder error = new StringBuilder(200);
                    error.append("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0430\u043b\u0438\u0430\u0441\u0430 \"");
                    error.append(token);
                    error.append("\" ");
                    Login conflictLogin = this.getLoginById(rs.getInt(1));
                    if (conflictLogin != null && (contract = this.contractManager.getContractById(conflictLogin.getContractId())) != null) {
                        error.append(", \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ");
                        error.append(contract.getTitle());
                    }
                    return error.toString();
                }
                aliases.add(token);
                rs.close();
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "\u041e\u0448\u0438\u0431\u043a\u0430 " + e.getMessage();
        }
        return null;
    }

    public void updateAliases(int lid, Set<String> aliases) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "DELETE FROM user_alias_" + this.mid + " WHERE login_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, lid);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO user_alias_" + this.mid + " VALUES ( ?, ? )";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, lid);
            for (String al : aliases) {
                ps.setString(2, al);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract Login getLoginFromResultSet(ResultSet var1) throws SQLException;

    public abstract String checkAliases(Login var1, Set<String> var2);

    public void freeResources() {
        this.contractManager.recycle();
    }
}

