/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterDao;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;

public class ActionAddressInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int contractId = this.getIntParameter("cid", -1);
        int parameterId = this.getIntParameter("pid", -1);
        Element address = this.createElement(this.rootNode, "address");
        if (contractId > -1 && parameterId > -1) {
            String selectedKey = "";
            StringBuffer query = new StringBuffer();
            query.append("SELECT param.hid, country.id AS countryid, country.title AS country, street.cityid AS cityid, city.title AS city, ");
            query.append("area.title AS area, quarter.title AS quarter, ");
            query.append("house.streetid AS streetid, street.title AS street, house.frac, house.box_index, ");
            query.append("house.id, house.house, param.pod, param.floor, param.flat, param.room, param.comment, param.format_key, param.address ");
            query.append("FROM contract_parameter_type_2 AS param ");
            query.append("LEFT JOIN address_house AS house ON param.hid=house.id ");
            query.append("LEFT JOIN address_street AS street ON house.streetid=street.id ");
            query.append("LEFT JOIN address_city AS city ON street.cityid=city.id ");
            query.append("LEFT JOIN address_area AS area ON house.areaid=area.id ");
            query.append("LEFT JOIN address_quarter AS quarter ON house.quarterid=quarter.id ");
            query.append("LEFT JOIN address_country AS country ON city.country_id=country.id ");
            query.append("WHERE param.cid=? AND param.pid=?");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                ps.setInt(1, contractId);
                ps.setInt(2, parameterId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        address.setAttribute("hid", rs.getString("hid"));
                        address.setAttribute("index", rs.getString("box_index"));
                        address.setAttribute("cityid", rs.getString("cityid"));
                        address.setAttribute("city", rs.getString("city"));
                        int houseid = rs.getInt("house.id");
                        String temp = rs.getString("area");
                        address.setAttribute("areaValue", temp);
                        if (temp == null) {
                            temp = "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e";
                        }
                        address.setAttribute("area", temp);
                        temp = rs.getString("quarter");
                        address.setAttribute("quarterValue", temp);
                        if (temp == null) {
                            temp = "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e";
                        }
                        address.setAttribute("quarter", temp);
                        address.setAttribute("streetid", rs.getString("streetid"));
                        address.setAttribute("street", rs.getString("street"));
                        address.setAttribute("comment", rs.getString("comment"));
                        address.setAttribute("house", (rs.getInt("house") == 0 ? "" : rs.getString("house")) + rs.getString("frac"));
                        address.setAttribute("flat", rs.getString("flat"));
                        address.setAttribute("room", rs.getString("room"));
                        address.setAttribute("pod", rs.getInt("pod") == 0 ? "" : rs.getString("pod"));
                        address.setAttribute("floor", rs.getInt("floor") == 0 ? "" : rs.getString("floor"));
                        address.setAttribute("address", rs.getString("address"));
                        String paramString = "address.house";
                        List paramList = Utils.toList((String)this.setup.get(paramString, null));
                        Map<String, String> paramMap = new ParameterDao(this.con).getAddressParams("address_house", houseid);
                        Element extraParams = this.createElement(this.rootNode, "extraParams");
                        for (String str : paramList) {
                            if (paramMap.get(str) == null) continue;
                            Element param = this.createElement(extraParams, "param");
                            param.setAttribute("param_title", this.setup.get(paramString + "." + str + ".title", null));
                            param.setAttribute("param_value", paramMap.get(str));
                            param.setAttribute("param_id", str);
                        }
                        selectedKey = rs.getString("format_key");
                        if (houseid > 0) {
                            this.getFormatAddressTable(this.getAddressStruct(rs), parameterId, selectedKey, false);
                        }
                    }
                }
            }
        }
        Element canCreate = this.createElement(address, "create");
        canCreate.setAttribute("value", this.setup.get("address.create", "no"));
    }

    private AddressStruct getAddressStruct(ResultSet rs) throws BGException {
        try {
            return AddressStruct.builder().setIndex(rs.getString("box_index")).setCountry(rs.getString("country")).setCity(rs.getString("city")).setArea(rs.getString("area")).setQuarter(rs.getString("quarter")).setStreet(rs.getString("street")).setHouse(String.valueOf(rs.getInt("house"))).setFrac(rs.getString("frac")).setFlat(rs.getString("flat")).setRoom(rs.getString("room")).setPod(rs.getInt("pod") == 0 ? "" : rs.getString("pod")).setFloor(rs.getInt("floor") == 0 ? "" : rs.getString("floor")).setComment(rs.getString("comment")).build();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

