/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.admin.bean.CommentUpdater;
import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.ContractScriptManager;
import bitel.billing.server.contract.bean.ContractServiceManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScript;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionContractGroupOperation
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String type = this.getParameter("type");
        String cids = this.getParameter("cids");
        if (Utils.notBlankString((String)cids)) {
            List contracts = Utils.toIntegerList((String)cids);
            if ("changeStatus".equals(type)) {
                this.changeStatus(contracts);
            } else if ("openTariff".equals(type)) {
                this.openTariff(contracts);
            } else if ("closeTariff".equals(type)) {
                this.closeTariff(contracts);
            } else if ("changeTariff".equals(type)) {
                this.changeTariff(contracts);
            } else if ("addScript".equals(type)) {
                this.addScript(contracts);
            } else if ("deleteScript".equals(type)) {
                this.deleteScript(contracts);
            } else if ("addModules".equals(type)) {
                this.addModules(contracts);
            } else if ("deleteModules".equals(type)) {
                this.deleteModules(contracts);
            } else if ("addResolvedService".equals(type)) {
                this.addResolvedService(contracts);
            } else if ("deleteResolvedService".equals(type)) {
                this.deleteResolvedService(contracts);
            } else if ("breakResolvedService".equals(type)) {
                this.breakResolvedService(contracts);
            } else if ("addContractTemplateComment".equals(type)) {
                this.addContractTemplateComment(contracts);
            } else if ("addToGroup".equals(type)) {
                this.addToGroup(contracts);
            } else if ("deleteFromGroup".equals(type)) {
                this.deleteFromGroup(contracts);
            } else if ("unblockLimit".equals(type)) {
                this.unblockLimit(contracts);
            }
        }
    }

    private void addModules(List<Integer> contracts) throws BGException {
        String mids = this.getParameter("mids");
        List modules = Utils.toIntegerList((String)mids);
        ContractModuleManager msm = new ContractModuleManager(this.con);
        for (Integer contractId : contracts) {
            if (contractId == null || contractId <= 0) continue;
            for (Integer moduleId : modules) {
                if (moduleId == null || moduleId <= 0) continue;
                msm.addContractModule(contractId, moduleId);
                this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
            }
        }
    }

    private void deleteModules(List<Integer> contracts) throws BGException {
        String moduleIds = this.getParameter("mids");
        List modules = Utils.toIntegerList((String)moduleIds);
        ContractModuleManager contractModuleManager = new ContractModuleManager(this.con);
        for (Integer contractId : contracts) {
            if (contractId == null || contractId <= 0) continue;
            for (Integer moduleId : modules) {
                if (moduleId == null || moduleId <= 0) continue;
                contractModuleManager.deleteContractModule(contractId, moduleId);
                this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
            }
        }
    }

    private void addResolvedService(List<Integer> contracts) throws SQLException {
        String sids = this.getParameter("sids");
        String mids = this.getParameter("mids");
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        String comment = this.getParameter("comment", "");
        List services = Utils.toIntegerList((String)sids);
        PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO contract_service (cid, sid, date1, date2, comment) VALUES (?, ?, ?, ?, ?)");
        PreparedStatement psSelectS = this.con.prepareStatement("SELECT * from contract_service where cid=? AND sid=?");
        PreparedStatement psSelectM = this.con.prepareStatement("SELECT * from contract_module where cid=? AND mid=?");
        psInsert.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
        psInsert.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
        psInsert.setString(5, comment);
        for (Integer cid : contracts) {
            if (cid == null || cid <= 0) continue;
            psSelectM.setInt(1, cid);
            psInsert.setInt(1, cid);
            psSelectS.setInt(1, cid);
            psSelectM.setInt(2, Integer.valueOf(mids));
            ResultSet rs = psSelectM.executeQuery();
            if (rs.next()) {
                for (Integer sid : services) {
                    if (sid == null || sid <= 0) continue;
                    psSelectS.setInt(2, sid);
                    ResultSet rsService = psSelectS.executeQuery();
                    if (!rsService.next()) {
                        psInsert.setInt(2, sid);
                        psInsert.executeUpdate();
                    }
                    rsService.close();
                }
            }
            rs.close();
        }
        psInsert.close();
        psSelectS.close();
        psSelectM.close();
    }

    private void deleteResolvedService(List<Integer> contracts) throws SQLException {
        String sids = this.getParameter("sids");
        List services = Utils.toIntegerList((String)sids);
        PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM contract_service WHERE cid=? AND sid=?");
        for (Integer cid : contracts) {
            if (cid == null || cid <= 0) continue;
            psDelete.setInt(1, cid);
            for (Integer sid : services) {
                if (sid == null || sid <= 0) continue;
                psDelete.setInt(2, sid);
                psDelete.executeUpdate();
            }
        }
        psDelete.close();
    }

    private void breakResolvedService(List<Integer> contracts) throws SQLException, BGException {
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        String sids = this.getParameter("sids");
        List services = Utils.toIntegerList((String)sids);
        if (date1 == null || date2 == null || date1.after(date2)) {
            throw new BGIllegalArgumentException();
        }
        if (services.size() == 0) {
            throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0438!");
        }
        ContractServiceManager man = new ContractServiceManager(this.con);
        ArrayList<ContractService> contractServiceList = new ArrayList<ContractService>(1000);
        for (Integer cid : contracts) {
            if (cid == null || cid <= 0) continue;
            List<ContractService> list = man.getContractServiceList(cid, services, date1, date2);
            contractServiceList.addAll(list);
        }
        date1.add(5, -1);
        date2.add(5, 1);
        for (ContractService s : contractServiceList) {
            ContractService serv1 = s.clone();
            ContractService serv2 = s.clone();
            serv1.setId(0);
            serv2.setId(0);
            serv1.setDateFrom(date2.getTime());
            serv2.setDateTo(date1.getTime());
            man.deleteContractService(s.getId());
            if (serv1.getDateTo() == null || !serv1.getDateFrom().after(serv1.getDateTo())) {
                man.updateContractService("new", serv1);
            }
            if (serv2.getDateFrom() != null && serv2.getDateFrom().after(serv2.getDateTo())) continue;
            man.updateContractService("new", serv2);
        }
    }

    private void changeStatus(List<Integer> contracts) throws SQLException, BGException {
        int newStatus = this.getIntParameter("status", -1);
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        String comment = this.getParameter("comment", "");
        if (newStatus < 0 || date1 == null) {
            throw new BGIllegalArgumentException();
        }
        try (ContractStatusDao contractStatusDao = new ContractStatusDao(this.con);){
            for (Integer contractId : contracts) {
                if (contractId == null || contractId <= 0) continue;
                contractStatusDao.changeStatus(ContractStatus.builder().setContractId(contractId).setStatus(newStatus).setDateFrom(date1).setDateTo(date2).setComment(comment).build(), this.userId);
            }
        }
    }

    private void openTariff(List<Integer> contracts) throws BGException {
        String tids = this.getParameter("tids");
        LocalDate date1 = TimeUtils.convertDateToLocalDate((Date)this.getDateParameter("date1"));
        LocalDate date2 = TimeUtils.convertDateToLocalDate((Date)this.getDateParameter("date2"));
        String comment = this.getParameter("comment", "");
        int position = this.getIntParameter("pos", 0);
        TimeUtils.checkPeriod((Date)this.getDateParameter("date1"), (Date)this.getDateParameter("date2"));
        if (date1 != null) {
            List tariffs = Utils.toIntegerList((String)tids);
            boolean checkDouble = this.setup.get("check.double.tariff", "0").equals("1");
            try (ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);){
                for (Integer contractId : contracts) {
                    if (contractId == null || contractId <= 0) continue;
                    for (Integer tpid : tariffs) {
                        if (tpid == null || tpid <= 0 || checkDouble && contractTariffDao.checkDoubleTariffForContract(contractId, tpid, date1, date2)) continue;
                        ContractTariff contractTariff = ContractTariff.builder().setId(-1).setContractId(contractId).setTariffPlanId(tpid).setPosition(position).setPeriod(new Period(date1, date2)).setComment(comment).setEntityModuleId(0).setEntityId(0).build();
                        contractTariffDao.update(contractTariff);
                        this.context.publishAfterCommit(new ContractTariffChangedEvent(contractId));
                        this.context.publishAfterCommit(new ContractTariffUpdateEvent((int)this.userId, (int)contractId, contractTariff, true));
                    }
                }
            }
        } else {
            throw new BGIllegalArgumentException();
        }
    }

    private void closeTariff(List<Integer> contracts) throws BGException {
        String tids = this.getParameter("tids");
        LocalDate dateClose = TimeUtils.convertDateToLocalDate((Date)this.getDateParameter("date"));
        List tariffs = Utils.toIntegerList((String)tids);
        int position = this.getIntParameter("pos", -1);
        if (dateClose != null) {
            for (Integer contractId : contracts) {
                if (contractId == null || contractId <= 0) continue;
                try (ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);){
                    List<ContractTariff> contractTarifs = contractTariffDao.list(contractId, dateClose);
                    for (Integer tpid : tariffs) {
                        if (tpid == null || tpid <= 0) continue;
                        for (ContractTariff contractTariff : contractTarifs) {
                            if (tpid.intValue() != contractTariff.getTariffPlanId()) continue;
                            contractTariff.getPeriod().setLocalDateTo(dateClose);
                            if (position > 0) {
                                contractTariff.setPosition(position);
                            }
                            contractTariffDao.update(contractTariff);
                            this.context.publishAfterCommit(new ContractTariffChangedEvent(contractId));
                            this.context.publishAfterCommit(new ContractTariffUpdateEvent((int)this.userId, (int)contractId, contractTariff, false));
                        }
                    }
                }
            }
        } else {
            throw new BGIllegalArgumentException();
        }
    }

    private void changeTariff(List<Integer> contracts) throws BGException {
        int tidClose = this.getIntParameter("tid1", -1);
        int tidOpen = this.getIntParameter("tid2", -1);
        LocalDate dateClose = TimeUtils.convertDateToLocalDate((Date)this.getDateParameter("date1"));
        LocalDate dateOpen = TimeUtils.convertDateToLocalDate((Date)this.getDateParameter("date2"));
        String comment = this.getParameter("comment", "");
        int position = this.getIntParameter("pos", 0);
        TimeUtils.checkPeriod((Date)this.getDateParameter("date1"), (Date)this.getDateParameter("date2"));
        if (dateClose != null && dateOpen != null && tidClose > 0 && tidOpen > 0) {
            for (Integer contractId : contracts) {
                if (contractId == null || contractId <= 0) continue;
                try (ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);){
                    List<ContractTariff> contractTarifs = contractTariffDao.list(contractId, dateClose);
                    for (ContractTariff contractTariff : contractTarifs) {
                        if (tidClose != contractTariff.getTariffPlanId()) continue;
                        contractTariff.getPeriod().setLocalDateTo(dateClose);
                        contractTariffDao.update(contractTariff);
                        ContractTariff contractTariffOpen = ContractTariff.builder().setId(-1).setContractId(contractId).setTariffPlanId(tidOpen).setPosition(position).setPeriod(new Period(dateOpen, null)).setComment(comment).setEntityModuleId(0).setEntityId(0).build();
                        contractTariffDao.update(contractTariffOpen);
                        this.context.publishAfterCommit(new ContractTariffChangedEvent(contractId));
                        this.context.publishAfterCommit(new ContractTariffUpdateEvent((int)this.userId, (int)contractId, contractTariff, false));
                        this.context.publishAfterCommit(new ContractTariffUpdateEvent((int)this.userId, (int)contractId, contractTariffOpen, true));
                    }
                }
            }
        } else {
            throw new BGIllegalArgumentException();
        }
    }

    private void addContractTemplateComment(List<Integer> contracts) throws SQLException {
        int templateId = this.getIntParameter("templateId", -1);
        if (templateId > 0) {
            String query = "UPDATE contract SET title_pattern_id=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            for (Integer cid : contracts) {
                ps.setInt(1, templateId);
                ps.setInt(2, cid);
                ps.executeUpdate();
            }
            ps.close();
            new RunTaskDataManager(this.con).addTask(new CommentUpdater(templateId));
        }
    }

    private void addScript(List<Integer> contracts) throws BGException {
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        String comment = this.getParameter("comment", "");
        Boolean addOnlyMissing = this.getBooleanParameter("addOnlyMissing");
        int scriptId = this.getIntParameter("script", -1);
        TimeUtils.checkPeriod((Date)this.getDateParameter("date1"), (Date)this.getDateParameter("date2"));
        if (date1 != null && scriptId != -1) {
            ContractScriptManager manager = new ContractScriptManager(this.con);
            for (Integer cid : contracts) {
                if (cid == null || cid <= 0) continue;
                boolean mustAdd = true;
                if (addOnlyMissing.booleanValue() && manager.getContractScriptByScriptId(cid, scriptId) != null) {
                    mustAdd = false;
                }
                if (!mustAdd) continue;
                ContractScript contractScript = new ContractScript();
                contractScript.setContractId(cid);
                contractScript.setScriptId(scriptId);
                contractScript.setPeriod(new Period(date1 != null ? date1.getTime() : null, date2 != null ? date2.getTime() : null));
                contractScript.setComment(comment);
                manager.updateContractScript(contractScript);
            }
        } else {
            throw new BGIllegalArgumentException();
        }
    }

    private void deleteScript(List<Integer> contracts) throws BGException {
        int scriptId = this.getIntParameter("script", -1);
        if (scriptId == -1) {
            throw new BGIllegalArgumentException();
        }
        ContractScriptManager manager = new ContractScriptManager(this.con);
        manager.deleteScript(scriptId, contracts);
    }

    private void unblockLimit(List<Integer> contracts) {
        boolean BLOCKED = false;
        long gr = this.calcMids(Utils.toIntegerList((String)this.getParameter("mids")));
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            LimitManager lm = new LimitManager(this.con);
            for (Integer cid : contracts) {
                if (cid == null || cid <= 0) continue;
                Contract contract = (Contract)contractDao.get(cid);
                long contractGroups = contract.getGroups();
                if (gr != 0L && (contractGroups & gr) != 0L) continue;
                lm.setLimitManageMode(this.userId, cid, 0);
            }
        }
        catch (BGException e) {
            e.printStackTrace();
        }
    }

    private void addToGroup(List<Integer> contracts) throws SQLException, BGException {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        ContractLabelService contractLabelService = serverContext.getService(ContractLabelService.class, 0);
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET gr=gr|? WHERE id=?");){
            long gr = this.calcMids(Utils.toIntegerList((String)this.getParameter("mids")));
            if (gr > 0L) {
                for (Integer cid : contracts) {
                    if (cid == null || cid <= 0) continue;
                    ps.setLong(1, gr);
                    ps.setInt(2, cid);
                    ps.executeUpdate();
                    contractLabelService.syncLabelAndGroupContract(cid);
                    this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, cid));
                }
            }
        }
    }

    private void deleteFromGroup(List<Integer> contracts) throws SQLException, BGException {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        ContractLabelService contractLabelService = serverContext.getService(ContractLabelService.class, 0);
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET gr=gr&~? WHERE id=?");){
            long gr = this.calcMids(Utils.toIntegerList((String)this.getParameter("mids")));
            if (gr > 0L) {
                for (Integer cid : contracts) {
                    if (cid == null || cid <= 0) continue;
                    ps.setLong(1, gr);
                    ps.setInt(2, cid);
                    ps.executeUpdate();
                    contractLabelService.syncLabelAndGroupContract(cid);
                    this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, cid));
                }
            }
        }
    }

    private long calcMids(List<Integer> groups) {
        long gr = 0L;
        for (Integer mid : groups) {
            if (mid == null || mid <= -1) continue;
            gr |= 1L << mid;
        }
        return gr;
    }
}

