/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import bitel.billing.server.radius.AdminPortListener;
import bitel.billing.server.radius.Antispam;
import bitel.billing.server.radius.RadiusManager;
import bitel.billing.server.radius.RadiusSetup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.processors.CommonKernelEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.ScriptEventProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListener;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.logging.LoggingPrintStream;

public class Radius {
    private RadiusSetup setup = null;
    private RadiusProcessor<?, Nas<?, ?, ?>, ?> processor;
    private static final Logger log = LogManager.getLogger();
    private RadiusManager manager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Radius() {
        BGNestedContext.push((String)"radius");
        LoggingPrintStream.assignToOutput();
        this.initSetup();
        this.manager = new RadiusManager(this.setup, this);
        try {
            BGNestedContext.push((String)"processor");
            RadiusDictionary.reload();
            Antispam.initAntispam((ParameterMap)this.setup);
        }
        finally {
            BGNestedContext.pop();
        }
        String auth_host = this.setup.get("auth.host", "*");
        String acct_host = this.setup.get("acct.host", "*");
        int auth_port = this.setup.getInt("auth.port", 1814);
        int acct_port = this.setup.getInt("acct.port", 1815);
        int admin_port = this.setup.getInt("admin.port", 1899);
        log.info("Starting radius auth_port:" + auth_host + ":" + auth_port + "  acct_port:" + acct_host + ":" + acct_port + " admin_port:" + admin_port);
        try {
            new ScriptEventProcessor(this.setup).start();
            new CommonKernelEventProcessor(this.setup);
        }
        catch (BGException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("\tclass: " + this.setup.get("processor.class", null) + "\n");
        logMessage.append("\tmid: " + this.setup.getModuleId());
        log.info("Init processor \n" + logMessage.toString());
        try {
            Class<?> clazz = Class.forName(this.setup.get("processor.class", null));
            BGNestedContext.push((String)"processor");
            try {
                this.processor = RadiusProcessor.newInstance(clazz.asSubclass(RadiusProcessor.class), this.setup, this.setup.getModuleId());
            }
            catch (Exception e) {
                log.error("Error of init processor: " + e.getLocalizedMessage());
                log.error(e.getMessage(), (Throwable)e);
                System.exit(1);
                return;
            }
            finally {
                BGNestedContext.pop();
            }
            log.info("Starting authentication listener...");
            RadiusListener authListener = new RadiusListener("*".equals(auth_host) ? null : auth_host, auth_port, 524288, 0, this.processor, RadiusListener.Mode.authentication, this.setup, null, 0, 0, Boolean.FALSE);
            authListener.init();
            authListener.startListener();
            log.info("Starting accounting listener...");
            RadiusListener acctListener = new RadiusListener("*".equals(acct_host) ? null : acct_host, acct_port, 524288, 0, this.processor, RadiusListener.Mode.accounting, this.setup, null, 0, 0, Boolean.FALSE);
            acctListener.init();
            acctListener.startListener();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        new AdminPortListener(this.setup, admin_port, this.manager);
        this.setup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("reload".equals(e.getActionCommand())) {
                    Radius.this.reloadConfig();
                }
            }
        });
    }

    private void reloadConfig() {
        BGNestedContext.push((String)"processor");
        try {
            RadiusDictionary.reload();
            Antispam.initAntispam((ParameterMap)this.setup);
        }
        finally {
            BGNestedContext.pop();
        }
    }

    private void initSetup() {
        this.setup = new RadiusSetup("radius");
        RadiusSetup.setSetup(this.setup);
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            if (args[0].equals("start")) {
                new Radius();
            } else {
                RadiusManager.parseParams(args);
            }
        } else {
            RadiusManager.showHelp();
        }
    }

    public static void exit() {
        String[] params = new String[]{"stop"};
        Radius.main(params);
    }

    public RadiusProcessor<?, Nas<?, ?, ?>, ?> getProcessor() {
        return this.processor;
    }
}

