/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.hourly;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;
import ru.bitel.bgbilling.kernel.base.server.datalog.ReadableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyLogFileUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class HourlyDataLog<D extends ReadableDataLog<? extends R>, R extends DataLogReader<?>, K> {
    private static final Logger log = LogManager.getLogger();
    private final List<File> logs;
    private volatile int logIndex = 0;
    private volatile D dataLog;
    protected final Calendar hour;
    private Map<String, Object> readerParams;

    public HourlyDataLog(File path, Calendar hour) {
        this.logs = HourlyLogFileUtils.getLogFile(path, hour);
        this.hour = hour;
    }

    protected static int getDataLogId(File file) {
        Pattern pattern = Pattern.compile("\\.([\\d]+)\\.bgdl");
        Matcher matcher = pattern.matcher(file.getName());
        if (matcher.find()) {
            return Utils.parseInt((String)matcher.group(1));
        }
        return 0;
    }

    protected D newDataLog(File file) throws IOException {
        log.debug("Opening " + file.getAbsolutePath());
        ByteBuffer readBuffer = ByteBuffer.wrap(new byte[4]);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = randomAccessFile.getChannel();
        fileChannel.read(readBuffer);
        readBuffer.flip();
        if (readBuffer.remaining() == 0) {
            log.warn("Datalog file with size=0 " + file.getAbsolutePath());
            fileChannel.close();
            randomAccessFile.close();
            return null;
        }
        fileChannel.position(0L);
        return this.newDataLog(file, randomAccessFile, fileChannel);
    }

    protected D newDataLog(File file, RandomAccessFile randomAccessFile, FileChannel fileChannel) {
        throw new UnsupportedOperationException();
    }

    protected abstract K reader(R var1);

    public synchronized K nextReader(Map<String, Object> params, boolean wait) {
        if (this.dataLog != null && this.dataLog.isEnded()) {
            if (wait) {
                try {
                    this.dataLog.awaitReadersFinish();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.dataLog.close();
                this.dataLog = null;
            }
            catch (IOException e) {
                log.error("IOException", (Throwable)e);
            }
        }
        if (this.dataLog == null || this.dataLog.isEnded()) {
            this.dataLog = null;
            while (this.dataLog == null && this.logs.size() > this.logIndex) {
                File file = this.logs.get(this.logIndex++);
                try {
                    this.dataLog = this.newDataLog(file);
                    if (this.dataLog != null) {
                        GregorianCalendar now;
                        BGDataLog bgDataLog;
                        BGDataLog.Finished finished;
                        this.dataLog.asReader();
                        if (!(this.dataLog instanceof BGDataLog) || (finished = (bgDataLog = (BGDataLog)this.dataLog).getParameter(BGDataLog.FINISHED)) == null || finished.get() != 0 || TimeUtils.compare((Calendar)this.hour, (Calendar)(now = new GregorianCalendar()), (int)11) != 0) continue;
                        this.dataLog.close();
                        this.dataLog = null;
                        continue;
                    }
                    log.warn("Empty datalog file " + file.getAbsolutePath());
                }
                catch (Exception e) {
                    this.dataLog = null;
                    log.error("Error when opening dataLog " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        if (params == null) {
            if (this.readerParams == null) {
                this.readerParams = new HashMap<String, Object>();
            }
            params = this.readerParams;
        }
        return this.reader(this.dataLog != null ? (R)this.dataLog.newReader(params) : null);
    }

    public long length() {
        long result = 0L;
        for (File f : this.logs) {
            result += f.length();
        }
        return result;
    }

    public D getCurrentDataLog() {
        return this.dataLog;
    }

    public List<File> getLogFiles() {
        return this.logs;
    }

    public long lastModified() {
        return this.logs.get(this.logs.size() - 1).lastModified();
    }

    public boolean exists() {
        return this.logs.size() > 0;
    }

    protected static final File path(ParameterMap setup, int sourceId, String key) {
        StringBuilder path = new StringBuilder(100);
        path.append(setup.get(key, null));
        path.append(File.separator + "source_").append(sourceId);
        path.append(File.separator);
        return new File(path.toString());
    }

    public String toString() {
        return this.getClass().getName() + ": " + TimeUtils.format((Calendar)this.hour, (String)"yyyy-MM-dd-HH") + " : " + (this.logIndex > 0 ? this.logs.get(this.logIndex - 1) : null);
    }

    public void close() {
        if (this.dataLog != null) {
            try {
                this.dataLog.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Calendar getHour() {
        return this.hour;
    }

    public long getHourInMillis() {
        return HourlyDataLog.getHour(this.getHour().getTimeInMillis());
    }

    private static final long getHour(long millis) {
        return millis / 3600000L * 3600000L;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

