/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserPermitionsManager;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSActionGroup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class BGSActionGroupDao
extends AbstractIdDao<BGSActionGroup> {
    private UserPermitionsManager userPermitionsManager;

    public BGSActionGroupDao(Connection con) {
        super(con, 0, "bgs_action_group");
        this.userPermitionsManager = new UserPermitionsManager(con);
    }

    public List<BGSActionGroup> getList() throws BGException {
        return this.list(null, null, new Object[0]);
    }

    public List<BGSActionGroup> getByIds(String actionGroupIds) throws BGException {
        ArrayList<BGSActionGroup> result = new ArrayList<BGSActionGroup>();
        if (Utils.isBlankString((String)actionGroupIds)) {
            return result;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + actionGroupIds + ")";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected BGSActionGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        BGSActionGroup actionGroup = new BGSActionGroup();
        int id = rs.getInt("id");
        actionGroup.setId(id);
        actionGroup.setTitle(rs.getString("title"));
        actionGroup.setActions(this.userPermitionsManager.getActions(id, false));
        return actionGroup;
    }

    protected void updateImpl(BGSActionGroup actionGroup) throws BGException, SQLException {
        String query;
        if (actionGroup == null) {
            return;
        }
        String set = " SET title=?, bgs_action_ids=?";
        String string = query = actionGroup.getId() > 0 ? "UPDATE " + this.tableName + set : "INSERT INTO " + this.tableName + set;
        if (actionGroup.getId() > 0) {
            query = query + " WHERE id=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, actionGroup.getTitle());
            String actions = actionGroup.getActions() == null ? "" : Utils.toString(actionGroup.getActions().stream().map(BGSAction::getId).toList(), (String)",");
            ps.setString(2, actions);
            if (actionGroup.getId() > 0) {
                ps.setInt(3, actionGroup.getId());
            }
            ps.executeUpdate();
            if (actionGroup.getId() <= 0) {
                actionGroup.setId(ServerUtils.lastInsertId(this.con));
            }
        }
        this.userPermitionsManager.updateUserActions(actionGroup.getId(), actionGroup.getActions(), false);
    }
}

