/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import bitel.billing.server.util.Config;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitParameters;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ContractLimitManager {
    public static final int VPAY_NOT_PAYOFFED = 0;
    public static final int VPAY_PARTIAL_PAYOFFED = 1;
    public static final int VPAY_PAYOFFED = 2;
    public static final int VPAY_EXPIRED = 3;
    private static final int MODE_DISABLED = 1;
    private static final int MODE_DISABLED_FOR_EXPIRED = 2;
    private Connection con;

    public ContractLimitManager(Connection con) {
        this.con = con;
    }

    private static final List<ContractLimitParameters> load(Setup setup) {
        ArrayList<ContractLimitParameters> result = new ArrayList<ContractLimitParameters>();
        int i = 1;
        Set<Integer> contractLabelIds = null;
        while ((contractLabelIds = ContractLimitManager.getContractLabelIds(setup, i)) != null) {
            String prefix = "contract.limit." + i;
            result.add(new ContractLimitParameters(contractLabelIds, setup.getInt(prefix + ".maxnotpayoffed", 0), setup.getInt(prefix + ".maxpartialpayoffed", 0), setup.getInt(prefix + ".maxexpiredforblock", 0), setup.getInt(prefix + ".mindays", 1), setup.getInt(prefix + ".maxdays", 10), setup.getInt(prefix + ".delaydays", 30), setup.getBigDecimal(prefix + ".minsumm", new BigDecimal(10)), setup.getBigDecimal(prefix + ".maxsumm", new BigDecimal(100)), setup.getBigDecimal(prefix + ".minlimit", new BigDecimal(-100))));
            ++i;
        }
        return result;
    }

    private static Set<Integer> getContractLabelIds(Setup setup, int n) {
        String ids = setup.get("contract.limit." + n + ".label.ids", null);
        if (ids != null) {
            return Utils.toIntegerSet((String)ids);
        }
        if (setup.get("contract.limit." + n + ".groups", null) != null) {
            LogManager.getLogger().error("\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415!!! \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"contract.limit." + n + ".groups\" \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430 \"contract.limit." + n + ".label.ids\"");
        }
        return null;
    }

    public ContractLimitParameters getContractLimitParameters(Setup setup, Contract contract) throws BGException {
        return this.getContractLimitParameters(setup, contract.getId());
    }

    public ContractLimitParameters getContractLimitParameters(Setup setup, int contractId) throws BGException {
        List<ContractLimitParameters> contractLimitParameters = setup.getConfig((int)0, Conf.class).contractLimitParameters;
        if (contractLimitParameters == null) {
            contractLimitParameters = ContractLimitManager.load(setup);
        }
        ContractLabelManager contractLabelManager = new ContractLabelManager(this.con);
        List<Integer> contractLabelIds = contractLabelManager.getContractLabelIds(contractId);
        try {
            for (ContractLimitParameters l : contractLimitParameters) {
                if (!l.getContractLabelIds().stream().anyMatch(a -> contractLabelIds.contains(a))) continue;
                int mode = 1;
                int cnt = 0;
                try (PreparedStatement ps = this.con.prepareStatement("SELECT mode, cnt FROM contract_limit_manage_mode WHERE cid=?");){
                    ps.setInt(1, contractId);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            mode = rs.getInt(1);
                            cnt = rs.getInt(2);
                        }
                    }
                }
                switch (mode) {
                    case 1: {
                        throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", "contractLimitManage.disabled");
                    }
                    case 2: {
                        throw new BGMessageException(setup.get("limit.max.nopayed.msg", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"), "contractLimitManage.disabledForExpired");
                    }
                }
                if (l.getMaxExpiredForBlock() > 0 && l.getMaxExpiredForBlock() <= cnt) {
                    this.setLimitManageMode(0, contractId, 2);
                    throw new BGMessageException(setup.get("limit.max.nopayed.msg", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"), "contractLimitManage.disabledForExpired");
                }
                int notPayoffed = 0;
                int partialPayoffed = 0;
                try (PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(id) FROM contract_limit_manage WHERE cid=? AND status=?");){
                    ps.setInt(1, contractId);
                    ps.setInt(2, 0);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            notPayoffed = rs.getInt(1);
                        }
                    }
                    ps.setInt(2, 1);
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            partialPayoffed = rs.getInt(1);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                if (l.getMaxNotPayoffed() < notPayoffed || l.getMaxPartialPayoffed() < partialPayoffed) {
                    throw new BGMessageException(setup.get("limit.max.current.msg", "\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043e\u043d\u0438\u0437\u0438\u0442\u044c \u043b\u0438\u043c\u0438\u0442. \u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0445 \u0438/\u0438\u043b\u0438 \u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439"), "contractLimitManage.limited");
                }
                return l;
            }
            throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 (\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f) [contractLabelIds=" + Utils.toString(contractLabelIds) + "]", "contractLimitManage.disabled");
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setLimitManageMode(int userId, int contractId, int mode) throws BGException {
        PreparedStatement ps;
        boolean update = false;
        String query = "UPDATE contract_limit_manage_mode SET mode=?, cnt=? WHERE cid=?";
        try {
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, mode);
                ps.setInt(2, 0);
                ps.setInt(3, contractId);
                update = ps.executeUpdate() > 0;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        if (!update) {
            query = "INSERT INTO contract_limit_manage_mode SET cid=?, mode=?";
            try {
                ps = this.con.prepareStatement(query);
                try {
                    ps.setInt(1, contractId);
                    ps.setInt(2, mode);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        query = "INSERT INTO log_contract_limit_manage_mode VALUES ( now(), ?, ?, ? )";
        try {
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, userId);
                ps.setInt(2, mode);
                ps.setInt(3, contractId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private static class Conf
    extends Config {
        final List<ContractLimitParameters> contractLimitParameters;

        public Conf(int moduleId, ParameterMap moduleSetup, Setup serverSetup) {
            super(moduleId, moduleSetup, serverSetup);
            this.contractLimitParameters = ContractLimitManager.load(serverSetup);
        }
    }
}

