/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.function.Function;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.function.ThrowingFunction;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public abstract class AbstractAutopaymentManager
extends AbstractDao<Autopayment> {
    public AbstractAutopaymentManager(Connection con, String tableNamePrefix, int moduleId) {
        super(con, moduleId, tableNamePrefix + "_autopayment");
    }

    public Autopayment getAutopayment(int id) throws BGException {
        Autopayment autopayment = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ").append(this.tableName).append(" WHERE id = ").append(id);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                autopayment = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return autopayment;
    }

    public Autopayment getCurrentAutopayment(int contractId) throws BGException {
        Autopayment autopayment = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE contract_id=? AND ISNULL( date2 )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    autopayment = this.getFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return autopayment;
    }

    protected void updateImpl(Autopayment autopayment) throws BGException, SQLException {
        this.updateAutopayment(autopayment);
    }

    public Autopayment updateAutopayment(Autopayment autopayment) throws BGException {
        if (autopayment != null) {
            try {
                StringBuilder query = new StringBuilder();
                query.append(autopayment.getId() > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName);
                query.append(" SET contract_id=?, date1=?, date2=?, sum=?, mode=?, mode_data=?, data=?, access_token=?");
                if (autopayment.getId() > 0) {
                    query.append(" WHERE id=").append(autopayment.getId());
                }
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, autopayment.getContractId());
                if (autopayment.getPeriod() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)autopayment.getPeriod().getDateFrom()));
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)autopayment.getPeriod().getDateTo()));
                } else {
                    ps.setTimestamp(index++, null);
                    ps.setTimestamp(index++, null);
                }
                ps.setBigDecimal(index++, autopayment.getSum());
                ps.setInt(index++, autopayment.getMode().getCode());
                ps.setString(index++, autopayment.getModeData());
                ps.setString(index++, autopayment.getData());
                ps.setString(index++, autopayment.getAccessToken());
                ps.executeUpdate();
                if (autopayment.getId() < 1) {
                    autopayment.setId(ServerUtils.lastInsertId(this.con));
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return autopayment;
    }

    public void searchAutopayment(SearchResult<Autopayment> searchResult, int contractId) throws BGException {
        if (searchResult != null && contractId > 0) {
            try {
                Page page = searchResult.getPage();
                List list = searchResult.getList();
                String queryWhere = " WHERE contract_id = ?";
                String query = "SELECT * FROM " + this.tableName + queryWhere + (page != null ? page.sqlLimit() : "");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(index++, contractId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
                index = 1;
                ps = this.con.prepareStatement("SELECT COUNT(*) FROM " + this.tableName + queryWhere);
                ps.setInt(index++, contractId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    if (page == null) continue;
                    page.setRecordCount(rs.getInt(1));
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void searchActivateAutopayment(SearchResult<Autopayment> searchResult, Date date, int mode) throws BGException {
        if (searchResult != null && date != null) {
            String query = "SELECT * FROM " + this.tableName + " WHERE mode=? AND NOT ISNULL( date1 ) AND date1 < ? AND ( ISNULL( date2 ) OR date2 >= ? )";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                List list = searchResult.getList();
                int index = 1;
                ps.setInt(index++, mode);
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)date));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)date));
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void searchCurrentAutopayment(SearchResult<Autopayment> searchResult, Date date, int mode) throws BGException {
        if (searchResult != null && date != null) {
            try {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                int autopaymentWeekDay = calendar.get(7);
                int autopaymentMonthDay = calendar.get(5);
                List list = searchResult.getList();
                String query = "SELECT * FROM " + this.tableName + " WHERE mode=? AND NOT ISNULL( date1 ) AND date1 < ? AND ( ISNULL( date2 ) OR date2 >= ? )";
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(index++, mode);
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)date));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)date));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Preferences modeDataMap;
                    Autopayment autopayment = this.getFromRS(rs);
                    Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
                    if ((mode != AutopaymentMode.WEEK.getCode() || autopaymentWeekDay != modeDataMap.getInt("autopayment.mode.week.day", 1)) && (mode != AutopaymentMode.MONTH.getCode() || autopaymentMonthDay != modeDataMap.getInt("autopayment.mode.month.day", 1))) continue;
                    list.add(autopayment);
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    protected Autopayment getFromRS(ResultSet rs) throws SQLException, BGException {
        return Autopayment.builder().setId(rs.getInt("id")).setContractId(rs.getInt("contract_id")).setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date1"), (Date)rs.getTimestamp("date2"))).setSum(rs.getBigDecimal("sum")).setMode(AutopaymentMode.getAutopaymentModeByCode(rs.getInt("mode"))).setModeData(rs.getString("mode_data")).setData(rs.getString("data")).setAccessToken(rs.getString("access_token")).build();
    }

    public <T extends BGAbstractTransaction> T registerAutopayment(int contractId, ContractAutopaymentMode mode, Function<BigDecimal, T> registerOrder) throws BGException, BGMessageException {
        Autopayment autopayment = this.getCurrentAutopayment(contractId);
        if (autopayment != null) {
            if (autopayment.getMode() != AutopaymentMode.OFF) {
                this.autopaymentOff(autopayment);
            }
            if (mode.getMode() != autopayment.getMode()) {
                autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                this.updateAutopayment(autopayment);
                autopayment = null;
            }
        } else if (mode.getMode() == AutopaymentMode.OFF) {
            throw new BGMessageException("\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.", "autopayment.notFound");
        }
        if (autopayment == null) {
            autopayment = Autopayment.builder().setContractId(contractId).build();
        }
        BGAbstractTransaction result = null;
        if (mode.getMode() == AutopaymentMode.OFF) {
            autopayment.setMode(AutopaymentMode.OFF);
            autopayment.setModeData("");
            autopayment.setSum(BigDecimal.ZERO);
            autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
            autopayment.setAccessToken(null);
        } else {
            mode.toAutopayment(autopayment);
            try {
                result = (BGAbstractTransaction)registerOrder.apply(autopayment.getSum());
            }
            catch (Exception e) {
                if (e instanceof BGRuntimeException) {
                    if (e.getCause() instanceof BGException) {
                        throw (BGException)e.getCause();
                    }
                    throw new BGException((Throwable)e);
                }
                if (e instanceof BGException) {
                    throw (BGException)e.getCause();
                }
                throw new BGException((Throwable)e);
            }
        }
        this.updateAutopayment(autopayment);
        return (T)result;
    }

    public void autopaymentOff(Autopayment autopayment) throws BGException {
    }

    public void invokeAutopayment(int contractId, BigDecimal amount) throws BGException {
        throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    public static <T> Autopayment registerAutopayment(Connection con, int moduleId, AbstractAutopaymentManager autopaymentManager, int contractId, ContractAutopaymentMode mode, ThrowingFunction<Autopayment, T> registerFunction) throws BGException {
        Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
        if (autopayment != null) {
            if (autopayment.getMode() != AutopaymentMode.OFF) {
                autopaymentManager.autopaymentOff(autopayment);
            }
            if (mode.getMode() != autopayment.getMode()) {
                autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                autopaymentManager.updateAutopayment(autopayment);
                autopayment = null;
            }
        } else if (mode.getMode() == AutopaymentMode.OFF) {
            autopaymentManager.close();
            throw new BGMessageException("\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.", "autopayment.notFound");
        }
        if (autopayment == null) {
            autopayment = Autopayment.builder().setContractId(contractId).build();
        }
        if (mode.getMode() == AutopaymentMode.OFF) {
            autopayment.setMode(AutopaymentMode.OFF);
            autopayment.setModeData("");
            autopayment.setSum(BigDecimal.ZERO);
            autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
            autopayment.setAccessToken(null);
        } else {
            mode.toAutopayment(autopayment);
            if (registerFunction != null) {
                registerFunction.applyThrows((Object)autopayment);
            }
        }
        autopaymentManager.updateAutopayment(autopayment);
        autopaymentManager.close();
        return autopayment;
    }

    public static void unregisterAutopayment(Connection con, int moduleId, AbstractAutopaymentManager autopaymentManager, int contractId) throws BGException {
        Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
        if (autopayment != null) {
            autopaymentManager.autopaymentOff(autopayment);
            autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
            autopaymentManager.updateAutopayment(autopayment);
        }
    }
}

