/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectParamDirectory
extends BGUPanel {
    private ObjectParameterGroupAttr contractObjectParam = null;
    private JTextArea comment = new JTextArea();
    private JCheckBox history = new JCheckBox("\u0438\u0441\u0442\u043e\u0440\u0438\u044f");
    private BGTextField title = new BGTextField();
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGComboBox<ComboBoxItem> type_CB = new BGComboBox();
    private ObjectParamTableModel tableModel = new ObjectParamTableModel();
    private ContractObjectService contractObjectService;

    public ObjectParamDirectory() {
        this.editor.setVisible(false);
    }

    protected void jbInit() {
        this.editor.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editor.setLayout(new GridBagLayout());
        this.type_CB.addItem((Object)new ComboBoxItem((Object)"1", "\u0442\u0435\u043a\u0441\u0442"));
        this.type_CB.addItem((Object)new ComboBoxItem((Object)"2", "\u0441\u043f\u0438\u0441\u043e\u043a"));
        this.type_CB.addItem((Object)new ComboBoxItem((Object)"3", "\u0434\u0430\u0442\u0430"));
        this.type_CB.addItem((Object)new ComboBoxItem((Object)"4", "\u0430\u0434\u0440\u0435\u0441"));
        this.type_CB.addItem((Object)new ComboBoxItem((Object)"5", "\u0444\u043b\u0430\u0433"));
        this.type_CB.setMinimumSize(new Dimension(150, 24));
        this.type_CB.setPreferredSize(new Dimension(150, 24));
        this.comment.setMargin(new Insets(3, 3, 3, 3));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.type_CB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.title, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.history, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        JPanel panelComment = new JPanel(new GridBagLayout());
        panelComment.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelComment.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 5, 0), 0, 0));
        this.editor.add((Component)panelComment, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectParamDirectory.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ContractObjectService getContractObjectService() {
        if (this.contractObjectService == null) {
            this.contractObjectService = (ContractObjectService)((ClientContext)this.getContext()).getWebService(ContractObjectService.class);
        }
        return this.contractObjectService;
    }

    private void stopEdit(boolean save) {
        if (!save) {
            this.editor.setVisible(false);
            return;
        }
        if (Utils.isBlankString((String)this.title.getText())) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
            return;
        }
        this.contractObjectParam.setTitle(this.title.getText());
        this.contractObjectParam.setType(Utils.parseInt((String)ClientUtils.getIdFromComboBox(this.type_CB)));
        this.contractObjectParam.setComment(this.comment.getText());
        this.contractObjectParam.setHistory(this.history.isSelected());
        try {
            this.getContractObjectService().objectParamUpdate(this.contractObjectParam);
            this.editor.setVisible(false);
            this.performAction("refresh");
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void startEdit() {
        if (this.contractObjectParam == null || this.contractObjectParam.getId() < 1) {
            this.title.setText("");
            this.comment.setText("");
            this.type_CB.setSelectedIndex(0);
            this.history.setSelected(false);
        } else {
            try {
                this.contractObjectParam = this.getContractObjectService().objectParamGet(this.contractObjectParam.getId());
                this.title.setText(this.contractObjectParam.getTitle());
                ClientUtils.setComboBoxSelection(this.type_CB, (int)this.contractObjectParam.getType());
                this.comment.setText(this.contractObjectParam.getComment());
                this.history.setSelected(this.contractObjectParam.isHistory());
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
        this.editor.setVisible(true);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.tableModel.setData(this.getContractObjectService().objectParamSearch().getList()));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.contractObjectParam = new ObjectParameterGroupAttr();
            this.type_CB.setEnabled(true);
            this.startEdit();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.contractObjectParam = (ObjectParameterGroupAttr)((Object)((Object)this.tableModel.getSelectedRow()));
            if (this.contractObjectParam != null) {
                this.type_CB.setEnabled(false);
                this.startEdit();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            this.contractObjectParam = (ObjectParameterGroupAttr)((Object)((Object)this.tableModel.getSelectedRow()));
            if (this.contractObjectParam != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.getContractObjectService().objectParamDelete(this.contractObjectParam.getId());
                this.contractObjectParam = null;
                this.performAction("refresh");
            }
        });
    }

    class ObjectParamTableModel
    extends BGTableModel<ObjectParameterGroupAttr> {
        public ObjectParamTableModel() {
            super(ObjectParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430", 100, 100, 100, "typeName", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 500, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u0441\u0442\u043e\u0440\u0438\u044f", 80, 80, 80, "history", true);
        }
    }
}

