/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.common.BGDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.BooleanTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamBooleanEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamDateEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEmailEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamListEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamMultiListEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamPhoneEditorDialog;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractParameterData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractPatternInfo;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractTariffData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;

public class PatternMasterDialog
extends BGDialog {
    private MasterStep masterStep = MasterStep.START;
    private String result = null;
    private int resultContractId;
    private ContractPatternInfo contractPatternInfo;
    private ContractCreateData contractCreateData;
    private CardLayout cardLayout = new CardLayout();
    private JPanel panel = new JPanel(this.cardLayout);
    private ContractTariffTableModel tariffTableModel = new ContractTariffTableModel();
    private ContractParameterTableModel parameterTableModel = new ContractParameterTableModel();

    public PatternMasterDialog(ContractPatternInfo contractPatternInfo, ContractCreateData contractCreateData) {
        this.contractPatternInfo = contractPatternInfo;
        this.contractCreateData = contractCreateData;
        this.setTitle("\u041c\u0430\u0441\u0442\u0435\u0440 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.setModal(true);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.add(this.panel, "Center");
        this.add(this.getButtonPanel(), "South");
        this.showNextPanel();
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private JPanel getContractParameterPanel() {
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        font = new FontUIResource(new Font(font.getName(), font.getStyle(), font.getSize() + 2));
        int fontHeight = this.getFontMetrics(font).getHeight() + 6;
        final FontUIResource textFont = font;
        final BGUTable table = new BGUTable((TableModel)((Object)this.parameterTableModel)){

            public TableCellEditor getCellEditor(int row, int column) {
                switch (((ContractParameterData)PatternMasterDialog.this.parameterTableModel.getRows().get(row)).getType()) {
                    case TEXT: {
                        JTextField field = new JTextField();
                        field.setFont(textFont);
                        field.setMargin(new Insets(0, 0, 0, 0));
                        return new DefaultCellEditor(field);
                    }
                }
                return null;
            }
        };
        table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        table.setFont((Font)font);
        table.setRowHeight(fontHeight);
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ContractParameterData rowData = (ContractParameterData)PatternMasterDialog.this.parameterTableModel.getSelectedRow();
                    ContractParamEditorData data = new ContractParamEditorData();
                    data.setEntityType(EntityType.NEW_CONTRACT_PARAMETER);
                    data.setParameterId(rowData.getId());
                    data.setParameterTitle(rowData.getTitle());
                    data.setClientContext(PatternMasterDialog.this.getContext());
                    data.setValue(rowData.getValue());
                    switch (rowData.getType()) {
                        case PHONE: {
                            try {
                                String formats = ((ContractParameterService)PatternMasterDialog.this.getContext().getWebService(ContractParameterService.class, 0)).paramPhoneFormats();
                                new ContractParamPhoneEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0422\u0435\u043b\u0435\u0444\u043e\u043d\"", data, formats).open();
                                rowData.setValue(data.getValue());
                            }
                            catch (Exception ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                            }
                            break;
                        }
                        case EMAIL: {
                            new ContractParamEmailEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"E-mail\"", data).open();
                            rowData.setValue(data.getValue());
                            break;
                        }
                        case ADDRESS: {
                            new ContractParamAddressEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0410\u0434\u0440\u0435\u0441\"", data).open();
                            rowData.setValue(data.getValue());
                            break;
                        }
                        case LIST: {
                            new ContractParamListEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0421\u043f\u0438\u0441\u043e\u043a\"", data).open();
                            rowData.setValue(data.getValue());
                            break;
                        }
                        case MULTILIST: {
                            new ContractParamMultiListEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u041c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043e\u043a\"", data).open();
                            rowData.setValue(data.getValue());
                            break;
                        }
                        case DATE: {
                            new ContractParamDateEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0414\u0430\u0442\u0430\"", data).open();
                            rowData.setValue(data.getValue());
                            break;
                        }
                        case TEXT: {
                            table.editCellAt(PatternMasterDialog.this.parameterTableModel.getSelectedRowIndex(), 3);
                            break;
                        }
                        case BOOLEAN: {
                            new ContractParamBooleanEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0424\u043b\u0430\u0433\"", data).open();
                            rowData.setValue(data.getValue());
                            break;
                        }
                        case CONTRACT: {
                            break;
                        }
                    }
                }
            }
        });
        try {
            this.parameterTableModel.setData(((ContractPatternService)this.getContext().getWebService(ContractPatternService.class, 0)).contractPatternContractParameterList(this.contractCreateData.getPatternId()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        panel.add((Component)new BGTitleLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)1000, (int)500), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel() {
        BGUAction nextAction = new BGUAction("next", "\u0414\u0430\u043b\u0435\u0435"){

            public void actionPerformed(ActionEvent e) {
                while (true) {
                    switch (PatternMasterDialog.this.masterStep) {
                        case PARAM: {
                            if (PatternMasterDialog.this.parameterTableModel.getRows().stream().anyMatch(a -> a.isRequired() && a.getValue() == null)) {
                                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b \u0432\u0441\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u043e\u043b\u044f");
                                return;
                            }
                            PatternMasterDialog.this.contractCreateData.setContractParameters(PatternMasterDialog.this.parameterTableModel.getRows().stream().map(a -> a.getValue()).toList());
                            try {
                                ((ContractService)PatternMasterDialog.this.getContext().getWebService(ContractService.class, 0)).contractCreateValidateParameters(PatternMasterDialog.this.contractCreateData);
                            }
                            catch (Exception ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                                return;
                            }
                            if (!PatternMasterDialog.this.showNextPanel()) break;
                            return;
                        }
                        case TARIFF: {
                            if (!PatternMasterDialog.this.tariffTableModel.getRows().stream().anyMatch(a -> a.isSelected())) {
                                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043d\u0438 \u043e\u0434\u0438\u043d \u0442\u0430\u0440\u0438\u0444");
                                return;
                            }
                            PatternMasterDialog.this.contractCreateData.setContractTariffs(PatternMasterDialog.this.tariffTableModel.getRows().stream().filter(a -> a.isSelected()).map(a -> ContractTariff.builder().setTariffPlanId(a.getId()).setPeriod(a.getPeriod()).setPosition(a.getPos()).build()).toList());
                            try {
                                ((ContractService)PatternMasterDialog.this.getContext().getWebService(ContractService.class, 0)).contractCreateValidateTariffs(PatternMasterDialog.this.contractCreateData);
                            }
                            catch (Exception ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                                return;
                            }
                            if (!PatternMasterDialog.this.showNextPanel()) break;
                            return;
                        }
                        case CREATE: {
                            try {
                                PatternMasterDialog.this.resultContractId = ((ContractService)PatternMasterDialog.this.getContext().getWebService(ContractService.class, 0)).contractCreate(PatternMasterDialog.this.contractCreateData);
                                PatternMasterDialog.this.setVisible(false);
                            }
                            catch (Exception ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                            }
                            return;
                        }
                    }
                }
            }
        };
        BGUAction cancelAction = new BGUAction("cancel", "\u041e\u0442\u043c\u0435\u043d\u0430"){

            public void actionPerformed(ActionEvent e) {
                PatternMasterDialog.this.setVisible(false);
            }
        };
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new JButton((Action)nextAction), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)new JButton((Action)cancelAction), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 0, 0), 0, 0));
        return panel;
    }

    private boolean showNextPanel() {
        String stepName = this.masterStep.name();
        List<String> masterSteps = this.contractPatternInfo.getMasterStep();
        for (int i = 0; i < masterSteps.size(); ++i) {
            if (!stepName.equals(masterSteps.get(i))) continue;
            stepName = i + 1 == masterSteps.size() ? MasterStep.CREATE.name() : masterSteps.get(i + 1);
            break;
        }
        this.masterStep = MasterStep.valueOf(stepName);
        if (this.masterStep == MasterStep.PARAM) {
            this.panel.add((Component)this.getContractParameterPanel(), "contractParameter");
            this.cardLayout.show(this.panel, "contractParameter");
            return true;
        }
        if (this.masterStep == MasterStep.TARIFF) {
            this.panel.add((Component)this.getContractTariffPanel(), "contractTariff");
            this.cardLayout.show(this.panel, "contractTariff");
            return true;
        }
        if (this.masterStep == MasterStep.CREATE) {
            return false;
        }
        return false;
    }

    private JPanel getContractTariffPanel() {
        try {
            List<ContractTariffData> data = ((ContractPatternService)this.getContext().getWebService(ContractPatternService.class, 0)).contractPatternTariffList(this.contractPatternInfo.getId());
            data.forEach(a -> a.setPeriod(new Period(this.contractCreateData.getDateFrom(), null)));
            this.tariffTableModel.setData(data);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        font = new FontUIResource(new Font(font.getName(), font.getStyle(), font.getSize() + 2));
        int fontHeight = this.getFontMetrics(font).getHeight() + 6;
        BGUTable table = new BGUTable((TableModel)((Object)this.tariffTableModel));
        table.setFont((Font)font);
        table.setRowHeight(fontHeight);
        table.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        panel.add((Component)new BGTitleLabel("\u0412\u044b\u0431\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430(\u043e\u0432) \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)1000, (int)500), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        return panel;
    }

    public String getResult() {
        return this.result;
    }

    public int getResultContractId() {
        return this.resultContractId;
    }

    static enum MasterStep {
        START,
        PARAM,
        TARIFF,
        CREATE;

    }

    class ContractTariffTableModel
    extends BGTableModel<ContractTariffData> {
        public ContractTariffTableModel() {
            super(ContractTariffTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("X", Boolean.class, 70, 70, 70, "selected", true, true, (TableCellRenderer)new BooleanTableCellRenderer());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, 300, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 250, 250, 250, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ContractTariffData rowData = (ContractTariffData)((Object)this.getRows().get(rowIndex));
            String identitfier = this.getIdentifier(columnIndex);
            if ("selected".equals(identitfier)) {
                rowData.setSelected((Boolean)value);
                return;
            }
            super.setValueAt(value, rowIndex, columnIndex);
        }
    }

    class ContractParameterTableModel
    extends BGTableModel<ContractParameterData> {
        public ContractParameterTableModel() {
            super(ContractParameterTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0422\u0438\u043f", 70, 70, 70, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u0431\u044f\u0437\u0430\u0442.", 70, 70, 70, "required", true);
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 200, 300, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 200, 300, -1, "value", true, (TableCellRenderer)((Object)new ParamTableCellRenderer()));
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3 && ((ContractParameterData)this.getRows().get(rowIndex)).getType() == EntitySpecAttrType.TEXT;
        }

        public Object getValueAt(ContractParameterData val, int column) throws BGException {
            if (column == 3) {
                if (val.getValue() == null) {
                    return null;
                }
                return switch (val.getType()) {
                    case EntitySpecAttrType.TEXT -> ((EntityAttrText)val.getValue()).getValue();
                    case EntitySpecAttrType.EMAIL -> ((EntityAttrEmail)val.getValue()).toString();
                    case EntitySpecAttrType.PHONE -> ((EntityAttrPhone)val.getValue()).toString();
                    case EntitySpecAttrType.LIST -> ((EntityAttrList)val.getValue()).toString();
                    case EntitySpecAttrType.MULTILIST -> ((EntityAttrMultiList)val.getValue()).toString();
                    case EntitySpecAttrType.DATE -> ((EntityAttrDate)val.getValue()).toString();
                    case EntitySpecAttrType.ADDRESS -> ((EntityAttrAddress)val.getValue()).toString();
                    case EntitySpecAttrType.BOOLEAN -> ((EntityAttrBoolean)val.getValue()).toString();
                    default -> "";
                };
            }
            return super.getValue((Object)val, column);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ContractParameterData rowData = (ContractParameterData)this.getRows().get(rowIndex);
            switch (rowData.getType()) {
                case TEXT: {
                    rowData.setValue((EntityAttr)(Utils.notBlankString((String)((String)value)) ? new EntityAttrText(0, rowData.getId(), (String)value) : null));
                    break;
                }
                default: {
                    super.setValueAt(value, rowIndex, columnIndex);
                }
            }
        }
    }

    static class ParamTableCellRenderer
    extends HorizontalAlignmentTableCellRenderer {
        ParamTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = "[\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e]";
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

