/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatusLog;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class StatusLogPanel
extends BGUPanel {
    private int objectId = 0;
    private List<Status> statusList = null;
    private JLabel logCount = new JLabel();
    private BGControlPanelPages pages = new BGControlPanelPages();
    private StatusLogTableModel statusLogTableModel = new StatusLogTableModel();
    private ContractStatusService contractStatusService = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanle(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)new BGUTable((TableModel)((Object)this.statusLogTableModel))), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.pages.addPropertyChangeListener(a -> {
            if (a.getPropertyName().startsWith("to")) {
                this.loadStatusLogData();
            }
        });
    }

    private JPanel getTopPanle() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.logCount, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public void loadStatusLogData() {
        this.statusLogTableModel.deleteRows();
        this.pages.getPage().setPageCount(0);
        if (this.objectId > -1) {
            Async.ofWithTry(() -> {
                SearchResult<ContractStatusLog> searchResult = this.getContractStatusService().contractStatusLogSearch(((ClientContext)this.getContext()).getContractId(), this.objectId, this.pages.getPage());
                this.statusLogTableModel.setData(searchResult.getList());
                this.pages.setPage(searchResult.getPage());
            });
        }
    }

    public void setStatusList(List<Status> statusList) {
        this.statusList = statusList;
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = (ContractStatusService)((ClientContext)this.getContext()).getWebService(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.statusList == null) {
                try {
                    this.statusList = this.getContractStatusService().getStatusList(false);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            this.pages.setPageIndex(1);
            this.loadStatusLogData();
        });
    }

    class StatusLogTableModel
    extends BGTableModel<ContractStatusLog> {
        private Directory<UserInfo> directory;

        public StatusLogTableModel() {
            super(StatusLogTableModel.class.getName());
            this.directory = null;
            try {
                this.directory = ((ClientContext)StatusLogPanel.this.getContext()).getDirectory(UserInfo.class);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 200, "period", false).setTableCellRenderer(PeriodTableCellRenderer.DEFAULT);
            this.addColumn("\u0414\u0430\u0442\u0430", 200, 200, 200, "date", false).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, 300, "status", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 100, 200, 300, "userId", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        public Object getValueAt(ContractStatusLog val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("userId".equals(identifier)) {
                UserInfo userInfo = this.directory.get(val.getUserId());
                return userInfo != null ? userInfo.getGuiTitle() : "??? [ID#" + val.getUserId() + "]";
            }
            if ("status".equals(identifier)) {
                return StatusLogPanel.this.statusList.stream().filter(a -> a.getId() == val.getStatus()).map(a -> a.getGuiTitle()).findFirst().orElseGet(() -> val.getStatus() == -1 ? "\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430" : "??? #" + val.getStatus());
            }
            if ("period".equals(identifier)) {
                return new Period(val.getDate1(), val.getDate2());
            }
            return super.getValue((Object)val, column);
        }
    }
}

