/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.event.CustomerPanelReinitEvent;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamFPanel;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamUPanel;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContactType;
import ru.bitel.bgbilling.kernel.customer.common.service.CustomerService;
import ru.bitel.common.client.AbstractBGUPanel;

public class CustomerParamPanel
extends BGUPanel
implements EventSubscriber<CustomerPanelReinitEvent> {
    private Customer.CustomerType customerType = Customer.CustomerType.FIZ_CUSTOMER;
    private CustomerParamFPanel customerFParamPanel = null;
    private CustomerParamUPanel customerUParamPanel = null;
    private CustomerService customerService = null;
    private ContractParameterService contractParameterService = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        EventBus.subscribe(CustomerPanelReinitEvent.class, (EventSubscriber)this);
    }

    public void onEvent(CustomerPanelReinitEvent event) {
        if (event.getContractId() == ((ClientContext)this.getContext()).getContractId()) {
            SwingUtilities.invokeLater(this::reinit);
        }
    }

    private void reinit() {
        this.removeAll();
        this.refresh();
        this.revalidate();
        this.repaint();
    }

    ContractParameterService getContractParameterService() {
        if (this.contractParameterService == null) {
            this.contractParameterService = (ContractParameterService)((ClientContext)this.getContext()).getPort(ContractParameterService.class);
        }
        return this.contractParameterService;
    }

    CustomerService getCustomerService() {
        if (this.customerService == null) {
            this.customerService = (CustomerService)((ClientContext)this.getContext()).getPort(CustomerService.class);
        }
        return this.customerService;
    }

    public void updateCustomerValue(String fieldKey, String text) {
        try {
            JSONObject customer = ((ClientContext)this.getContext()).getCustomer();
            customer.put("customer", (Object)new JSONObject(this.getCustomerService().customerParameterUpdate(((ClientContext)this.getContext()).getCustomerId(), fieldKey, text)).getJSONObject("customer"));
            EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void updateCustomerContact(CustomerContactType contactType, JSONArray data) {
        try {
            JSONObject customer = ((ClientContext)this.getContext()).getCustomer();
            customer.put("customer", (Object)new JSONObject(this.getCustomerService().customerContactUpdate(((ClientContext)this.getContext()).getCustomerId(), contactType, data.toString())).getJSONObject("customer"));
            switch (this.customerType) {
                case FIZ_CUSTOMER: {
                    this.customerFParamPanel.contacts.forEach(a -> a.setData());
                    break;
                }
                case JUR_CUSTOMER: {
                    this.customerUParamPanel.contacts.forEach(a -> a.setData());
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void updateCustomerBank(JSONArray data) {
        try {
            JSONObject customer = ((ClientContext)this.getContext()).getCustomer();
            customer.put("customer", (Object)new JSONObject(this.getCustomerService().customerBankUpdate(((ClientContext)this.getContext()).getCustomerId(), data.toString())).getJSONObject("customer"));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void refresh() {
        this.performAction("refresh");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            try {
                JSONObject customer = ((ClientContext)this.getContext()).getCustomer();
                this.customerType = customer == null ? null : Customer.CustomerType.defineType(customer.optString("personType"));
                int customerId = ((ClientContext)this.getContext()).getCustomerId();
                if (this.getComponentCount() == 0 && customerId > 0) {
                    if (this.customerType == Customer.CustomerType.JUR_CUSTOMER) {
                        this.customerUParamPanel = new CustomerParamUPanel(this);
                    } else {
                        this.customerFParamPanel = new CustomerParamFPanel(this);
                    }
                    this.add((Component)((Object)(this.customerType == Customer.CustomerType.JUR_CUSTOMER ? this.customerUParamPanel : this.customerFParamPanel)), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            if (((ClientContext)this.getContext()).getCustomerId() > 0) {
                if (this.customerType == Customer.CustomerType.JUR_CUSTOMER && this.customerUParamPanel != null) {
                    this.customerUParamPanel.setData();
                } else if (this.customerFParamPanel != null) {
                    this.customerFParamPanel.setData();
                }
            }
        });
    }
}

