/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.common;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.common.SerialUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Event
implements Serializable {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(Event.class);
    @XmlAttribute(name="ts")
    private final long timestamp;
    @XmlAttribute
    private final int moduleId;
    @XmlAttribute
    private final int pluginId;
    @XmlAttribute(name="cid")
    private final int contractId;
    @XmlAttribute(name="scid")
    private final int superContractId = -1;
    @XmlAttribute
    private final int userId;
    protected static int NO_MODULE = -1;
    protected static int NO_PLUGIN = -1;
    protected static int CONTRACT_GLOBAL = -1;
    transient String messageID;
    @XmlAttribute(name="lg")
    private boolean logFunctionProcess = true;
    @XmlAttribute
    private String source;
    private transient Calendar generateTime;

    protected Event() {
        this.timestamp = -1L;
        this.moduleId = -1;
        this.pluginId = -1;
        this.contractId = -1;
        this.userId = -1;
    }

    public Event(int moduleId, int pluginId, int contractId, int userId) {
        this.timestamp = System.currentTimeMillis();
        this.moduleId = moduleId;
        this.pluginId = pluginId;
        this.contractId = contractId;
        this.userId = userId;
    }

    public Event(int moduleId, int contractId, int userId) {
        this(moduleId, NO_PLUGIN, contractId, userId);
    }

    public void prepareMessage(Message message) throws JMSException {
        message.setIntProperty("moduleId", this.moduleId);
        message.setIntProperty("pluginId", this.pluginId);
        message.setIntProperty("cid", this.contractId);
        message.setIntProperty("scid", -1);
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getContractId() {
        return this.contractId;
    }

    public int getSuperContractId() {
        return -1;
    }

    public int getUserId() {
        return this.userId;
    }

    @Deprecated
    public int getTypeId() {
        return -1;
    }

    @Deprecated
    public Calendar getGenerateTime() {
        return this.getTime();
    }

    public Calendar getTime() {
        if (this.generateTime == null) {
            this.generateTime = new GregorianCalendar();
            this.generateTime.setTimeInMillis(this.timestamp);
        }
        return this.generateTime;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getPluginId() {
        return this.pluginId;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getDestination(Class<?> clazz) {
        return "BG.Event." + clazz.getName();
    }

    public boolean isLogFunctionProcess() {
        return this.logFunctionProcess;
    }

    public void setLogFunctionProcess(boolean logFunctionProcess) {
        this.logFunctionProcess = logFunctionProcess;
    }

    protected boolean serializeAsObject() {
        return false;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    protected void toString(StringBuilder sb) {
    }

    public String toString() {
        StringBuilder result = new StringBuilder(50).append("Event[");
        result.append(this.getClass().getName());
        result.append("] moduleId: ").append(this.moduleId != NO_MODULE ? Integer.valueOf(this.moduleId) : "no");
        result.append("; pluginId: ").append(this.pluginId != NO_PLUGIN ? Integer.valueOf(this.pluginId) : "no");
        result.append("; contractId: ").append(this.contractId != CONTRACT_GLOBAL ? Integer.valueOf(this.contractId) : "global");
        result.append("; superContractId: ").append(-1);
        result.append("; userId: ").append(this.userId);
        this.toString(result);
        result.append("; source: ").append(this.source);
        result.append("; timestamp: ").append(this.timestamp);
        return result.toString();
    }
}

