/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractServiceManager;
import bitel.billing.server.tariff.TariffTreesCache;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractCreatedEvent;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeriesManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public abstract class AbstractRadiusProcessor<C extends NasConnection<?>, N extends Nas<C, ?, ?>, P>
extends RadiusProcessor<C, N, P> {
    private static final Logger logger = LogManager.getLogger();
    private final boolean checkService;
    private Date startTime = new Date();

    public AbstractRadiusProcessor(Setup setup, String module, int moduleId, NasList<C, N> nasList) throws BGException {
        super(setup, module, moduleId, nasList);
        this.checkService = setup.getModuleSetup(moduleId).getInt("check.service", setup.getInt("check.service", 0)) > 0;
    }

    protected void checkLoginAndContract(Login login, Contract contract) {
        if (login == null) {
            logger.error("Login is null!!!");
        } else if (contract == null) {
            logger.error("Contract is null!!!");
        } else {
            if (login.getId() <= 0) {
                logger.error("Login id <= 0!");
            }
            if (contract.getId() <= 0) {
                logger.error("Contract id <= 0");
            }
            if (contract.getTitle() == null) {
                logger.error("Contract title is NULL!");
            }
        }
    }

    protected int executeError(Connection con, N nas, RadiusPacket request, RadiusPacket response, int cid, int lid, int errorCode, int log_record_id) {
        response.setStringAttribute(-1, 18, String.valueOf(errorCode));
        String query = null;
        PreparedStatement ps = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
            String table_name = "log_error_" + String.valueOf(this.moduleId) + "_" + dateFormat.format(new GregorianCalendar().getTime());
            this.checkErrorTable(con, table_name);
            query = "INSERT INTO " + table_name + " (dt, cid, lid, login, nas_id, nas_port, error_code, log_rec_id) VALUES  ( NOW(), ?, ?, ?, ?, ?, ?, ? )";
            ps = con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, lid);
            ps.setString(3, request.getStringAttribute(-1, 1, "<null>"));
            ps.setInt(4, ((Nas)nas).getId());
            ps.setString(5, String.valueOf(request.getIntAttribute(-1, 5, -1)));
            ps.setInt(6, errorCode);
            ps.setInt(7, log_record_id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return errorCode;
    }

    private void checkErrorTable(Connection con, String table_name) throws SQLException {
        String query = "CREATE TABLE " + table_name + "( dt datetime, cid int, lid int,  login char(50), nas_id int, nas_port char(30), error_code int not null, log_rec_id int not null, KEY dt (dt), KEY cid (cid), KEY lid (lid), KEY nas_id (nas_id) )";
        ServerUtils.checkAndCreatePeriodicTableName(con, table_name, query);
    }

    protected abstract Login getLogin(N var1, RadiusPacket var2, RadiusPacket var3, Connection var4, String var5);

    protected abstract Login getLogin(Connection var1, int var2, Card var3);

    @Override
    protected void accessRequestImpl(RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, Date date, RadiusSession<N, P> radiusSession, int logRecordId, ConnectionSet connectionSet) {
        super.accessRequestImpl(req, nas, request, response, date, radiusSession, logRecordId, connectionSet);
        byte result = response.getCode();
        if ((result == 2 || result == 3) && radiusSession.login != null && radiusSession.contract != null) {
            try {
                EventProcessor.getInstance().request(this.newRadiusAuthenticationEvent(request, response, radiusSession, logRecordId));
            }
            catch (BGException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract LocalEvent newRadiusAuthenticationEvent(RadiusPacket var1, RadiusPacket var2, RadiusSession<N, P> var3, int var4);

    @Override
    protected int authentication(RadiusListenerWorker<?> req, N nas, RadiusSession<N, P> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        return this.authenticationImpl(req, nas, session, request, response, connectionSet, log_record_id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int authenticationImpl(RadiusListenerWorker<?> req, N nas, RadiusSession<N, P> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id, boolean realtimeTariff) {
        Connection con = connectionSet.getConnection();
        Login login = null;
        Contract contract = null;
        boolean authOk = false;
        int errorCode = 0;
        String userName = session.userName;
        ModuleSetup moduleSetup = this.setup.getModuleSetup(this.moduleId);
        int cardModuleId = moduleSetup.getInt("card.module.id", -1);
        ContractManager contrM = new ContractManager(con);
        logger.debug("Finding login..");
        AbstractRadiusProcessor abstractRadiusProcessor = this;
        synchronized (abstractRadiusProcessor) {
            login = this.getLogin(nas, request, response, con, userName);
            logger.debug("login={} cardModuleId={}", (Object)login, (Object)cardModuleId);
            if (login != null) {
                contract = contrM.getContractById(login.getContractId());
                authOk = true;
                logger.debug("Login found: " + login.getId());
            } else if (login == null && cardModuleId > 0) {
                logger.debug("Find in cards");
                CardManager cm = new CardManager(con, cardModuleId);
                Card card = null;
                long topNocardLogin = moduleSetup.getLong("top.nocard.login", 100000L);
                long longUserName = Utils.parseLong((String)userName);
                if (longUserName > 0L && longUserName > topNocardLogin) {
                    card = cm.findCard(userName);
                }
                if (card == null) {
                    logger.debug("Card not found");
                    errorCode = 14;
                } else {
                    logger.debug("Card found, checking..");
                    if (!card.checkPeriod(new Date())) {
                        logger.debug("Card expired");
                        errorCode = 8;
                    } else if (card.getStatus() == 0) {
                        logger.debug("Card lock");
                        errorCode = 9;
                    } else if (card.getStatus() == 3) {
                        logger.debug("Card activated for balance");
                        errorCode = 10;
                    } else if (!((Nas)nas).canActivateCard(card)) {
                        logger.debug("Cant't activate card at this NAS");
                        errorCode = 17;
                    } else {
                        boolean pinResultOK = session.checkPassword((Nas<?, ?, ?>)nas, request, response, card.getCardPinCode(), ((Nas)nas).getSecret(), request.authenticator);
                        if (!pinResultOK) {
                            logger.debug("Card error [ bad pin-code ]");
                            errorCode = 1;
                        } else {
                            authOk = true;
                        }
                    }
                    if (card != null && authOk) {
                        if (card.getStatus() == 1) {
                            HashMap<String, Object> titleParams = new HashMap<String, Object>(4);
                            CardSeriesManager csm = new CardSeriesManager(con, cardModuleId);
                            String cs = csm.getSeriesTitle(card.getSeriesId());
                            titleParams.put("card", card.getCardCode());
                            titleParams.put("card_series", cs);
                            try (ContractDao contractDao = new ContractDao(con, 0);){
                                ContractCreateData data = ContractCreateData.builder().setPatternId(card.getPatternId()).setDateFrom(new Date()).setPassword(card.getCardPinCode()).setTitleParams(titleParams).build();
                                int contractId = contractDao.createFromPattern(data, true).getId();
                                contract = contrM.getContractById(contractId);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            card.setContractId(contract.getId());
                            try {
                                cm.addCardToContract(con, (Calendar)new GregorianCalendar(), card, contract.getId());
                                cm.activated(card, 2);
                                EventProcessor.getInstance().request(new ContractCreatedEvent(contract.getNewContract()));
                                login = this.getLogin(con, contract.getId(), card);
                                authOk = true;
                            }
                            catch (BGException e) {
                                logger.error(e.getMessage(), (Throwable)e);
                                authOk = false;
                            }
                        } else if (card.getStatus() == 2 && card.getType() == 1) {
                            contract = contrM.getContractById(card.getContractId());
                            login = this.getLogin(con, contract.getId(), card);
                            authOk = true;
                        } else {
                            errorCode = 8;
                            authOk = false;
                        }
                    }
                }
            } else {
                authOk = false;
                errorCode = 14;
            }
        }
        if (authOk) {
            this.checkLoginAndContract(login, contract);
        }
        if (authOk) {
            logger.debug("Checking access allow...");
            if (!login.getStatus()) {
                logger.debug("Login access deny...");
                errorCode = 26;
                authOk = false;
            }
        }
        if (authOk) {
            session.login = login;
            logger.debug("Checking password...");
            if (!session.checkPassword((Nas<?, ?, ?>)nas, request, response, login.getPswd(), ((Nas)nas).getSecret(), request.authenticator)) {
                logger.debug("Login password error");
                errorCode = 2;
                authOk = false;
            }
        }
        if (authOk) {
            logger.debug("Checking contract status");
            if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, contract.getStatus())) {
                logger.debug("Contract not open...");
                errorCode = 33;
                authOk = false;
            }
        }
        if (authOk) {
            boolean checkBalanceLast = moduleSetup.getBoolean("check.balance.last", false);
            if (!checkBalanceLast) {
                boolean bl = authOk = (errorCode = this.checkBalance(con, contract, errorCode)) == 0;
                if (authOk) {
                    errorCode = this.authorization(req, nas, session, request, response, connectionSet, log_record_id, contrM, contract, login, userName);
                    authOk = errorCode == 0;
                }
            } else {
                errorCode = this.authorization(req, nas, session, request, response, connectionSet, log_record_id, contrM, contract, login, userName);
                boolean bl = authOk = errorCode == 0;
                if (authOk) {
                    boolean bl2 = authOk = (errorCode = this.checkBalance(con, contract, errorCode)) == 0;
                }
            }
        }
        if (errorCode != 0) {
            int cid = contract != null ? contract.getId() : 0;
            int lid = login != null ? login.getId() : 0;
            this.executeError(con, nas, request, response, cid, lid, errorCode, log_record_id);
        }
        if (session != null) {
            session.contract = contract;
            session.login = login;
            session.errorCode = errorCode;
        }
        return errorCode;
    }

    private int checkBalance(Connection con, Contract contract, int errorCode) {
        logger.debug("Checking balance...");
        BalanceUtils balanceUtils = new BalanceUtils(con);
        BigDecimal summa = balanceUtils.getBalanceOut(new Date(), contract.getId());
        BigDecimal limit = contract.getBalanceLimit();
        balanceUtils.close();
        if (summa.compareTo(limit) < 0) {
            errorCode = 4;
        }
        return errorCode;
    }

    protected boolean checkService(Connection con, int contractId, Set<Integer> sidSet) {
        boolean result = false;
        logger.debug("checkService = {}", (Object)this.checkService);
        if (!this.checkService) {
            result = true;
        } else {
            logger.debug("Checking services...");
            try {
                ContractServiceManager csManager = new ContractServiceManager(con);
                List<ContractService> csList = csManager.getContractServiceList(contractId, new GregorianCalendar());
                for (ContractService cs : csList) {
                    sidSet.remove(cs.getServiceId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean bl = result = sidSet.size() == 0;
            if (!result && logger.isDebugEnabled()) {
                logger.debug("Not all services allowed...");
                for (Integer sid : sidSet) {
                    logger.debug((Object)sid);
                }
            }
        }
        return result;
    }

    protected void addCommonStatusData(StringBuilder report) {
        report.append("\n");
        report.append(ServerUtils.uptimeStatus(this.startTime));
        report.append("\n");
        report.append(Utils.memoryStatus());
        report.append("\n");
        report.append("Trees in cache: ");
        report.append(TariffTreesCache.getCache().getCacheStatus());
        report.append("\n");
        report.append(this.setup.getPoolStatus());
    }
}

