/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.CityItem;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractAddressDao;

abstract class AbstractCityItemDao<B extends CityItem>
extends AbstractAddressDao<B>
implements Directory<B> {
    public AbstractCityItemDao(Connection con, String tableName) {
        super(con, tableName);
    }

    protected B getFromRS(ResultSet rs) throws SQLException, BGException {
        Country country = new Country();
        country.setId(rs.getInt("country.id"));
        country.setTitle(rs.getString("country.title"));
        City city = new City();
        city.setId(rs.getInt("city.id"));
        city.setCountryId(rs.getInt("city.country_id"));
        city.setTitle(rs.getString("city.title"));
        city.setCountry(country);
        CityItem result = (CityItem)this.newBean();
        result.setId(rs.getInt(this.tableName + ".id"));
        result.setTitle(rs.getString(this.tableName + ".title"));
        result.setCity(city);
        result.setCityId(city.getId());
        return (B)result;
    }

    protected void updateImpl(B b) throws BGException, SQLException {
        CityItem old = b.getId() > 0 ? (CityItem)this.get(b.getId()) : null;
        boolean update = old != null;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET cityid=?, title=?" + (update ? " WHERE " : ", ") + "id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, b.getCity() != null ? b.getCity().getId() : b.getCityId());
            ps.setString(index++, b.getTitle());
            ps.setInt(index++, b.getId());
            ps.executeUpdate();
            if (!update) {
                b.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    @Override
    public List<B> list() throws BGException {
        return super.list(null, this.tableName + ".title", new Object[0]);
    }

    @Override
    public B get(String title) throws BGException {
        return (B)((CityItem)super.get(this.tableName + ".title=?", title));
    }

    public B get(String title, int cityId) throws BGException {
        return (B)((CityItem)super.get(this.tableName + ".title=? AND " + this.tableName + ".cityid=?", title, cityId));
    }

    public List<B> list(int cityId) throws BGException {
        return this.list("cityid=?", this.tableName + ".title", cityId);
    }

    public List<B> list(int cityId, String title) throws BGException {
        return this.list("(? OR cityid=?) AND (? OR " + this.tableName + ".title LIKE ?)", this.tableName + ".title", cityId <= 0, cityId, Utils.isBlankString((String)title), title + "%");
    }

    protected List<B> list(String filter, String orderBy, Object ... params) throws BGException {
        try {
            return this.listImpl(new Page(), filter, orderBy, params);
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    protected List<B> listImpl(Page page, String filter, String orderBy, Object ... params) throws BGException, SQLException {
        String join = "LEFT JOIN address_city AS city ON " + this.tableName + ".cityid=city.id LEFT JOIN address_country AS country on city.country_id=country.id ";
        return super.listImpl(page, "country.*, city.*, " + this.tableName + ".*", join, filter, orderBy, params);
    }

    protected String getQueryById() {
        return "SELECT * FROM " + this.tableName + " LEFT JOIN address_city AS city ON " + this.tableName + ".cityid=city.id LEFT JOIN address_country AS country ON city.country_id=country.id WHERE " + this.tableName + ".id=?";
    }

    @Override
    protected String getQuery() {
        return "SELECT " + this.tableName + ".*, city.*, country.* FROM " + this.tableName + " LEFT JOIN address_city AS city ON " + this.tableName + ".cityid=city.id LEFT JOIN address_country AS country ON city.country_id=country.id WHERE ";
    }

    protected <T> void searchStreetList(SearchResult<T> searchResult, int cityId, String mask, Function<ResultSet, T> function) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " LEFT JOIN address_city AS city on " + this.tableName + ".cityid=city.id LEFT JOIN address_country AS country on city.country_id=country.id WHERE true" + (String)(cityId > 0 ? " AND " + this.tableName + ".cityid=?" : "") + (String)(mask != null && !mask.isEmpty() ? " AND " + this.tableName + ".title LIKE ?" : "") + " ORDER BY " + this.tableName + ".title" + (page != null ? page.sqlLimit() : "");
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                if (cityId > 0) {
                    ps.setInt(index++, cityId);
                }
                if (mask != null && !mask.isEmpty()) {
                    ps.setString(index++, mask);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(function.apply(rs));
                    }
                }
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

