/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.domain.server;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;
import ru.bitel.oss.kernel.directories.domain.common.event.DomainModifiedEvent;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntime;
import ru.bitel.oss.kernel.directories.domain.server.bean.DomainDao;

public class DomainRuntimeMap
implements EventListener<DomainModifiedEvent> {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentMap<Integer, DomainRuntimeMap> moduleMap = new ConcurrentHashMap<Integer, DomainRuntimeMap>();
    private volatile Map<Integer, DomainRuntime> idMap;
    private final ConcurrentMap<Integer, AtomicReference<DomainRuntime>> referenceMap = new ConcurrentHashMap<Integer, AtomicReference<DomainRuntime>>();

    public static DomainRuntimeMap getInstance(ConnectionSet connectionSet) throws BGException {
        return DomainRuntimeMap.getInstance0(connectionSet);
    }

    public static DomainRuntimeMap getInstance(Connection con) throws BGException {
        return DomainRuntimeMap.getInstance0(con);
    }

    private static DomainRuntimeMap getInstance0(Object con) throws BGException {
        DomainRuntimeMap result = (DomainRuntimeMap)moduleMap.get(0);
        if (result == null) {
            final EventProcessor ep = EventProcessor.getInstance();
            final DomainRuntimeMap newResult = new DomainRuntimeMap();
            new Thread("domainRuntimeMap-load"){

                @Override
                public void run() {
                    try {
                        ep.addListener(newResult, DomainModifiedEvent.class, 0, null);
                    }
                    catch (BGException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }.start();
            if (con instanceof ConnectionSet) {
                newResult.load(((ConnectionSet)con).getConnection());
            } else {
                newResult.load((Connection)con);
            }
            result = moduleMap.putIfAbsent(0, newResult);
            if (result == null) {
                result = newResult;
            }
        }
        return result;
    }

    public static DomainRuntimeMap getInstance() throws BGException {
        ServerContext context = (ServerContext)((Object)ThreadContext.get(ServerContext.class));
        return DomainRuntimeMap.getInstance(context.getConnectionSet());
    }

    private DomainRuntimeMap() {
    }

    @Override
    public void notify(DomainModifiedEvent event, EventListenerContext ctx) throws BGException {
        this.load(ctx.getConnection());
    }

    public DomainRuntime get(int id) {
        return this.idMap.get(id);
    }

    public AtomicReference<DomainRuntime> getRef(int id) {
        return (AtomicReference)this.referenceMap.get(id);
    }

    public Map<Integer, DomainRuntime> getMap() {
        return this.idMap;
    }

    private synchronized void load(Connection con) throws BGException {
        HashMap<Integer, DomainRuntime> idMap = new HashMap<Integer, DomainRuntime>();
        logger.info("Loading domainRuntimeMap");
        try (DomainDao domainDao = new DomainDao(con);){
            Domain root = domainDao.tree();
            this.load(idMap, root, null);
        }
        this.idMap = idMap;
        for (Map.Entry e : idMap.entrySet()) {
            this.referenceMap.compute((Integer)e.getKey(), (k, v) -> {
                if (v == null) {
                    return new AtomicReference<DomainRuntime>((DomainRuntime)e.getValue());
                }
                v.set((DomainRuntime)e.getValue());
                return v;
            });
        }
        this.referenceMap.keySet().retainAll(idMap.keySet());
    }

    private List<DomainRuntime> load(Map<Integer, DomainRuntime> map, Domain parent, DomainRuntime parentRuntime) throws BGException {
        ArrayList<DomainRuntime> result = new ArrayList<DomainRuntime>();
        if (parent.getChildren() != null) {
            Set siblingIds = Id.newIdSet((List)parent.getChildren());
            for (Domain domain : parent.getChildren()) {
                DomainRuntime domainRuntime = new DomainRuntime(domain, parentRuntime, siblingIds);
                List<DomainRuntime> childrenOptionRuntime = this.load(map, domain, domainRuntime);
                for (DomainRuntime childDomainRuntime : childrenOptionRuntime) {
                    domainRuntime.descendantIds0.add(childDomainRuntime.domain.getId());
                    domainRuntime.descendantIds0.addAll(childDomainRuntime.descendantIds0);
                }
                map.put(domain.getId(), domainRuntime);
                result.add(domainRuntime);
            }
        }
        return result;
    }

    public Set<Integer> getAllDescendantDomainIds(Set<Integer> domainIds) {
        if (domainIds == null || domainIds.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        if (domainIds.contains(0)) {
            for (DomainRuntime domainRuntime : this.getMap().values()) {
                if (domainRuntime == null) continue;
                result.add(domainRuntime.getDomain().getId());
                result.addAll(domainRuntime.getDescendantIds());
            }
        } else {
            for (Integer domain : domainIds) {
                if (domain == 0) continue;
                result.add(domain);
                DomainRuntime domainRuntime = this.get(domain);
                if (domainRuntime == null) continue;
                result.addAll(domainRuntime.getDescendantIds());
            }
        }
        return result;
    }
}

