/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;

public class IpResourceDao
extends AbstractIdDao<IpResource> {
    public IpResourceDao(Connection con, int moduleId) {
        super(con, 0, "inv_ip_resource_" + moduleId);
    }

    protected IpResource getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getIpResourceFromRS("", rs);
    }

    public IpResource getIpResourceFromRS(String prefix, ResultSet rs) throws SQLException, BGException {
        byte flags = rs.getByte(prefix + "flags");
        return IpResource.builder().setId(rs.getInt(prefix + "id")).setCategoryId(rs.getInt(prefix + "categoryId")).setAddressFrom(rs.getBytes(prefix + "addressFrom")).setAddressTo(rs.getBytes(prefix + "addressTo")).setPrefixLength(rs.getShort(prefix + "prefixLength")).setDateFrom((Date)rs.getDate(prefix + "dateFrom")).setDateTo((Date)rs.getDate(prefix + "dateTo")).setSubnetMask(rs.getString(prefix + "subnetMask")).setRouter(rs.getString(prefix + "router")).setDns(rs.getString(prefix + "dns")).setReserveStart((flags & 1) > 0).setReserveEnd((flags & 2) > 0).setConfig(rs.getString(prefix + "config")).setComment(rs.getString(prefix + "comment")).build();
    }

    protected void updateImpl(IpResource ipResource) throws BGException, SQLException {
        boolean update = ipResource.getId() > 0;
        String queryUpdate = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET categoryId=?, addressFrom=?, addressTo=?, dateFrom=?, dateTo=?, router=?, subnetMask=?, dns=?, config=?, comment=?, dynamic=0, prefixLength=?, flags=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(queryUpdate, 1);){
            byte flags = 0;
            flags = (byte)(flags | (ipResource.isReserveStart() ? 1 : 0));
            flags = (byte)(flags | (ipResource.isReserveEnd() ? 2 : 0));
            int index = 1;
            ps.setInt(index++, ipResource.getCategoryId());
            ps.setBlob(index++, new ByteArrayInputStream(ipResource.getAddressFrom()));
            ps.setBlob(index++, new ByteArrayInputStream(ipResource.getAddressTo()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)ipResource.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)ipResource.getDateTo()));
            ps.setString(index++, Utils.maskNull((String)ipResource.getRouter()));
            ps.setString(index++, Utils.maskNull((String)ipResource.getSubnetMask()));
            ps.setString(index++, Utils.maskNull((String)ipResource.getDns()));
            ps.setString(index++, Utils.maskNull((String)ipResource.getConfig()));
            ps.setString(index++, ipResource.getComment());
            ps.setShort(index++, ipResource.getPrefixLength());
            ps.setByte(index++, flags);
            if (update) {
                ps.setInt(index++, ipResource.getId());
            }
            ps.executeUpdate();
            if (!update) {
                ipResource.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public List<IpResource> list(Collection<Integer> categoryIds, Collection<Integer> resourceIds, Date dateFrom, Date dateTo, Boolean dynamic) throws BGException {
        ArrayList<IpResource> result = new ArrayList<IpResource>();
        StringBuilder sb = new StringBuilder(50).append("1=1");
        if (categoryIds != null && categoryIds.size() > 0) {
            sb.append(" AND categoryId IN (").append(Utils.toString(categoryIds)).append(")");
        }
        if (resourceIds != null && resourceIds.size() > 0) {
            sb.append(" AND id IN (").append(Utils.toString(resourceIds)).append(")");
        }
        sb.append(" AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?) ");
        String query = " SELECT * FROM " + this.tableName + " WHERE " + sb.toString();
        if (dynamic != null) {
            query = query + " AND dynamic = ?";
        }
        query = query + " ORDER BY id";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)dateFrom));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)dateTo));
            if (dynamic != null) {
                ps.setBoolean(3, dynamic);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<IpResource> list(Set<Integer> categoryIds, Date dateFrom, Date dateTo) throws BGException {
        ArrayList<IpResource> result = new ArrayList<IpResource>();
        try {
            StringBuilder sb = new StringBuilder(100);
            sb.append(" SELECT * FROM " + this.tableName);
            sb.append(" WHERE 1 =1 ");
            if (categoryIds.size() > 0) {
                sb.append("AND categoryId IN (" + Utils.toString(categoryIds) + ")");
            }
            sb.append(" AND (dateFrom IS NULL OR ? OR dateFrom<=?) AND (dateTo IS NULL OR ? OR dateTo>=?)");
            java.sql.Date dateFromSql = TimeUtils.convertDateToSqlDate((Date)dateFrom);
            java.sql.Date dateToSql = TimeUtils.convertDateToSqlDate((Date)dateTo);
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setBoolean(1, dateFromSql == null);
            ps.setDate(2, dateFromSql);
            ps.setBoolean(3, dateToSql == null);
            ps.setDate(4, dateToSql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<IpResource> list(int categoryId, Date dateFrom, Date dateTo) throws BGException {
        ArrayList<IpResource> result = new ArrayList<IpResource>();
        try {
            java.sql.Date dateFromSql = TimeUtils.convertDateToSqlDate((Date)dateFrom);
            java.sql.Date dateToSql = TimeUtils.convertDateToSqlDate((Date)dateTo);
            String query = "SELECT * FROM " + this.tableName + " WHERE 1=1 ";
            query = query + "AND (dateFrom IS NULL OR ? OR dateFrom<=?) AND (dateTo IS NULL OR ? OR dateTo>=?)";
            if (categoryId > 0) {
                query = query + " AND categoryId=?";
            }
            query = query + "ORDER BY id";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setBoolean(1, dateFromSql == null);
            ps.setDate(2, dateFromSql);
            ps.setBoolean(3, dateToSql == null);
            ps.setDate(4, dateToSql);
            if (categoryId > 0) {
                ps.setInt(5, categoryId);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<IpResource> list(int categoryId) throws BGException {
        return this.list("categoryId=?", "id", new Object[]{categoryId});
    }

    public List<IpResource> list() throws BGException {
        return this.list("", "id", new Object[0]);
    }
}

