/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelPeriodNavigation;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSummaTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;

public class AbstractTransactionMonitorPanel
extends BGUPanel {
    protected JLabel recordCountLabel = new JLabel();
    protected AbstractTransactionTableModel<?> transactionModel = null;
    protected BGSummaTextField summaField = new BGSummaTextField(10);
    protected BGControlPanelPages pagePanel = new BGControlPanelPages();
    protected BGControlPanelPeriodNavigation periodPanel = new BGControlPanelPeriodNavigation();
    protected BGComboBox<AbstractTransactionStatus> statusComboBox = new BGComboBox();

    public AbstractTransactionMonitorPanel() {
        this.statusComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    AbstractTransactionMonitorPanel.this.performAction("refresh");
                }
            }
        });
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTransactionMonitorPanel.this.performAction("refresh");
            }
        });
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).add(5, -60);
        this.periodPanel.setDateFrom(now.getTime());
        this.periodPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().startsWith("date") || "period".equals(event.getPropertyName())) {
                    AbstractTransactionMonitorPanel.this.pagePanel.setPageIndex(1);
                    AbstractTransactionMonitorPanel.this.performAction("refresh");
                }
            }
        });
    }

    @Override
    protected void jbInit() throws Exception {
        if (this.statusComboBox.getItemCount() > 0) {
            this.statusComboBox.setSelectedIndex(0);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.getTable()), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.getBottomPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected JPanel getFilterPanel() {
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041f\u043b\u0430\u0442\u0435\u0436\u0438 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        filterPanel.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
        filterPanel.add(this.statusComboBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.recordCountLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.pagePanel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        return filterPanel;
    }

    protected BGUTable getTable() {
        BGUTable transactionTable = new BGUTable(this.transactionModel);
        transactionTable.setSelectionMode(0);
        return transactionTable;
    }

    protected JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 \u0438\u0442\u043e\u0433\u043e: "), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)this.summaField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        return bottomPanel;
    }
}

