/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.ToolBarControlInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.bgbilling.client.common.BGClientSearchPanel;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGMemoryPanel;
import ru.bitel.common.client.BGUAction;

public class BGClientToolBar
extends BGToolBar {
    private DBInfoManager dbInfoManager = DBInfoManager.getManager();
    private JLabel watch = null;
    private Timer timer = null;
    private final String WATCH_FORMAT = "dd MMMMM HH:mm";

    public BGClientToolBar() {
        super(true, true, true);
        this.setMargin(new Insets(2, 2, 2, 2));
    }

    public void setToolData(Node toolBar) {
        this.removeAll();
        if (toolBar != null && toolBar.hasChildNodes()) {
            NodeList list = toolBar.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node toolItem = list.item(i);
                String nodeName = toolItem.getNodeName();
                if ("button".equals(nodeName)) {
                    String icon = XMLUtils.getAttribute((Element)toolItem, "icon", null);
                    String tipText = XMLUtils.getAttribute((Element)toolItem, "toolTipText", "");
                    this.add(new ToolButtonAction(null, tipText, icon, toolItem));
                }
                if (!"separator".equals(nodeName)) continue;
                this.addSeparator();
            }
        }
        this.addSeparator();
        this.add(new ContractAction("newItem", "\u041d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442", "/img/item_add.png"));
        this.add(new ContractAction("editItem", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "/img/item_edit.png"));
        this.add(new ContractAction("deleteItem", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442", "/img/item_delete.png"));
        this.addSeparator();
        this.add(new ContractAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", "/img/refresh.png"));
        this.addSeparator();
        for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions(BGClientToolBar.class.getCanonicalName(), false)) {
            try {
                BGPluginClient plugin = (BGPluginClient)extension.getPlugin();
                for (Element menuElement : XMLUtils.elements(extension.getElement().getChildNodes())) {
                    String className;
                    if ("separator".equals(menuElement.getNodeName())) {
                        this.addSeparator();
                        continue;
                    }
                    if ("button".equals(menuElement.getNodeName())) {
                        String icon = XMLUtils.getAttribute(menuElement, "icon", null);
                        String tipText = plugin.getResourceString(XMLUtils.getAttribute(menuElement, "toolTipText", ""));
                        this.add(new ToolButtonAction(null, tipText, icon, menuElement));
                        continue;
                    }
                    if (!"control".equals(menuElement.getNodeName()) || (className = XMLUtils.getAttribute(menuElement, "className", null)) == null) continue;
                    try {
                        JComponent compnt = (JComponent)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                        ((ToolBarControlInterface)((Object)compnt)).setToolData(menuElement);
                        this.add(compnt);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430! \u041a\u043b\u0430\u0441\u0441 '" + className + "' - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.add(new BGClientSearchPanel());
        Object userServer = "";
        DBInfo info = this.dbInfoManager.getActiveDBInfo();
        if (info != null) {
            userServer = info.getUser();
            userServer = (String)userServer + " [" + info.getDbServerTitle() + "]";
        }
        this.add(new JLabel("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c [c\u0435\u0440\u0432\u0435\u0440]: "));
        this.add(new TextField((String)userServer, 15));
        this.addSeparator();
        this.addSeparator();
        this.add(new ToolButtonAction("disconnect", "\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", "/img/exit.png", null));
        this.addSeparator();
        this.addWatch();
        this.getInputMap(2).put(KeyStroke.getKeyStroke(59, 512), "show_mempanel");
        this.getActionMap().put("show_mempanel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGClientToolBar.this.getInputMap(2).remove(KeyStroke.getKeyStroke(59, 512));
                BGClientToolBar.this.getActionMap().remove("show_mempanel");
                BGMemoryPanel mempanel = new BGMemoryPanel();
                mempanel.setMinimumSize(new Dimension(50, 24));
                mempanel.setPreferredSize(new Dimension(200, 24));
                mempanel.setMaximumSize(new Dimension(250, 24));
                mempanel.setVisible(false);
                BGClientToolBar.this.addSeparator();
                BGClientToolBar.this.add(mempanel);
                mempanel.setVisible(true);
                mempanel.start();
            }
        });
    }

    private void addWatch() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.watch = new JLabel();
        this.add(this.watch);
        int DELAY = 5000;
        ActionListener taskPerformer = e -> this.watch.setText(TimeUtils.format(new Date(), "dd MMMMM HH:mm"));
        this.timer = new Timer(DELAY, taskPerformer);
        this.timer.setInitialDelay(0);
        this.timer.start();
        this.watch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm z Z");
                StringBuilder sb = new StringBuilder();
                sb.append("<html>\u041a\u043b\u0438\u0435\u043d\u0442: ");
                String localTimezone = System.getProperty("user.timezone");
                if (Utils.notEmptyString(localTimezone)) {
                    df.setTimeZone(TimeZone.getTimeZone(localTimezone));
                    sb.append(df.format(new Date())).append(" (").append(localTimezone).append(")");
                } else {
                    sb.append("?");
                }
                df.setTimeZone(TimeZone.getDefault());
                sb.append("<br>\u0421\u0435\u0440\u0432\u0435\u0440: ").append(df.format(new Date())).append(" (").append(TimeZone.getDefault().getID()).append(")");
                sb.append("</html>");
                BGClientToolBar.this.watch.setToolTipText(sb.toString());
            }
        });
    }

    class ToolButtonAction
    extends BGUAction {
        public ToolButtonAction(String command, String name, String icon, Node node) {
            super(command, name);
            this.putValue("ToolTipText", name);
            this.putValue("ShortDescription", name);
            if (Utils.notBlankString(icon)) {
                this.putValue("SmallIcon", ClientUtils.getIcon(null, icon, false));
            }
            if (node != null) {
                this.putValue("node", node);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if ("quit".equals(command)) {
                ClientSetup.getInstance().saveUserConfig();
                BGClientBase.close();
            } else if ("disconnect".equals(command)) {
                DBInfo info = BGClientToolBar.this.dbInfoManager.getActiveDBInfo();
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c " + info.getDbServerTitle() + "\n\u043f\u043e\u0434 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c " + info.getDbServerLogin() + " \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0442\u043e. \n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c? ", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                    BGClientBase.getFrame().getTabbedPane().removeAll();
                    BGClientToolBar.this.dbInfoManager.disconnect(info);
                    BGClientBase.getFrame().auth(info);
                }
            } else {
                Element toolButton = (Element)this.getValue("node");
                String className = XMLUtils.getAttribute(toolButton, "className", null);
                try {
                    Class<?> clazz = Class.forName(className);
                    boolean fl = false;
                    try {
                        String TAB_ID = (String)clazz.getDeclaredField("TAB_ID").get(null);
                        BGClientBase.getFrame().getTabbedPane().addTab(TAB_ID, clazz.asSubclass(AbstractTabPanel.class));
                        fl = true;
                    }
                    catch (Exception ex) {
                        fl = false;
                    }
                    if (!fl) {
                        e.setSource(this);
                        clazz.asSubclass(ActionListener.class).getConstructor(new Class[0]).newInstance(new Object[0]).actionPerformed(e);
                    }
                }
                catch (ClassNotFoundException ex) {
                    ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430! \u041a\u043b\u0430\u0441\u0441 '" + className + "' - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430! " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
    }

    class ContractAction
    extends BGUAction {
        public ContractAction(String command, String name, String icon) {
            super(command, name);
            this.putValue("ToolTipText", name);
            this.putValue("ShortDescription", name);
            if (Utils.notBlankString(icon)) {
                this.putValue("SmallIcon", ClientUtils.getIcon(null, icon, false));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component panel = BGClientBase.getFrame().getTabbedPane().getSelectedTab();
            if (panel != null) {
                if (panel instanceof BGPanel) {
                    ((BGPanel)panel).actionPerformed(e);
                } else if (panel instanceof BGUTabPanel) {
                    String command = e.getActionCommand();
                    if ("newItem".equals(command)) {
                        command = "new";
                    } else if ("editItem".equals(command)) {
                        command = "edit";
                    } else if ("deleteItem".equals(command)) {
                        command = "delete";
                    }
                    ((BGUPanel)panel).performAction(command);
                }
            }
        }
    }

    class TextField
    extends JTextField {
        public TextField(String text, int columns) {
            super(columns);
            Dimension dimension = new Dimension(columns * 10, 26);
            Color bgColor = this.getBackground();
            this.setMaximumSize(dimension);
            this.setHorizontalAlignment(0);
            this.setText(text);
            this.setEditable(false);
            this.setBackground(bgColor);
        }
    }
}

