/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.apps.server.bean;

import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsContext;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public abstract class AppsAbstractAction {
    protected AppsContext context = null;
    protected int contractId = 0;
    protected Connection con = null;
    protected Map<String, Object> dataMap;
    protected Map<String, Object> actionMap;
    protected HttpServletRequest request = null;
    protected Map<String, String> requestParamsMap = null;

    public void setContext(AppsContext appsContext) {
        this.context = appsContext;
        this.con = this.context.getConnection();
        this.dataMap = this.context.getDataMap();
        this.request = this.context.getRequest();
        this.contractId = this.context.getContractId();
        this.actionMap = new HashMap<String, Object>();
        this.requestParamsMap = appsContext.getRequestParamsMap();
    }

    public abstract void execute() throws BGException;

    public String getParameter(String name) {
        return this.requestParamsMap.get(name);
    }

    public int getIntParameter(String name, int defaultValue) {
        return Utils.parseInt(this.requestParamsMap.get(name), defaultValue);
    }

    protected Period getPeriod() {
        return this.getPeriod(null);
    }

    protected Period getPeriod(String pattern) {
        Period result = new Period();
        if (Utils.isBlankString(pattern)) {
            pattern = "dd.MM.yyyy";
        }
        result.setDateFrom(this.getDateParameter("date1", pattern, null));
        result.setDateTo(this.getDateParameter("date2", pattern, null));
        return result;
    }

    public BigDecimal getBigDecimal(String key, BigDecimal def) {
        BigDecimal result = def;
        try {
            String value = this.getParameter(key);
            result = Utils.isEmptyString(value) ? def : new BigDecimal(value.trim().replace(',', '.'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected final Date getDateParameter(String name, String pattern, Date defaultValue) {
        Date outDate = defaultValue;
        String inDate = this.requestParamsMap.get(name);
        if (inDate != null && !"".equals(inDate) && !"00.00.0000".equals(inDate)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(pattern);
                outDate = new Date(format.parse(inDate).getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return outDate;
    }

    protected boolean getBoolean(String name, boolean defaultValue) {
        return Utils.parseBoolean(this.requestParamsMap.get(name), defaultValue);
    }
}

