/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractSubPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.client.ClientStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusControlPanel;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusLogPanel;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ContractSubPanel_Status
extends ContractSubPanel {
    private List<Status> statusList = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private StatusLogPanel statusLogPanel = new StatusLogPanel();
    private StatusTableModel statusTableModel = new StatusTableModel();
    private StatusControlPanel statusControl = new StatusControlPanel();
    private ContractStatusService contractStatusService = null;

    public ContractSubPanel_Status() {
        this.jbInit();
    }

    private void jbInit() {
        this.tabbedPane.add((Component)this.getStatusPanel(), "\u0421\u0442\u0430\u0442\u0443\u0441");
        this.tabbedPane.add((Component)this.statusLogPanel, "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
        this.tabbedPane.addChangeListener(e -> this.setData());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getStatusPanel() {
        this.statusControl.addActionListener(e -> this.changeStatus());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.statusControl, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(new BGUTable(this.statusTableModel)), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void init(ContractEditor editor) {
        super.init(editor);
    }

    @Override
    public void setData() {
        if (this.statusList == null) {
            try {
                this.statusList = this.getContractStatusService().getStatusList(false);
                this.statusLogPanel.setStatusList(this.statusList);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 0) {
            Async.ofWithTry(() -> this.statusControl.setStatusList(this.getContractStatusService().getStatusList(true)));
            Async.ofWithTry(() -> this.statusTableModel.setData(this.getContractStatusService().contractStatusSearch(this.getContractId(), 0, new Page(1, 20)).getList()));
        } else {
            this.statusLogPanel.performAction("refresh");
        }
    }

    private void changeStatus() {
        if (this.statusControl.getDateFrom() == null) {
            ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        int[] cids = new int[]{this.getContractId()};
        ClientStatusUtil.changeStatusOnServer(this, this.getContext(), cids, 0, this.statusControl.getStatusId(), this.statusControl.getDateFrom(), this.statusControl.getDateTo(), this.statusControl.getComment());
        this.setData();
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = this.getContext().getWebService(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    class StatusTableModel
    extends BGTableModel<ContractStatus> {
        public StatusTableModel() {
            super(StatusTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 200, "period", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, 300, "status", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        @Override
        public Object getValueAt(ContractStatus val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("status".equals(identifier)) {
                return ContractSubPanel_Status.this.statusList.stream().filter(a -> a.getId() == val.getStatus()).map(a -> a.getGuiTitle()).findFirst().orElse("#" + val.getStatus());
            }
            if ("period".equals(identifier)) {
                return new Period(val.getDateFrom(), val.getDateTo());
            }
            return super.getValueAt(val, column);
        }
    }
}

