/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.math.MathContext;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeManager;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.sql.ConnectionSet;

public class TariffContext {
    private static final Logger logger = LogManager.getLogger();
    public final MathContext mc;
    public final boolean realtime;
    public RangeManager rangedTrafficManager;
    protected final int moduleId;
    protected final Date fromTime;
    private final ConcurrentMap<Integer, ContractTariffOptionList> contractOptions = new ConcurrentHashMap<Integer, ContractTariffOptionList>();
    private boolean tariffOptionEnable = true;
    private final AtomicInteger cacheCounter = new AtomicInteger();
    private static final List<ContractTariffOptionList.OptionItem> EMPTY_OPTION_LIST = Collections.emptyList();

    public TariffContext(Date fromTime) throws BGException {
        this(MathContext.DECIMAL128, fromTime, false, 0);
    }

    public TariffContext(Date fromTime, int moduleId) throws BGException {
        this(MathContext.DECIMAL128, fromTime, false, moduleId);
    }

    public TariffContext(MathContext mc, Date fromTime) throws BGException {
        this(mc, fromTime, false, 0);
    }

    public TariffContext(MathContext mc, Date fromTime, boolean realtime, int moduleId) throws BGException {
        this.mc = mc;
        this.fromTime = fromTime;
        this.realtime = realtime;
        this.moduleId = moduleId;
        if (moduleId > 0) {
            this.initTrafficRangeManager(moduleId, realtime);
        }
    }

    protected void initTrafficRangeManager(int moduleId, boolean realtime) throws BGException {
    }

    public TreeContext createTreeContext(TariffModuleTree tariffModuleTree) {
        return new TreeContext(tariffModuleTree);
    }

    public void setTariffOptionEnable(boolean tariffOptionEnable) {
        this.tariffOptionEnable = tariffOptionEnable;
    }

    public ContractTariffOptionList getContractTariffOptionList(ConnectionSet connectionSet, int contractId) {
        ContractTariffOptionList result = (ContractTariffOptionList)this.contractOptions.get(contractId);
        if (result == null) {
            if (this.tariffOptionEnable) {
                try {
                    result = ContractTariffOptionDao.getContractRealtimeTariffOptionList(connectionSet.getConnection(), contractId, this.fromTime);
                    this.contractOptions.put(contractId, result);
                    this.cacheCounter.decrementAndGet();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                result = new ContractTariffOptionList(EMPTY_OPTION_LIST);
                this.contractOptions.put(contractId, result);
            }
        } else {
            this.cacheCounter.incrementAndGet();
        }
        return result;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public Date getFromTime() {
        return this.fromTime;
    }
}

