/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class TextHintPopup
implements DocumentListener {
    private final HintPopup popup;
    private final JTextComponent textComponent;
    private final int popupItemsLimit;
    protected List<String> data;

    public TextHintPopup(JTextComponent textComponent, List<String> data) {
        this(textComponent, data, 30);
    }

    public TextHintPopup(JTextComponent textComponent, List<String> data, int popupItemsLimit) {
        this.textComponent = textComponent;
        this.popupItemsLimit = popupItemsLimit;
        this.popup = new HintPopup();
        this.textComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (TextHintPopup.this.popup.isVisible() && (e.getKeyCode() == 40 || e.getKeyCode() == 38)) {
                    TextHintPopup.this.popup.requestFocus();
                    Component component = e.getKeyCode() == 38 ? TextHintPopup.this.popup.getComponent(TextHintPopup.this.popup.getComponentCount() - 1) : TextHintPopup.this.popup.getComponent(0);
                    if (component != null) {
                        MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{TextHintPopup.this.popup, (MenuElement)((Object)component)});
                    }
                }
            }
        });
        this.data = Objects.requireNonNullElseGet(data, ArrayList::new);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.search();
        }
        catch (BadLocationException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.popup.setVisible(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.search();
        }
        catch (BadLocationException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private int getWordWithCaretStartPosition() throws BadLocationException {
        return Utilities.getWordStart(this.textComponent, this.textComponent.getCaretPosition());
    }

    private int getWordWithCaretEndPosition() throws BadLocationException {
        return Utilities.getWordEnd(this.textComponent, this.textComponent.getCaretPosition());
    }

    private void search() throws BadLocationException {
        String searchWord = this.textComponent.getText().substring(this.getWordWithCaretStartPosition(), this.getWordWithCaretEndPosition()).toLowerCase();
        if (searchWord.length() > 2) {
            Set find = this.data.parallelStream().filter(s -> s.toLowerCase().equals(searchWord) || s.toLowerCase().contains(searchWord)).sorted((o1, o2) -> {
                if (o1.startsWith(searchWord)) {
                    return -1;
                }
                return 0;
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            if (Utils.notEmptyCollection(find)) {
                List<String> findResult = new ArrayList<String>(find);
                if (findResult.size() > this.popupItemsLimit) {
                    findResult = findResult.subList(0, this.popupItemsLimit);
                }
                this.popup.addItems(findResult);
                this.showPopup();
            } else {
                this.popup.setVisible(false);
            }
        } else {
            this.popup.setVisible(false);
        }
    }

    protected void showPopup(HintPopup popupMenu) throws BadLocationException {
        Rectangle rectangle = this.textComponent.modelToView(this.textComponent.getCaretPosition());
        popupMenu.show(this.textComponent, rectangle.x, rectangle.y + rectangle.height);
        popupMenu.revalidate();
        popupMenu.repaint();
        this.textComponent.requestFocus();
    }

    protected void showPopup() throws BadLocationException {
        this.showPopup(this.popup);
    }

    public void hidePopup() {
        this.popup.setVisible(false);
    }

    public final class HintPopup
    extends JPopupMenu {
        private ActionListener customItemListener;
        ActionListener defaultItemListener = e -> {
            Object source = e.getSource();
            if (source instanceof JMenuItem) {
                try {
                    String selectedWord = ((JMenuItem)source).getText();
                    if (Utils.notBlankString(selectedWord)) {
                        String allText = TextHintPopup.this.textComponent.getText();
                        int start = TextHintPopup.this.getWordWithCaretStartPosition();
                        int end = TextHintPopup.this.getWordWithCaretEndPosition();
                        String firstPart = allText.substring(0, start) + selectedWord;
                        String secondPart = allText.substring(end);
                        TextHintPopup.this.textComponent.setText(firstPart + secondPart);
                        TextHintPopup.this.popup.setVisible(false);
                    }
                }
                catch (BadLocationException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        };

        public HintPopup() {
            this.setBackground(Color.PINK);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    MenuElement[] elements;
                    int selectedIndex = HintPopup.this.getSelectionModel().getSelectedIndex();
                    int itemsCount = HintPopup.this.getComponentCount();
                    if (e.getKeyCode() == 38) {
                        if (selectedIndex == -1 || selectedIndex == 0) {
                            HintPopup.this.getSelectionModel().setSelectedIndex(itemsCount - 1);
                        } else {
                            HintPopup.this.getSelectionModel().setSelectedIndex(--selectedIndex);
                        }
                    } else if (e.getKeyCode() == 40) {
                        if (selectedIndex == itemsCount - 1 || selectedIndex == -1) {
                            HintPopup.this.getSelectionModel().setSelectedIndex(0);
                        } else {
                            HintPopup.this.getSelectionModel().setSelectedIndex(++selectedIndex);
                        }
                    } else if (e.getKeyCode() == 10 && (elements = MenuSelectionManager.defaultManager().getSelectedPath()) != null && elements.length > 1) {
                        ActionEvent actionEvent = new ActionEvent(elements[1].getComponent(), 0, "");
                        if (HintPopup.this.customItemListener != null) {
                            HintPopup.this.customItemListener.actionPerformed(actionEvent);
                        } else {
                            HintPopup.this.defaultItemListener.actionPerformed(actionEvent);
                        }
                    }
                }
            });
        }

        public void addItems(List<String> words) {
            this.removeAll();
            if (Utils.isEmptyCollection(words)) {
                return;
            }
            words.forEach(w -> {
                JMenuItem item = new JMenuItem((String)w);
                item.addActionListener(this.customItemListener == null ? this.defaultItemListener : this.customItemListener);
                item.setBackground(Color.PINK);
                this.add(item);
            });
        }

        public void setCustomItemListener(ActionListener listener) {
            this.customItemListener = listener;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
        }
    }
}

