/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client.device.port;

import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.client.InetIpCategoryTreePanel;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.client.device.port.DevicePortSubscriptionPanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterfaceIndex;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class DeviceInterfacePanel<D extends Device<D, ?>>
extends BGUPanel {
    private DeviceInterfaceTableModel model = new DeviceInterfaceTableModel();
    private final DevicePanel<D, ?> devicePanel;
    private final BGTreeTableModel<D> parentModel;
    private Map<Integer, IpCategory> inetIpCategoryMap = null;
    private BGEditor mainEditor;
    private InterfaceForm interfaceForm;
    private ResourceService resourceService = null;
    DeviceInterfaceService deviceInterfaceService = ((ClientContext)this.getContext()).getPort(DeviceInterfaceService.class);
    InetDeviceService inetDeviceService = ((ClientContext)this.getContext()).getPort(InetDeviceService.class);
    private D currentDevice;
    AbstractBGUPanel.MenuAction interfaces = new AbstractBGUPanel.MenuAction("device.port", "\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b", (Icon)ClientUtils.getIcon("fugue/network-ethernet")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            DeviceInterfacePanel.this.currentDevice = (Device)DeviceInterfacePanel.this.parentModel.getSelectedRow();
            if (DeviceInterfacePanel.this.currentDevice == null || DeviceInterfacePanel.this.currentDevice == DeviceInterfacePanel.this.parentModel.getRoot()) {
                return;
            }
            BGSwingUtilites.wrapBorder(DeviceInterfacePanel.this, " \u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 " + DeviceInterfacePanel.this.currentDevice.getGuiTitle() + " ");
            DeviceInterfacePanel.this.mainEditor.show("table");
            DeviceInterfacePanel.this.interfaceForm.performAction("refresh");
            DeviceInterfacePanel.this.performActionOpen();
        }
    };
    AbstractBGUPanel.DefaultAction close = new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c \"\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b\""){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            this.getParentAction().actionPerformed(e);
        }
    };
    private BGTableModel<DeviceInterfaceIndex> interfaceIndexModel = new BGTableModel<DeviceInterfaceIndex>("Index"){

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0418\u043d\u0434\u0435\u043a\u0441", -1, 140, -1, "index", true);
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 200, -1, null, true);
        }

        @Override
        public Object getValue(DeviceInterfaceIndex val, int column) throws BGException {
            switch (column) {
                case 2: {
                    return TimeUtils.formatPeriodWithTime(val.getTimeFrom(), val.getTimeTo());
                }
            }
            return super.getValue(val, column);
        }
    };

    public DeviceInterfacePanel(DevicePanel<D, ?> devicePanel, BGTreeTableModel<D> parentModel, ClientContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.devicePanel = devicePanel;
        this.parentModel = parentModel;
    }

    @Override
    protected void shownNotify() {
    }

    @Override
    protected void jbInit() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName("table");
        BGUTable table = new BGUTable(this.model);
        BGEditor editor = new BGEditor();
        editor.setVisible(false);
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)editor, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.interfaceForm = new InterfaceForm((ClientContext)this.getContext());
        editor.addForm(this.interfaceForm);
        editor.setMinimumSize(new Dimension(0, 300));
        BGSwingUtilites.handleEdit(table, editor);
        this.mainEditor = new BGEditor("table");
        this.mainEditor.addForm(panel);
        this.mainEditor.addForm(new DevicePortSubscriptionPanel());
        this.add((Component)this.mainEditor, "Center");
        BGSwingUtilites.buildPopupMenu(table, this.mainEditor);
        editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.close, "enabled", "oldValue"));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.interfaceForm.performAction("refresh"));
    }

    private void checkIsUniqueInterface(int typeId) throws BGException {
        if (!this.inetDeviceService.isUniqueInterface(this.currentDevice.getDeviceTypeId())) {
            throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \"" + this.currentDevice + "\" \u043d\u0435\u043b\u044c\u0437\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c/\u0443\u0434\u0430\u043b\u044f\u0442\u044c, \u0442.\u043a. \u0438\u043d\u0434\u0438\u0432\u0438\u0434\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b \u0432 \u0442\u0438\u043f\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        }
    }

    private Map<Integer, IpCategory> getInetIpCategoryMap() throws BGException {
        if (this.inetIpCategoryMap == null) {
            this.inetIpCategoryMap = Id.newMap(this.getResourceService().ipCategoryList());
        }
        return this.inetIpCategoryMap;
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = ((ClientContext)this.getContext()).getPort(ResourceService.class);
        }
        return this.resourceService;
    }

    class DeviceInterfaceTableModel
    extends BGTableModel<DeviceInterface> {
        public DeviceInterfaceTableModel() {
            super("port");
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", -1, 120, 200, "port", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 180, 240, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u043d\u0434\u0435\u043a\u0441", -1, 120, 120, "port", true);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 120, 120, "status", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f IP", -1, 180, 240, "categoryIP", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a", -1, 200, -1, "subscriberTitle", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 240, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(DeviceInterface val, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "port": {
                    List indexList = val.getIndexList();
                    if (indexList == null || indexList.size() == 0) {
                        return val.getPort();
                    }
                    Date now = new Date();
                    for (DeviceInterfaceIndex index : indexList) {
                        if (!RangeUtils.inRange(now, now, index.getTimeFrom(), index.getTimeTo())) continue;
                        return index.getIndex();
                    }
                    return val.getPort();
                }
                case "status": {
                    switch (val.getStatus()) {
                        case 0: {
                            return "\u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d";
                        }
                        case 1: {
                            return "\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
                        }
                    }
                    return null;
                }
                case "categoryIP": {
                    IpCategory ipCategory = DeviceInterfacePanel.this.getInetIpCategoryMap().get(val.getIpCategoryId());
                    return ipCategory != null ? ipCategory.getGuiTitle() : "";
                }
            }
            return super.getValue(val, column);
        }
    }

    class InterfaceForm
    extends BGUPanel {
        private IntTextField inerface;
        private BGTextField title;
        private BGUComboBox<IdTitle> status;
        private boolean isEdit;
        private BGTextArea comment;
        DeviceInterface current;
        private InetIpCategoryTreePanel categoryPanel;

        public InterfaceForm(ClientContext context) {
            super((LayoutManager)new GridBagLayout(), context);
        }

        @Override
        protected void jbInit() {
            BGSwingUtilites.wrapBorder(this, " \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ");
            this.inerface = new IntTextField();
            this.inerface.setMinValue(-1L);
            this.title = new BGTextField();
            this.status = new BGUComboBox();
            this.isEdit = false;
            ArrayList<IdTitle> data = new ArrayList<IdTitle>();
            data.add(new IdTitle(1, "\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d"));
            data.add(new IdTitle(0, "\u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d"));
            this.status.setData(data);
            this.title.setMinimumSize(new Dimension(350, this.title.getPreferredSize().height));
            this.title.setPreferredSize(new Dimension(350, this.title.getPreferredSize().height));
            this.comment = new BGTextArea(0, 30);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.inerface, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 0, 0, 5), 0, 0));
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add((Component)this.title, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 0, 0, 5), 0, 0));
            this.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add(this.status, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 0, 0, 5), 0, 0));
            this.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 17, 1, new Insets(3, 0, 0, 5), 0, 0));
            JTabbedPane tabbedPane = new JTabbedPane();
            JPanel panel = new JPanel(new BorderLayout());
            BGUTable indexTable = new BGUTable(DeviceInterfacePanel.this.interfaceIndexModel);
            panel.add((Component)BGSwingUtilites.wrapEmptyBorder(new JScrollPane(indexTable)), "Center");
            BGEditor editor = new BGEditor();
            editor.setVisible(false);
            editor.addForm(new InterfaceIndexForm());
            panel.add((Component)editor, "South");
            BGDialogToolBar toolBar = new BGDialogToolBar();
            BGSwingUtilites.buildToolBar(toolBar, editor);
            toolBar.compact();
            panel.add((Component)toolBar, "North");
            BGSwingUtilites.handleEdit(indexTable, editor);
            this.categoryPanel = new InetIpCategoryTreePanel(null, false, (ClientContext)this.getContext());
            tabbedPane.addTab("\u0418\u043d\u0434\u0435\u043a\u0441", panel);
            tabbedPane.addTab("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f IP-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432", this.categoryPanel);
            this.add((Component)tabbedPane, new GridBagConstraints(1, 0, 1, 8, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.getActionMap().get("ok"), "enabled", "oldValue"));
            editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.getActionMap().get("close"), "enabled", "oldValue"));
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh(e -> {
                DeviceInterfacePanel.this.inetIpCategoryMap = null;
                if (DeviceInterfacePanel.this.currentDevice != null) {
                    DeviceInterfacePanel.this.model.setData(DeviceInterfacePanel.this.deviceInterfaceService.devicePortList(DeviceInterfacePanel.this.devicePanel.getInvDeviceId(DeviceInterfacePanel.this.currentDevice), true));
                }
                this.categoryPanel.performAction("refresh");
            });
            new AbstractBGUPanel.BGActionNew(e -> {
                DeviceInterfacePanel.this.checkIsUniqueInterface(DeviceInterfacePanel.this.currentDevice.getDeviceTypeId());
                this.current = new DeviceInterface();
                this.current.setDeviceId(DeviceInterfacePanel.this.devicePanel.getInvDeviceId(DeviceInterfacePanel.this.currentDevice));
                this.inerface.setText("");
                this.inerface.setEnabled(true);
                this.title.setText("");
                this.title.setEnabled(true);
                this.comment.setText("");
                this.categoryPanel.performAction("refresh");
                DeviceInterfacePanel.this.interfaceIndexModel.setData(new ArrayList());
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit(e -> {
                this.current = (DeviceInterface)DeviceInterfacePanel.this.model.getSelectedRow();
                if (this.current != null) {
                    this.inerface.setValue(this.current.getPort());
                    this.inerface.setEnabled(false);
                    this.status.setSelectedItem(this.current.getStatus());
                    this.title.setText(this.current.getTitle());
                    this.isEdit = true;
                    this.title.setEnabled(DeviceInterfacePanel.this.inetDeviceService.isUniqueInterface(DeviceInterfacePanel.this.currentDevice.getDeviceTypeId()));
                    this.comment.setText(this.current.getComment());
                    this.categoryPanel.performAction("refresh");
                    this.categoryPanel.setSelectedCategoryId(this.current.getIpCategoryId());
                    DeviceInterfacePanel.this.interfaceIndexModel.setData(new ArrayList(this.current.getIndexList()));
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (!InterfaceForm.this.isEdit) {
                        DeviceInterfacePanel.this.checkIsUniqueInterface(DeviceInterfacePanel.this.currentDevice.getDeviceTypeId());
                    }
                    InterfaceForm.this.isEdit = false;
                    try {
                        int port = (int)InterfaceForm.this.inerface.getValue();
                        if (InterfaceForm.this.inerface.isEnabled()) {
                            for (DeviceInterface iface : DeviceInterfacePanel.this.deviceInterfaceService.devicePortList(DeviceInterfacePanel.this.devicePanel.getInvDeviceId(DeviceInterfacePanel.this.currentDevice), false)) {
                                if (iface.getPort() != port) continue;
                                ClientUtils.showErrorMessageDialog("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
                                return;
                            }
                        }
                        InterfaceForm.this.current.setPort(port);
                        InterfaceForm.this.current.setTitle(InterfaceForm.this.title.getText());
                        InterfaceForm.this.current.setStatus(((IdTitle)InterfaceForm.this.status.getSelectedItem()).getId());
                        InterfaceForm.this.current.setComment(InterfaceForm.this.comment.getText());
                        InterfaceForm.this.current.setIpCategoryId(InterfaceForm.this.categoryPanel.getSelectedCategory() != null ? InterfaceForm.this.categoryPanel.getSelectedCategory().getId() : 0);
                        InterfaceForm.this.current.setIndexList(DeviceInterfacePanel.this.interfaceIndexModel.getRows());
                        DeviceInterfacePanel.this.deviceInterfaceService.devicePortUpdate(InterfaceForm.this.current, false);
                        InterfaceForm.this.performActionClose();
                        DeviceInterfacePanel.this.model.setSelectedRow(InterfaceForm.this.current);
                    }
                    finally {
                        DeviceInterfacePanel.this.performAction("refresh");
                    }
                }
            };
            new AbstractBGUPanel.BGActionDelete(e -> {
                DeviceInterfacePanel.this.checkIsUniqueInterface(DeviceInterfacePanel.this.currentDevice.getDeviceTypeId());
                this.current = (DeviceInterface)DeviceInterfacePanel.this.model.getSelectedRow();
                if (this.current != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    DeviceInterfacePanel.this.deviceInterfaceService.devicePortDelete(this.current.getDeviceId(), this.current.getPort());
                    this.performActionClose();
                    DeviceInterfacePanel.this.performAction("refresh");
                }
            });
        }
    }

    class InterfaceIndexForm
    extends BGUPanel {
        private IntTextField index;
        private BGCalendarButton dateFrom;
        private BGTextField timeFrom;
        private BGCalendarButton dateTo;
        private BGTextField timeTo;
        DeviceInterfaceIndex current;

        public InterfaceIndexForm() {
            super(new GridBagLayout());
            this.dateFrom = new BGCalendarButton();
            this.timeFrom = new BGTextField(8);
            this.dateTo = new BGCalendarButton();
            this.timeTo = new BGTextField(8);
        }

        @Override
        protected void jbInit() throws Exception {
            this.index = new IntTextField();
            JPanel panel = new JPanel(new GridBagLayout());
            this.timeFrom.setHorizontalAlignment(0);
            this.timeTo.setHorizontalAlignment(0);
            panel.add((Component)new JLabel("\u0441"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 5), 0, 0));
            panel.add((Component)this.dateFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            panel.add((Component)this.timeFrom, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)this.dateTo, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            panel.add((Component)this.timeTo, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.add((Component)BGSwingUtilites.wrapBorder(this.index, "\u0418\u043d\u0434\u0435\u043a\u0441"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)BGSwingUtilites.wrapBorder(panel, "\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionNew(e -> {
                this.current = null;
                this.dateFrom.setLocalDate(null);
                this.timeFrom.setText("");
                this.dateTo.setLocalDate(null);
                this.timeFrom.setText("");
                this.index.setText("");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit(e -> {
                this.current = DeviceInterfacePanel.this.interfaceIndexModel.getSelectedRow();
                if (this.current != null) {
                    this.dateFrom.setLocalDate(TimeUtils.convertDateToLocalDate(this.current.getTimeFrom()));
                    this.dateFrom.setEnabled(true);
                    this.timeFrom.setText(TimeUtils.format(this.current.getTimeFrom(), "HH:mm:ss"));
                    this.timeFrom.setEnabled(true);
                    this.dateTo.setLocalDate(TimeUtils.convertDateToLocalDate(this.current.getTimeTo()));
                    this.dateTo.setEnabled(true);
                    this.timeTo.setText(TimeUtils.format(this.current.getTimeTo(), "HH:mm:ss"));
                    this.timeTo.setEnabled(true);
                    this.index.setValue(this.current.getIndex());
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u041e\u043a"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    Calendar timeToCalendar;
                    Calendar timeFromCalendar;
                    boolean create;
                    boolean bl = create = InterfaceIndexForm.this.current == null;
                    if (create) {
                        InterfaceIndexForm.this.current = new DeviceInterfaceIndex();
                        InterfaceIndexForm.this.current.setDeviceId(DeviceInterfacePanel.this.interfaceForm.current.getDeviceId());
                        InterfaceIndexForm.this.current.setPort(DeviceInterfacePanel.this.interfaceForm.current.getPort());
                    }
                    if ((timeFromCalendar = InterfaceIndexForm.this.dateFrom.getCalendar()) != null) {
                        TimeUtils.clear_HOUR_MIN_MIL_SEC(timeFromCalendar);
                        Calendar timeFromCalendar2 = TimeUtils.parseCalendar(InterfaceIndexForm.this.timeFrom.getText(), "HH:mm:ss");
                        if (timeFromCalendar2 != null) {
                            timeFromCalendar.set(11, timeFromCalendar2.get(11));
                            timeFromCalendar.set(12, timeFromCalendar2.get(12));
                            timeFromCalendar.set(13, timeFromCalendar2.get(13));
                        }
                    }
                    if ((timeToCalendar = InterfaceIndexForm.this.dateTo.getCalendar()) != null) {
                        TimeUtils.clear_HOUR_MIN_MIL_SEC(timeToCalendar);
                        Calendar timeToCalendar2 = TimeUtils.parseCalendar(InterfaceIndexForm.this.timeTo.getText(), "HH:mm:ss");
                        if (timeToCalendar2 != null) {
                            timeToCalendar.set(11, timeToCalendar2.get(11));
                            timeToCalendar.set(12, timeToCalendar2.get(12));
                            timeToCalendar.set(13, timeToCalendar2.get(13));
                        }
                    }
                    InterfaceIndexForm.this.current.setTimeFrom(TimeUtils.convertCalendarToDate(timeFromCalendar));
                    InterfaceIndexForm.this.current.setTimeTo(TimeUtils.convertCalendarToDate(timeToCalendar));
                    InterfaceIndexForm.this.current.setIndex((int)InterfaceIndexForm.this.index.getValue());
                    if (create) {
                        DeviceInterfacePanel.this.interfaceIndexModel.addRow(InterfaceIndexForm.this.current);
                    }
                    DeviceInterfacePanel.this.interfaceIndexModel.fireTableDataChanged();
                    InterfaceIndexForm.this.performActionClose();
                }
            };
            new AbstractBGUPanel.BGActionDelete(e -> DeviceInterfacePanel.this.interfaceIndexModel.deleteSelectedRows());
        }
    }
}

