package ru.bitel.bgbilling.kernel.dyn.script;

import java.math.BigDecimal;
import java.time.LocalDate;

import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.script.server.dev.GlobalScriptBase;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOptionData;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionActivateManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Period;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class AddTariffOption
	extends GlobalScriptBase
{
	@Override
	public void execute( Setup setup1, ConnectionSet connectionSet2 )
		throws Exception
	{
	    ServerContext serverContext = ThreadContext.get();
	    TariffOptionService tariffOptionService = serverContext.getService( TariffOptionService.class, 0 );
	    ContractTariffOptionActivateManager contractTariffOptionActivateManager = new ContractTariffOptionActivateManager( serverContext.getConnection() );

	    int contractId = 1;
	    int optionId = 1;
	    int activateModeId = 1;
	    Period period = new Period( LocalDate.of( 2022, 12, 15 ), LocalDate.of( 2022, 12, 31 ) );

	    ContractTariffOptionData activate = new ContractTariffOptionData();
	    activate.setContractId( contractId );
	    activate.setOptionId( optionId );
	    activate.setModeId( activateModeId );
	    activate.setChargeSum( BigDecimal.ZERO );
	    activate.setPeriod( period );
	    activate.setWeb( false );
	    contractTariffOptionActivateManager.activateOptionWhithSumAndPeriod( tariffOptionService, User.USER_SERVER, activate );
	}
}