/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionKit;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;

public class MegafonOptionKitPanel
extends BGUPanel {
    private MegafonService megafonService;
    private BGUTable table;
    private KitTableModel tableModel;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.tableModel = new KitTableModel();
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new OptionKitEditorDialog(null).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            MegafonOptionKit selected = (MegafonOptionKit)this.tableModel.getSelectedRow();
            if (selected != null) {
                new OptionKitEditorDialog(selected).open();
            } else {
                BGToolTip.showErrorMessage((JComponent)this.table, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u0431\u043e\u0440 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            MegafonOptionKit selected = (MegafonOptionKit)this.tableModel.getSelectedRow();
            if (selected != null && ClientUtils.confirmDelete((Object)selected.getTitle())) {
                try {
                    this.getMegafonService().deleteOptionKit(selected.getId());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            } else {
                BGToolTip.showErrorMessage((JComponent)this.table, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u0431\u043e\u0440 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
            }
        });
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            try {
                this.tableModel.setData(this.getMegafonService().getOptionKitList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
    }

    private MegafonService getMegafonService() {
        if (this.megafonService == null) {
            this.megafonService = (MegafonService)((ClientContext)this.getContext()).getPort(MegafonService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonService;
    }

    private final class KitTableModel
    extends BGTableModel<MegafonOptionKit> {
        public KitTableModel() {
            super("megafonOptionKitTable");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", false);
        }
    }

    private final class OptionKitEditorDialog
    extends BGEditorDialog<MegafonOptionKit> {
        private final JTextField title;
        private final BGUList<MegafonOption> selected;
        private final BGUList<MegafonOption> available;
        private final JButton selectButton;
        private final JButton removeButton;

        public OptionKitEditorDialog(MegafonOptionKit data) {
            super("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043d\u0430\u0431\u043e\u0440\u0430 \u0443\u0441\u043b\u0443\u0433", (Object)data);
            this.title = new JTextField();
            this.selected = new BGUList();
            this.available = new BGUList();
            this.selectButton = new JButton("<<");
            this.removeButton = new JButton(">>");
            Dimension dimension = new Dimension(200, 300);
            this.selected.setPreferredSize(dimension);
            this.available.setPreferredSize(dimension);
            this.selectButton.addActionListener(e -> {
                List selectedOptions;
                MegafonOption newOption = (MegafonOption)this.available.getSelectedValue();
                if (newOption != null && (selectedOptions = Utils.maskNull((List)this.selected.getSelectedValuesList())).stream().noneMatch(o -> o.getId() == newOption.getId())) {
                    selectedOptions.add(newOption);
                    this.selected.setData(selectedOptions);
                }
            });
            this.removeButton.addActionListener(e -> {
                MegafonOption selectedOption = (MegafonOption)this.available.getSelectedValue();
                if (selectedOption != null) {
                    List selectedOptions = Utils.maskNull((List)this.selected.getSelectedValuesList());
                    selectedOptions.removeIf(o -> o.getId() == selectedOption.getId());
                    this.selected.setData(selectedOptions);
                }
            });
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0412 \u043d\u0430\u0431\u043e\u0440\u0435"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.panel.add((Component)new JScrollPane((Component)this.selected), new GridBagConstraints(0, 3, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 3, 3, 0), 0, 0));
            this.panel.add((Component)this.selectButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            this.panel.add((Component)this.removeButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435"), new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.panel.add((Component)new JScrollPane((Component)this.available), new GridBagConstraints(3, 3, 1, 2, 1.0, 1.0, 13, 1, new Insets(0, 3, 3, 0), 0, 0));
            try {
                this.available.setData(MegafonOptionKitPanel.this.getMegafonService().getOptionList());
                if (this.data != null) {
                    this.title.setText(((MegafonOptionKit)this.data).getTitle());
                    this.selected.setData(((MegafonOptionKit)this.data).getOptions());
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        public boolean doApply() throws Exception {
            if (this.data == null) {
                this.data = new MegafonOptionKit();
            }
            List selectedOptions = this.selected.getSelectedValuesList();
            if (Utils.isBlankString((String)this.title.getText()) || Utils.isEmptyCollection((Collection)selectedOptions)) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b!");
                return false;
            }
            ((MegafonOptionKit)this.data).setTitle(this.title.getText());
            ((MegafonOptionKit)this.data).setOptions(selectedOptions);
            MegafonOptionKitPanel.this.getMegafonService().updateOptionKit((MegafonOptionKit)this.data);
            return true;
        }
    }
}

