/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobimoney.server.service.shopservice;

import java.io.File;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import ru.bitel.bgbilling.kernel.util.net.ssl.PEMCertificate;
import ru.bitel.bgbilling.server.util.KeyStoreUtils;
import ru.bitel.bgbilling.server.util.ModuleSetup;

public class MobiMoneySSLSocketFactory {
    public static SSLSocketFactory getSocketFactory(ModuleSetup moduleSetup) {
        SSLSocketFactory sslSocketFactory = null;
        try {
            File fileCaCrt = new File(moduleSetup.get("mobimoney.path.ca.crt", "cert/mobimoney/ca.crt"));
            File fileCertCrt = new File(moduleSetup.get("mobimoney.path.cert.crt", "cert/mobimoney/cert.crt"));
            File fileCertKey = new File(moduleSetup.get("mobimoney.path.cert.key", "cert/mobimoney/cert.key"));
            if (fileCaCrt.exists() && fileCertCrt.exists() && fileCertKey.exists()) {
                X509Certificate[] chain = new X509Certificate[]{PEMCertificate.getPemCertificate((File)fileCertCrt), PEMCertificate.getPemCertificate((File)fileCaCrt)};
                String keyPassword = moduleSetup.get("mobimoney.key.password", "");
                SSLContext sslContext = KeyStoreUtils.createSSLContext((File)fileCertKey, (String)keyPassword, (X509Certificate[])chain, (File[])new File[]{fileCaCrt});
                sslSocketFactory = sslContext.getSocketFactory();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sslSocketFactory;
    }
}

