/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.sberbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.sberbank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="SberbankExecutor", urlPatterns={"/sberbank/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String PARAM_MD_ORDER = "mdOrder";
    private static final String PARAM_ORDER_NUMBER = "orderNumber";
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                Transaction transaction = null;
                int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                String orderNumber = null;
                String transactionId = null;
                String contentType = request.getHeader("Content-Type");
                if ("application/json".equalsIgnoreCase(contentType)) {
                    try {
                        JSONObject json = new JSONObject(new String(Utils.readByBlock((InputStream)request.getInputStream()), "utf-8"));
                        transactionId = json.optString(PARAM_MD_ORDER);
                        orderNumber = json.optString(PARAM_ORDER_NUMBER);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                        if (con != null) {
                            con.close();
                        }
                        return;
                    }
                } else {
                    orderNumber = request.getParameter(PARAM_ORDER_NUMBER);
                    transactionId = request.getParameter(PARAM_MD_ORDER);
                }
                try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                    transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderNumber));
                }
                if (transaction == null) {
                    logger.error("Not found transaction for ID = " + orderNumber);
                    return;
                }
                if (!transaction.getTransactionId().equals(transactionId)) {
                    logger.error("Transaction for ID = " + orderNumber + "( " + transaction.getTransactionId() + " != " + transactionId + " )");
                    return;
                }
                EventProcessor eventProcessor = EventProcessor.getInstance();
                eventProcessor.publish((Event)new SberbankCheckEvent(moduleId, transaction.getId()));
                eventProcessor.publish((Event)new SberbankCheckEvent(moduleId, transaction.getContractId(), transaction.isAutopayment()));
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

