/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.packer.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerOptionLibrary;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.SearchResult;

public class PackerOptionLibraryDao
extends AbstractIdDao<PackerOptionLibrary> {
    public PackerOptionLibraryDao(Connection con) {
        super(con, -1, "packer_option_library");
    }

    public void searchPackerOptionLibraryList(SearchResult<PackerOptionLibrary> searchResult, String title) throws BGException {
        try {
            searchResult.setList(this.listImpl(searchResult.getPage(), "SQL_CALC_FOUND_ROWS *", null, "title like ?", "title", new Object[]{"%" + title + "%"}));
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected PackerOptionLibrary getFromRS(ResultSet rs) throws SQLException, BGException {
        return (PackerOptionLibrary)this.ormFromResultSet(rs, PackerOptionLibrary.class);
    }

    protected void updateImpl(PackerOptionLibrary packerOptionLibrary) throws BGException, SQLException {
        Objects.requireNonNull(packerOptionLibrary, "packerOptionLibrary must not be null");
        boolean update = packerOptionLibrary.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET `title`=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, packerOptionLibrary.getTitle());
            if (update) {
                ps.setInt(index++, packerOptionLibrary.getId());
            }
            ps.executeUpdate();
            if (!update) {
                packerOptionLibrary.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

