/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ModuleConfigRate
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private BGPanel editor = new BGPanel();
    private BGComboBox<ComboBoxItem> editorCurrency = new BGComboBox();
    private BGControlPanelPeriodNoB editorPeriod = new BGControlPanelPeriodNoB();
    private BGTextField editorPrice = new BGTextField();
    private JCheckBox editorEnabled = new JCheckBox("\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c");
    private JLabel editorCountUsed = new JLabel();
    private String rowid = null;

    public ModuleConfigRate() {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPrice.setColumns(10);
        this.editor.setLayout((LayoutManager)new GridBagLayout());
        this.editor.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u0443\u0440\u0441\u0430"));
        this.editor.add((Component)new JLabel("\u0412\u0430\u043b\u044e\u0442\u0430:"), (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add(this.editorCurrency, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.editorPeriod, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u0426\u0435\u043d\u0430:"), (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.editorPrice, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.editorEnabled, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        this.editor.add((Component)okCancelPanel, (Object)new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.editorCountUsed, (Object)new GridBagConstraints(0, 1, 7, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BGButtonPanelOkCancel.OK.getActionCommand().equals(e.getActionCommand())) {
                    ModuleConfigRate.this.stopEdit(true);
                } else if (BGButtonPanelOkCancel.CANCEL.getActionCommand().equals(e.getActionCommand())) {
                    ModuleConfigRate.this.stopEdit(false);
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ModuleConfigRate.this.editItem();
                }
            }
        });
        this.table.setHeader(this.rb_name, this.moduleDoc, "buyemoney_rate");
        this.editor.setVisible(false);
    }

    public void setData() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("CurrencyRateTable");
        req.setModuleId(this.getModuleId());
        Document doc = TransferManager.getDocument((Request)req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.selectNode((Node)doc, (String)"/data/table"));
        }
    }

    private void init() {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("CurrenciesList");
        Document doc = TransferManager.getDocument((Request)req);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.editorCurrency, (Node)XMLUtils.selectNode((Node)doc, (String)"/data/currencies"), null);
        }
    }

    public void editItem() {
        this.rowid = ClientUtils.getRowId((BGTable)this.table);
        if (this.rowid != null) {
            Request req = new Request();
            req.setAction("GetCurrencyRate");
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.rowid);
            Document doc = TransferManager.getDocument((Request)req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element currencyEl = (Element)XMLUtils.selectNode((Node)doc, (String)"/data/currency");
                this.editorCurrency.setSelectedId(currencyEl.getAttribute("currency"));
                this.editorPeriod.setDateString1(currencyEl.getAttribute("date1"));
                this.editorPeriod.setDateString2(currencyEl.getAttribute("date2"));
                this.editorPrice.setText(currencyEl.getAttribute("price"));
                this.editorEnabled.setSelected("1".equals(currencyEl.getAttribute("enabled")));
                this.editor.setVisible(true);
                int countUsed = Utils.parseInt((String)currencyEl.getAttribute("countUsed"));
                this.editorCountUsed(countUsed);
            }
        }
    }

    public void newItem() {
        this.rowid = "new";
        this.editorCurrency.setSelectedId(null);
        this.editorPeriod.setDateCalendar1(Calendar.getInstance());
        this.editorPeriod.setDateString2(null);
        this.editorPrice.setText("1.00");
        this.editorEnabled.setSelected(false);
        this.editor.setVisible(true);
        this.editorCountUsed(0);
    }

    public void deleteItem() {
        String rowToDel = ClientUtils.getRowId((BGTable)this.table);
        if (rowToDel != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0443\u0440\u0441?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setAction("DeleteCurrencyRate");
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", rowToDel);
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setData();
            }
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            Request request = new Request();
            request.setAction("UpdateCurrencyRate");
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", this.rowid);
            ComboBoxItem item = (ComboBoxItem)this.editorCurrency.getSelectedItem();
            if (item != null) {
                request.setAttribute("currency", String.valueOf(item.getObject()));
            }
            request.setPeriod(this.editorPeriod.getPeriod());
            request.setAttribute("price", this.editorPrice.getText());
            request.setAttribute("enabled", this.editorEnabled.isSelected());
            Document doc = TransferManager.getDocument((Request)request);
            if (!ClientUtils.checkStatus((Document)doc)) {
                return;
            }
            this.setData();
        }
        this.editor.setVisible(false);
    }

    private void editorCountUsed(int countUsed) {
        this.editorCurrency.setEnabled(countUsed <= 0);
        this.editorPeriod.setEnabled(countUsed <= 0);
        this.editorPrice.setEnabled(countUsed <= 0);
        this.editorCountUsed.setText("\u041a\u0443\u0440\u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 " + countUsed + " \u0437\u0430\u043f\u0438\u0441\u044f\u0445 \u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u0445. \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e.");
        this.editorCountUsed.setVisible(countUsed > 0);
    }
}

