/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bvcom.server.bean;

import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bvcom.common.bean.Transaction;
import ru.bitel.bgbilling.modules.bvcom.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "bvcom_transaction");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.cid WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.create_time>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.create_time<?");
                }
            }
            if (Utils.notBlankString((String)status)) {
                query.append(" AND pt.status=?");
            }
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND c.id=").append(contractId);
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title, c.comment AS contract_comment" + query.toString() + (page != null ? page.sqlLimit() : ""));
                int index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement("SELECT SUM(pt.summa), COUNT(*) " + query.toString());
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal sum;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((sum = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(sum);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public Transaction getTransactionById(int transactionId) throws BGException {
        Transaction result = null;
        String query = "SELECT pt.*, c.title AS contract_title, c.comment AS contract_comment FROM " + this.tableName + " AS pt LEFT JOIN contract c ON c.id=pt.cid WHERE pt.id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, transactionId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<Transaction> getReturnMoneyTransactionList() throws BGException {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        String query = "SELECT pt.*, c.title AS contract_title, c.comment AS contract_comment FROM " + this.tableName + " AS pt LEFT JOIN contract c ON c.id=pt.cid WHERE pt.status=" + TransactionStatus.MONEY_RETURN_PROCESSING.getCode();
        try {
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void addTransaction(Transaction transaction) throws BGException {
        String query = "INSERT INTO " + this.tableName + " SET cid=?, summa=?, create_time=NOW()";
        try {
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, transaction.getContractId());
            ps.setBigDecimal(2, transaction.getSum());
            ps.executeUpdate();
            transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, BigDecimal sum, Map<String, Object> dataMap, String ipAddress) throws BGException {
        Transaction transaction = new Transaction();
        transaction.setContractId(contractId);
        transaction.setSum(sum);
        this.addTransaction(transaction);
        DecimalFormat decimalFormat = new DecimalFormat(this.moduleSetup.get("bvcom.trans.format", "BG00000000"));
        String endpointid = this.moduleSetup.get("bvcom.endpointid", "-1");
        String clientOrderId = decimalFormat.format(transaction.getId());
        String amount = sum.setScale(2).toPlainString();
        String merchantControl = this.moduleSetup.get("bvcom.merchant.control", "");
        String currency = this.moduleSetup.get("bvcom.currency", "RUR");
        String description = this.moduleSetup.get("bvcom.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
        String callbackUrl = this.moduleSetup.get("bvcom.callback.url", "");
        String resultUrl = this.moduleSetup.get("bvcom.url.result", "");
        String email = "email@example.org";
        String country = "RU";
        String city = "Castle_Rock";
        String address1 = "Not_specified";
        String zipCode = "000000";
        String control = this.getControlHash(endpointid, clientOrderId, amount, email, merchantControl);
        StringBuilder spec = new StringBuilder();
        spec.append(this.moduleSetup.get("bvcom.server.url", "https://sandbox.ariuspay.ru/paynet/api/v2/"));
        spec.append("sale-form/" + endpointid);
        StringBuilder outputText = new StringBuilder();
        outputText.append("client_orderid=" + clientOrderId);
        outputText.append("&amount=" + amount);
        outputText.append("&currency=" + currency);
        try {
            outputText.append("&order_desc=" + URLEncoder.encode(description, "UTF-8"));
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
        }
        outputText.append("&redirect_url=" + resultUrl);
        outputText.append("&ipaddress=" + ipAddress);
        outputText.append("&server_callback_url=" + callbackUrl);
        outputText.append("&control=" + control);
        outputText.append("&country=" + country);
        outputText.append("&city=" + city);
        outputText.append("&zip_code=" + zipCode);
        outputText.append("&address1=" + address1);
        outputText.append("&email=" + email);
        if (this.moduleSetup.getBoolean("bvcom.fiscalization.enable", false)) {
            JSONArray positions = new JSONArray();
            JSONObject position = new JSONObject();
            position.put("quantity", this.moduleSetup.getInt("bvcom.fiscalization.receipt.qty", 1));
            position.put("price", sum.setScale(2).doubleValue());
            position.put("tax", this.moduleSetup.getInt("bvcom.fiscalization.receipt.tax.type", 1));
            position.put("description", (Object)this.moduleSetup.get("bvcom.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}"));
            positions.put((Object)position);
            JSONObject chequeJsonObject = new JSONObject();
            chequeJsonObject.put("cheque_type", 1);
            chequeJsonObject.put("tax_system", this.moduleSetup.getInt("bvcom.fiscalization.receipt.tax.system", 1));
            chequeJsonObject.put("positions", (Object)positions);
            outputText.append("&cheque=" + chequeJsonObject.toString());
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u0432 BVCom: " + spec.toString());
            this.getLogger().debug("\toutputText: " + outputText.toString());
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + spec.toString());
        }
        StringBuilder result = null;
        try {
            String[] answerValues;
            HashMap<String, String> requestProperties = new HashMap<String, String>();
            requestProperties.put("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            result = this.doConnection(spec.toString(), "POST", true, outputText.toString(), requestProperties);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(result));
            }
            for (String s : answerValues = result.toString().trim().split("&")) {
                String[] tmp = s.trim().split("=");
                dataMap.put(tmp[0], tmp[1]);
            }
            if (dataMap.containsKey("paynet-order-id")) {
                String paynetOrderId = String.valueOf(dataMap.get("paynet-order-id"));
                transaction.setBvcomOrderId(paynetOrderId);
                this.update(transaction);
                String redirect = String.valueOf(dataMap.get("redirect-url"));
                dataMap.put("redirect", URLDecoder.decode(redirect, "UTF-8"));
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
        return transaction;
    }

    private String getControlHash(String endpointid, String clientOrderId, String amount, String email, String merchantControl) throws BGException {
        String result = null;
        Double tmpAmount = Double.valueOf(amount) * 100.0;
        int newAmount = tmpAmount.intValue();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(endpointid.getBytes());
            messageDigest.update(clientOrderId.getBytes());
            messageDigest.update(String.valueOf(newAmount).getBytes());
            messageDigest.update(email.getBytes());
            messageDigest.update(merchantControl.getBytes());
            result = Utils.bytesToHexString((byte[])messageDigest.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("pt.id"))).setContractId(rs.getInt("pt.cid"))).setContractTitle(rs.getString("contract_title"))).setContractComment(rs.getString("contract_comment"))).setCreateDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("pt.create_time")))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("pt.end_time")))).setSum(Utils.maskNull((BigDecimal)rs.getBigDecimal("pt.summa")))).setStatus(rs.getString("pt.status"))).setBvcomOrderId(rs.getString("pt.bvcom_order_id")).build();
    }

    protected void updateImpl(Transaction transaction) throws BGException, SQLException {
        String query = "UPDATE " + this.tableName + " SET status=?, summa=?, end_time=?, bvcom_order_id=? WHERE id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, Integer.parseInt(transaction.getStatus()));
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getBvcomOrderId());
            ps.setInt(index++, transaction.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }
}

