/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionCardManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeriesManager;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.common.Utils;

public class ActionCardDealerDelete
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int mid = this.getIntParameter("mid", -1);
        int did = this.getIntParameter("did", -1);
        String buf = this.getParameter("buf");
        if (mid <= 0 || did <= 0 || Utils.isBlankString((String)buf)) {
            throw new BGIllegalArgumentException();
        }
        CardManager cardManager = new CardManager(this.con, mid);
        DealerManager dealerManager = new DealerManager(this.con, mid);
        CardSeriesManager seriesManager = new CardSeriesManager(this.con, mid);
        CardActionManager actionManager = new CardActionManager(this.con, mid);
        CardActionCardManager actionCardManager = new CardActionCardManager(this.con, mid);
        Dealer dealer = dealerManager.getDealer(did);
        if (dealer == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u0438\u043b\u0435\u0440 " + did);
        }
        float summ = 0.0f;
        int count = 0;
        HashSet<Integer> seriesSet = new HashSet<Integer>();
        ArrayList<Long> cardToMoveId = new ArrayList<Long>();
        List<Card> cards = cardManager.getCards(buf);
        for (Card card : cards) {
            if (card.getStatus() == 1) {
                summ += card.getSumma();
                ++count;
                seriesSet.add(card.getSeriesId());
                cardToMoveId.add(card.getId());
                if (card.getDealerId() == did) continue;
                throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 " + card.getId() + " \u043d\u0435 \u043f\u0440\u0435\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0434\u0438\u043b\u0435\u0440\u0443!");
            }
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0431\u0440\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 " + card.getId());
        }
        GregorianCalendar now = new GregorianCalendar();
        cardManager.updateCardStatus(buf, 0);
        CardAction action = new CardAction();
        action.setType(2);
        action.setTime(now);
        action.setDealerId(did);
        action.setCardCount(count);
        action.setCardSumma(summ);
        action.setCost(summ - summ * dealer.getCardPercent() / 100.0f);
        actionManager.updateAction(action);
        Iterator iterator = seriesSet.iterator();
        while (iterator.hasNext()) {
            int ser = (Integer)iterator.next();
            seriesManager.updateSeriesFree(ser);
        }
        actionCardManager.updateCards(action.getId(), cardToMoveId);
    }
}

