/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;

public class ActionCheckCardInfo
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int mid = this.getIntParameter("mid", 0);
        int sid = this.getIntParameter("sid", 0);
        long cardCode = this.getLongParameter("cardCode", -1L);
        long cardPinCode = this.getLongParameter("cardPinCode", -1L);
        if (mid < 1 || cardCode < 0L || cardPinCode < 0L) {
            StringBuffer buf = new StringBuffer();
            buf.append("mid = ");
            buf.append(mid);
            buf.append(";  cardCode = ");
            buf.append(cardCode);
            buf.append(";  cardPinCode = ");
            buf.append(cardPinCode);
            throw new BGMessageException(buf.toString());
        }
        Element card = this.createElement(this.rootNode, "card");
        card.setAttribute("code", "error");
        String query = "SELECT * FROM card_data_" + mid + " WHERE card_code=? AND sid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setLong(1, cardCode);
        ps.setInt(2, sid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            card.setAttribute("code", "ok");
            card.setAttribute("pin_code", cardPinCode == rs.getLong("card_pin_code") ? "ok" : "error");
            Date date = new Date();
            java.sql.Date date1 = rs.getDate("date1");
            java.sql.Date date2 = rs.getDate("date2");
            if (date1 != null && date.before(date1)) {
                card.setAttribute("period", "before");
            } else if (date2 != null && date.after(date2)) {
                card.setAttribute("period", "after");
            } else {
                card.setAttribute("period", "ok");
            }
            card.setAttribute("status", rs.getString("status"));
            card.setAttribute("contract_id", rs.getString("cid"));
        }
        rs.close();
        ps.close();
    }
}

