/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.griffin.GriffinConnection;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class GriffinServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private Boolean weHaveTriedToDoThis = null;

    public GriffinServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
    }

    private void synchronizeAll() throws Exception {
        if (this.weHaveTriedToDoThis == null) {
            Calendar now = Calendar.getInstance();
            List<CardPacket> cardPackets = this.cardPacketManager.getActiveCardPacketList(now, (Collection<Integer>)null);
            List<DigitalTVServiceActivator.CardPacketCodePair> cardPacketCodePairs = this.getCardPacketCodePairList(cardPackets, false, false, true, true);
            HashMap mapServerCardPacketlist = new HashMap();
            for (DigitalTVServiceActivator.CardPacketCodePair cpair : cardPacketCodePairs) {
                ArrayList<Integer> packetlist;
                int packetCode = Utils.parseInt((String)cpair.packetCode, (int)-1);
                int packetServerCode = Utils.parseInt((String)cpair.packetServerCode, (int)-1);
                if (packetCode == -1 || packetServerCode == -1) {
                    throw new Exception("\u0414\u043b\u044f \u0432\u0441\u0435\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0437\u0430\u0434\u0430\u043d\u044b \u043a\u043e\u0434 \u043f\u0430\u043a\u0435\u0442\u0430 \u0438 \u043a\u043e\u0434 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                }
                Integer cardnumber = (int)cpair.cardnumber;
                HashMap<Integer, ArrayList<Integer>> mapCardPacketlist = (HashMap<Integer, ArrayList<Integer>>)mapServerCardPacketlist.get(packetServerCode);
                if (mapCardPacketlist == null) {
                    mapCardPacketlist = new HashMap<Integer, ArrayList<Integer>>();
                    mapServerCardPacketlist.put(packetServerCode, mapCardPacketlist);
                }
                if ((packetlist = (ArrayList<Integer>)mapCardPacketlist.get(cardnumber)) == null) {
                    packetlist = new ArrayList<Integer>();
                    mapCardPacketlist.put(cardnumber, packetlist);
                }
                packetlist.add(packetCode);
            }
            GriffinConnection connection = null;
            try {
                ParameterMap moduleSetup = this.getModuleSetup(null);
                int serverId = 0;
                ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
                connection = new GriffinConnection(connectionSetup, serverId);
                connection.connect();
                if (connection.isNewDbFileExist()) {
                    connection.deleteNewDbFile();
                    log.warn("file __new_db__ exists at the time of the new synchronization attempt. remove it.");
                }
                for (Map.Entry e : mapServerCardPacketlist.entrySet()) {
                    connection.postrequest((Integer)e.getKey(), (Map)e.getValue());
                }
                connection.postend();
                this.weHaveTriedToDoThis = true;
            }
            catch (Exception e) {
                this.weHaveTriedToDoThis = false;
                throw new BGException((Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        } else {
            if (this.weHaveTriedToDoThis.booleanValue()) {
                return;
            }
            if (!this.weHaveTriedToDoThis.booleanValue()) {
                throw new Exception("\u0412 \u043f\u0440\u043e\u0448\u043b\u044b\u0439 \u0440\u0430\u0437 \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043d\u0435 \u0443\u0432\u0435\u043d\u0447\u0430\u043b\u0430\u0441\u044c \u0443\u0441\u043f\u0435\u0445\u043e\u043c, \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043f\u0440\u043e\u0431\u043e\u0432\u0430\u043b\u0438");
            }
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        log.info("Modify card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        try {
            this.synchronizeAll();
        }
        catch (Exception ex) {
            log.error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardCode) throws BGException {
        log.info("Closing card: " + cardCode);
        try {
            this.synchronizeAll();
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        log.info("Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        try {
            this.synchronizeAll();
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }
}

