/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;

public class ServiceConfigClean
extends ServiceConfigTabbedPanel {
    private BGComboBox<ComboBoxItem> scriptTypeCb = new BGComboBox();
    private BGTextField mysqlCommandTf = new BGTextField();
    private BGTextField mysqlDumpCommandTf = new BGTextField();
    private BGTextField savePathTf = new BGTextField();
    private JTextArea scriptArea = new JTextArea();
    private BGSelectFilePanel selectFile = new BGSelectFilePanel();

    public ServiceConfigClean() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 mysql: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.mysqlCommandTf, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        topPanel.add((Component)new JLabel("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 mysqldump: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.mysqlDumpCommandTf, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        topPanel.add((Component)new JLabel("\u041f\u0443\u0442\u044c \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.savePathTf, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        topPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0441\u043a\u0440\u0438\u043f\u0442\u0430: "), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        topPanel.add((Component)this.scriptTypeCb, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        JButton goButton = new JButton("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043a\u0440\u0438\u043f\u0442");
        topPanel.add((Component)goButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane(this.scriptArea), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        JButton saveButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        this.add((Component)this.selectFile, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(saveButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.scriptTypeCb.addItem((Object)new ComboBoxItem((Object)"bash", "BASH"));
        this.scriptTypeCb.addItem((Object)new ComboBoxItem((Object)"batch", "BATCH"));
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigClean.this.generate();
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigClean.this.saveScript();
            }
        });
    }

    private void generate() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("GenerateScript");
        req.setModuleId(this.getModuleId());
        req.setAttribute("type", ClientUtils.getIdFromComboBox(this.scriptTypeCb));
        String mysqlCommand = this.mysqlCommandTf.getText();
        String mysqlDumpCommand = this.mysqlDumpCommandTf.getText();
        String savePath = this.savePathTf.getText();
        if (Utils.isBlankString((String)mysqlCommand) || Utils.isBlankString((String)savePath)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b mysql, mysqldump \u0438 \u043f\u0443\u0442\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f!");
            return;
        }
        req.setAttribute("mysql_command", mysqlCommand);
        req.setAttribute("mysqldump_command", mysqlDumpCommand);
        req.setAttribute("backup_path", savePath);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.scriptArea.setText(ClientUtils.linesToString((Element)doc.getDocumentElement()));
        }
    }

    private void saveScript() {
        File file = this.selectFile.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0444\u0430\u0439\u043b");
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.scriptArea.getText().getBytes("ISO8859-1"));
            fos.close();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0444\u0430\u0439\u043b");
            e.printStackTrace();
        }
    }
}

