/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.action;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.IpNet;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasDialup;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasManager;
import ru.bitel.bgbilling.modules.dialup.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpReportUtils;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTaskManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionCreateDetailMonth
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int getFileTemplate = this.getIntParameter("get_file_template", -1);
        if (getFileTemplate == 1) {
            Element fileTemplateEl = this.createElement(this.rootNode, "file_template");
            fileTemplateEl.setAttribute("file_template", this.moduleSetup.get("file.detail.template", ""));
            return;
        }
        String fileName = this.getParameter("file_name");
        Period period = this.getPeriod();
        List lids = Utils.toIntegerList((String)this.getParameter("logins"));
        if (Utils.isEmptyString((String)fileName) || lids.isEmpty()) {
            throw new BGIllegalArgumentException();
        }
        DialUpReportUtils ru = new DialUpReportUtils(this.con, this.mid, (Preferences)this.setup);
        HashMap<Integer, ArrayList<DetailCreateTask>> taskMap = new HashMap<Integer, ArrayList<DetailCreateTask>>();
        int taskCount = 0;
        PreparedStatement ps = ru.selectSomethingFromSessions(lids, period, " id, ipaddr, nas_id, session_start,session_stop,login_name ", null, null, null, null);
        if (ps != null) {
            ResultSet rs = ps.executeQuery();
            if (rs == null) {
                throw new BGMessageException("\u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
            }
            int nasId = 0;
            while (rs.next()) {
                ArrayList<DetailCreateTask> list;
                DetailCreateTask task = new DetailCreateTask();
                task.setModule(1);
                int sessionId = rs.getInt(1);
                task.setDialupSessionIp(rs.getLong(2));
                nasId = rs.getInt(3);
                task.setSessionStart(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(4)));
                task.setSessionEnd(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(5)));
                task.setDialupLogin(rs.getString(6));
                NasManager nu = new NasManager(this.con, this.mid);
                NasDialup nas = nu.getNasById(nasId);
                if (nas == null) {
                    log.error("Not found NAS for session  => " + sessionId);
                    continue;
                }
                nu.setNasConfig(nas);
                task.setSourceId(nas.getConfig().getInt("ipn.source.id", 0));
                if (task.getSourceId() <= 0) {
                    log.error("Source IPN for NAS not found in ipn.source.id property!");
                    continue;
                }
                int ipnMid = nas.getConfig().getInt("ipn.module.id", 0);
                if (ipnMid <= 0) {
                    log.error("mid IPN for NAS not found in ipn.module.id property!");
                    continue;
                }
                String sessionNetTableName = ServerUtils.getModuleMonthTableName((String)"log_session_net", (Date)task.getSessionStart().getTime(), (int)this.mid);
                if (ServerUtils.tableExists((Connection)this.con, (String)sessionNetTableName)) {
                    ArrayList<IpNet> netList = new ArrayList<IpNet>();
                    String query = "SELECT net, mask FROM " + sessionNetTableName + " WHERE session_id=?";
                    PreparedStatement psNet = this.con.prepareStatement(query);
                    psNet.setInt(1, sessionId);
                    ResultSet rsNet = psNet.executeQuery();
                    while (rsNet.next()) {
                        IpNet net = new IpNet();
                        net.net = rsNet.getLong(1);
                        net.mask = rsNet.getLong(2);
                        netList.add(net);
                    }
                    rsNet.close();
                    psNet.close();
                    task.setDialupNetList(netList);
                }
                if ((list = (ArrayList<DetailCreateTask>)taskMap.get(ipnMid)) == null) {
                    list = new ArrayList<DetailCreateTask>();
                    taskMap.put(ipnMid, list);
                }
                list.add(task);
                ++taskCount;
            }
            rs.close();
            ps.close();
        }
        for (Integer ipnMid : taskMap.keySet()) {
            DetailCreateTaskManager taskManager = new DetailCreateTaskManager(this.con, ipnMid.intValue());
            List list = (List)taskMap.get(ipnMid);
            for (DetailCreateTask task : list) {
                task.setMonthPeriod(true);
                task.setCount(taskCount);
                task.setFileName(fileName);
                taskManager.addTask(task);
            }
        }
    }
}

