/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.action;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionGetLogAndError
extends bitel.billing.server.call.action.base.ActionGetLogAndError {
    protected void addData(ResultSet rs, Element parent) throws SQLException {
        while (rs.next()) {
            Element element = this.createElement(parent, "row");
            element.setAttribute("id", rs.getString("lr"));
            element.setAttribute("record_id", rs.getString("id"));
            element.setAttribute("cid", rs.getString("t2.id"));
            element.setAttribute("contract", rs.getString("t2.title") + " ( " + rs.getString("login_name") + " )");
            element.setAttribute("comment", rs.getString("t2.comment"));
            element.setAttribute("act", String.valueOf(rs.getInt("t1.status") == 0));
            Timestamp session_start = rs.getTimestamp("session_start");
            element.setAttribute("session_start", TimeUtils.formatFullDate((Date)session_start));
            Timestamp session_stop = rs.getTimestamp("session_stop");
            element.setAttribute("session_stop", TimeUtils.formatFullDate((Date)session_stop));
            int time = rs.getInt("session_time");
            element.setAttribute("session_time", Utils.formatSessionTime((int)time));
            float session_cost = rs.getFloat("session_cost");
            element.setAttribute("session_cost", Utils.formatSessionCost((float)session_cost));
            element.setAttribute("from_to", Utils.formatPhoneNumber((String)rs.getString("from_number")) + " / " + Utils.formatPhoneNumber((String)rs.getString("to_number")));
            BigDecimal in = rs.getBigDecimal("input_octets");
            BigDecimal out = rs.getBigDecimal("output_octets");
            int scale = 0;
            if ("gb".equals(this.units)) {
                in = in.divide(BigDecimal.valueOf(0x40000000L));
                out = out.divide(BigDecimal.valueOf(0x40000000L));
                scale = 2;
            } else if ("mb".equals(this.units)) {
                in = in.divide(BigDecimal.valueOf(0x100000L));
                out = out.divide(BigDecimal.valueOf(0x100000L));
                scale = 2;
            }
            element.setAttribute("in", Utils.formatBigDecimal((BigDecimal)in, (int)scale));
            element.setAttribute("out", Utils.formatBigDecimal((BigDecimal)out, (int)scale));
            element.setAttribute("ipaddr", IPUtils.convertLongIpToString((long)rs.getLong("ipaddr")));
        }
    }
}

