/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess.create;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.create.AccountingCreateSessions;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.create.InetConnectionAutoRuntimeCreateSessions;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.create.NetflowSessionCreator;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.bean.DataProcessRecordDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class SessionCreateTask
implements Runnable {
    private final DataProcessRecord record;
    private Accounting accounting;
    private final Setup setup;
    private final int rootDeviceId;
    private static final Logger logger = LogManager.getLogger();

    public SessionCreateTask(DataProcessRecord record, Setup setup, int rootDeviceId) {
        this.record = record;
        this.setup = setup;
        this.rootDeviceId = rootDeviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.accounting = new AccountingCreateSessions(this.setup, this.rootDeviceId, false, true, this.record.getDay(), null, null, this.record.getDeviceId());
            try {
                this.accounting.start();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
            NetflowSessionCreator creator = new NetflowSessionCreator(this.accounting, this.record.getDeviceId(), this.setup);
            creator.init();
            ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
            Connection con = connectionSet.getConnection();
            Date day = this.record.getDay();
            Date now = new Date();
            int daylDelta = TimeUtils.daysDelta((Date)now, (Date)day);
            if (daylDelta > 0) {
                this.removeTask(this.record, con);
                return;
            }
            boolean isCurrentDay = daylDelta == 0;
            try {
                if (isCurrentDay) {
                    return;
                }
                Calendar cal = TimeUtils.convertDateToCalendar((Date)day);
                for (int i = 0; i < 24; ++i) {
                    cal.set(11, i);
                    Date hour = cal.getTime();
                    logger.debug("start processing log for hour " + hour + ";deviceId=" + this.record.getDeviceId());
                    long start = System.currentTimeMillis();
                    creator.getAmountsFromLogs(hour);
                    logger.debug("hour " + hour + " was processed by  " + TimeUtils.formatDeltaTime((long)((System.currentTimeMillis() - start) / 1000L)));
                    this.updateTaskHour(con, this.record, i + 1);
                }
                this.flushSessions(connectionSet);
            }
            finally {
                this.removeTask(this.record, con);
                connectionSet.close();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public void flushSessions(ConnectionSet connectionSet) throws SQLException, BGException {
        Connection con = connectionSet.getConnection();
        InetSessionDao inetSessionDao = new InetSessionDao(con, this.accounting.moduleId);
        InetConnectionDao inetConnectionDao = new InetConnectionDao(con, this.accounting.moduleId);
        ArrayList<InetConnectionAutoRuntimeCreateSessions> connectionForUpdate = new ArrayList<InetConnectionAutoRuntimeCreateSessions>();
        HashSet<Integer> servIds = new HashSet<Integer>();
        for (Map.Entry entry : this.accounting.connectionMapAuto.autoSessionMap.entrySet()) {
            for (Map.Entry entry2 : ((ConcurrentMap)entry.getValue()).entrySet()) {
                InetConnectionAutoRuntimeCreateSessions connectionAutoRuntime = (InetConnectionAutoRuntimeCreateSessions)entry2.getValue();
                if (!connectionAutoRuntime.isTrafficExist()) continue;
                servIds.add(connectionAutoRuntime.connection.getServId());
                connectionForUpdate.add(connectionAutoRuntime);
            }
        }
        try (InetSessionLogDao inetSessionLogDao = new InetSessionLogDao(con, this.accounting.moduleId, this.record.getDay());){
            Set<Integer> deviceIds = this.accounting.getFlowDevices(this.record.getDeviceId());
            inetSessionLogDao.killSessionsForServWithTraffic(servIds, deviceIds, this.record.getDay());
            this.killUnkownSessions(con, deviceIds);
            for (InetConnectionAutoRuntime inetConnectionAutoRuntime : connectionForUpdate) {
                InetSessionLog session = new InetSessionLog();
                long sessionId = inetSessionDao.getNextSessionId();
                long connectionId = inetConnectionDao.getNextConnectionId();
                Date sessionStop = inetConnectionAutoRuntime.sessionStop;
                session.setId(sessionId);
                session.setConnectionId(connectionId);
                session.setContractId(inetConnectionAutoRuntime.contractId);
                session.setDeviceId(inetConnectionAutoRuntime.connection.getDeviceId());
                session.setServId(inetConnectionAutoRuntime.connection.getServId());
                session.setSessionStart(inetConnectionAutoRuntime.sessionStart);
                session.setSessionStop(sessionStop);
                session.setType(16);
                session.setConnectionStart(inetConnectionAutoRuntime.sessionStart);
                session.setLastActive(sessionStop);
                session.setSessionCost(BigDecimal.ZERO);
                session.setSessionTime(86399L);
                session.setStatus(4);
                session.setDeviceState(InetServState.STATE_ENABLE.getCode());
                inetSessionLogDao.update(session);
            }
        }
    }

    private void killUnkownSessions(Connection con, Set<Integer> deviceIds) throws SQLException {
        String logTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)this.record.getDay(), (int)this.accounting.moduleId);
        String servTableName = ServerUtils.getModuleTableName((String)"inet_serv", (int)this.accounting.moduleId);
        Date dateFrom = this.record.getDay();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateFrom);
        cal.add(5, 1);
        Date dateTo = cal.getTime();
        String query = "DELETE FROM " + logTableName + " WHERE sessionStart >= ? AND sessionStart < ? AND servId NOT IN ( SELECT id FROM " + servTableName + ") AND deviceId  IN ( " + Utils.toString(deviceIds) + ")";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)dateFrom));
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)dateTo));
        ps.executeUpdate();
        ps.close();
    }

    private void updateTaskHour(Connection con, DataProcessRecord record, int hour) throws BGException {
        try (DataProcessRecordDao dao = new DataProcessRecordDao(con, this.accounting.moduleId);){
            record.setCurentHour(hour);
            dao.update(record);
        }
    }

    private void removeTask(DataProcessRecord record, Connection con) throws BGException {
        try (DataProcessRecordDao dao = new DataProcessRecordDao(con, this.accounting.moduleId);){
            record.setStartTime(null);
            dao.update(record);
            dao.delete(record.getId());
        }
    }
}

