/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.ConnectionAliveEventWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.EventTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.RestrictionTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.ServTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionCountTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionFinishWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionFlushingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionTarifficationWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionTrackingWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.worker.ThreadContextFactory;

public class AccountingWorkerSet
implements Lifecycle {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;
    private List<AccountingWorker> workers;

    public AccountingWorkerSet(Accounting accounting) {
        this.accounting = accounting;
    }

    public void start() throws BGException {
        logger.debug("Starting accounting workers");
        ServerContextThreadFactory threadContextFactory = new ServerContextThreadFactory(this.accounting.setup, this.accounting.moduleId, null, null);
        InetDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        ParameterMap config = rootDeviceRuntime.config;
        if (config.subIndexed("accounting.worker.").size() == 0) {
            logger.debug("Root device config doesn't contain accounting workers setup. Using defaults");
            Preferences defaults = new Preferences();
            defaults.set("accounting.worker.1.thread.count", "1");
            defaults.set("accounting.worker.1.tariffication.1.minDeltaAmount", "0");
            defaults.set("accounting.worker.1.tariffication.1.delay", "10");
            defaults.set("accounting.worker.1.tariffication.1.batchSize", "100");
            defaults.set("accounting.worker.1.tracking.1.delay", "20");
            defaults.set("accounting.worker.1.tracking.1.batchSize", "100");
            defaults.set("accounting.worker.2.thread.count", "1");
            defaults.set("accounting.worker.2.flushing.1.minDeltaAccount", "0");
            defaults.set("accounting.worker.2.flushing.1.delay", "20");
            defaults.set("accounting.worker.2.flushing.1.batchSize", "500");
            defaults.set("accounting.worker.3.thread.count", "1");
            defaults.set("accounting.worker.3.finishing.1.delay", "20");
            defaults.set("accounting.worker.3.finishing.1.batchSize", "500");
            config = defaults.inherit(config);
        }
        this.workers = new ArrayList<AccountingWorker>();
        boolean tariffication = false;
        boolean tracking = false;
        boolean flushing = false;
        boolean finishing = false;
        boolean sessionCountCheck = false;
        boolean restrictionCheck = false;
        boolean aliveEventGen = false;
        for (Map.Entry workerEntry : config.subKeyed("accounting.worker.").entrySet()) {
            ParameterMap eventParams;
            ParameterMap trackingParams;
            String name = (String)workerEntry.getKey();
            ParameterMap workerParams = (ParameterMap)workerEntry.getValue();
            AccountingWorker worker = new AccountingWorker(name, workerParams, (ThreadContextFactory<ServerContext>)threadContextFactory);
            this.workers.add(worker);
            logger.info("Create worker " + name);
            worker.init();
            worker.start();
            for (Map.Entry e : workerParams.subKeyed("tariffication.").entrySet()) {
                ParameterMap tarifficationParams = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new SessionTarifficationWorker(this.accounting, worker.service, "call", tarifficationParams, this.accounting.connectionMapCall.values()));
                worker.addTask((String)e.getKey(), new SessionTarifficationWorker(this.accounting, worker.service, "auto", tarifficationParams, this.accounting.connectionMapAuto.iterable()));
                tariffication = true;
            }
            for (Map.Entry e : workerParams.subKeyed("tracking.").entrySet()) {
                trackingParams = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new SessionTrackingWorker(this.accounting, worker.service, "call", trackingParams, this.accounting.connectionMapCall.values()));
                worker.addTask((String)e.getKey(), new SessionTrackingWorker(this.accounting, worker.service, "auto", trackingParams, this.accounting.connectionMapAuto.iterable()));
                tracking = true;
            }
            for (Map.Entry e : workerParams.subKeyed("flushing.").entrySet()) {
                ParameterMap flushingParams = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new SessionFlushingWorker(this.accounting, worker.service, "call", flushingParams, this.accounting.connectionMapCall.values()));
                worker.addTask((String)e.getKey(), new SessionFlushingWorker(this.accounting, worker.service, "auto", flushingParams, this.accounting.connectionMapAuto.iterable()));
                flushing = true;
            }
            for (Map.Entry e : workerParams.subKeyed("finishing.").entrySet()) {
                ParameterMap finishingParams = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new SessionFinishWorker(this.accounting, worker.service, "call", finishingParams, this.accounting.connectionMapCall.values()));
                worker.addTask((String)e.getKey(), new SessionFinishWorker(this.accounting, worker.service, "auto", finishingParams, this.accounting.connectionMapAuto.iterable()));
                finishing = true;
            }
            for (Map.Entry e : workerParams.subKeyed("serv.tracking.").entrySet()) {
                trackingParams = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new ServTrackingWorker(this.accounting, worker.service, trackingParams));
            }
            for (Map.Entry e : workerParams.subKeyed("event.tracking.").entrySet()) {
                eventParams = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new EventTrackingWorker(this.accounting, worker.service, eventParams));
            }
            for (Map.Entry e : workerParams.subKeyed("sessionCount.tracking.").entrySet()) {
                eventParams = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new SessionCountTrackingWorker(this.accounting, worker.service, eventParams));
                sessionCountCheck = true;
            }
            for (Map.Entry e : workerParams.subKeyed("restriction.tracking.").entrySet()) {
                eventParams = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new RestrictionTrackingWorker(this.accounting, worker.service, eventParams));
                restrictionCheck = true;
            }
            for (Map.Entry e : workerParams.subKeyed("event.alive.").entrySet()) {
                ParameterMap params = (ParameterMap)e.getValue();
                worker.addTask((String)e.getKey(), new ConnectionAliveEventWorker(this.accounting, worker.service, "auto", params, this.accounting.connectionMapAuto.iterable()));
                aliveEventGen = true;
            }
        }
        if (!tariffication) {
            logger.error("Tariffication worker not started. Check config!");
        }
        if (!tracking) {
            logger.error("Tracking worker not started. Check config!");
        }
        if (!flushing) {
            logger.error("Flushing worker not started. Check config!");
        }
        if (!finishing) {
            logger.error("Finishing worker not started. Check config!");
        }
        if (!(sessionCountCheck && restrictionCheck && aliveEventGen)) {
            Preferences params;
            Preferences workerParams = new Preferences();
            workerParams.set("thread.count", "1");
            AccountingWorker worker = new AccountingWorker("system", (ParameterMap)workerParams, (ThreadContextFactory<ServerContext>)threadContextFactory);
            this.workers.add(worker);
            logger.info("Create worker system");
            worker.init();
            worker.start();
            if (!sessionCountCheck) {
                params = new Preferences();
                params.set("delay", "23");
                params.set("batchSize", "1000");
                worker.addTask("sessionCountWorker", new SessionCountTrackingWorker(this.accounting, worker.service, (ParameterMap)params));
            }
            if (!restrictionCheck) {
                params = new Preferences();
                params.set("delay", "23");
                params.set("batchSize", "500");
                worker.addTask("restrictionWorker", new RestrictionTrackingWorker(this.accounting, worker.service, (ParameterMap)params));
            }
            if (!aliveEventGen) {
                params = new Preferences();
                params.set("delay", "180");
                params.set("batchSize", "250");
                worker.addTask("aliveEventGen", new ConnectionAliveEventWorker(this.accounting, worker.service, "auto", (ParameterMap)params, this.accounting.connectionMapAuto.iterable()));
            }
        }
    }

    public void stop() throws InterruptedException {
        logger.debug("Stopping accounting workers....");
        for (AccountingWorker worker : this.workers) {
            worker.stop();
        }
        for (AccountingWorker worker : this.workers) {
            worker.destroy();
        }
        this.workers.clear();
        this.workers = null;
        logger.debug("... done");
    }
}

