/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.resource;

import bitel.billing.module.admin.resource.IPResourcePanel;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IPField;
import bitel.billing.module.common.IntTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.util.Calendar;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class IPResourceSelectPanel
extends BGPanel {
    private IPResourcePanel.IPResourceCategoriesTreePanel categoriesTree = new IPResourcePanel.IPResourceCategoriesTreePanel(false);
    private IntTextField rangeSize;
    private IPField maskMask;
    private IntTextField mask2Mask;
    private BGComboBox<ComboBoxItem> rangeCb;
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private DefaultListModel<BGUListItem> resultModel = new DefaultListModel();
    private JList<BGUListItem> result = new JList<BGUListItem>(this.resultModel);
    private JLabel countLabel = new JLabel();
    private ActionListener actionListener;
    private boolean onlyNets = false;

    public IPResourceSelectPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.rangeSize = new IntTextField();
        this.maskMask = new IPField();
        this.mask2Mask = new IntTextField();
        this.rangeCb = new BGComboBox();
        this.buildRangeCmb();
        JPanel range = new JPanel(new GridBagLayout());
        range.add((Component)this.rangeSize, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel mask1 = new JPanel(new GridBagLayout());
        mask1.add((Component)this.maskMask, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel mask2 = new JPanel(new GridBagLayout());
        mask2.add((Component)this.mask2Mask, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        final CardLayout cardLayout = new CardLayout();
        final JPanel panel = new JPanel(cardLayout);
        panel.add((Component)range, "range");
        panel.add((Component)mask1, "mask1");
        panel.add((Component)mask2, "mask2");
        this.rangeCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    cardLayout.show(panel, (String)((ComboBoxItem)e.getItem()).getObject());
                }
            }
        });
        JPanel numRangePanel = new JPanel(new GridBagLayout());
        numRangePanel.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        numRangePanel.add(this.rangeCb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.categoriesTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    IPResourceSelectPanel.this.setData();
                }
            }
        });
        JButton goButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPResourceSelectPanel.this.setData();
            }
        });
        JPanel goPanel = new JPanel(new GridBagLayout());
        goPanel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        goPanel.add((Component)this.date, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        goPanel.add((Component)goButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        Font font = new Font("Dialog", 1, 14);
        JPanel countPanel = new JPanel(new GridBagLayout());
        JLabel countText = new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u0432: ");
        countText.setFont(font);
        this.countLabel.setFont(font);
        countPanel.add((Component)countText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        countPanel.add((Component)this.countLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPResourceSelectPanel.this.stopSelect(e.getActionCommand().equals("ok"));
            }
        });
        this.categoriesTree.setMinimumSize(new Dimension(200, 0));
        this.date.setLocalDate(LocalDate.now());
        this.add((Component)this.categoriesTree, new GridBagConstraints(0, 0, 1, 5, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)numRangePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)goPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.result), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)countPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public void init(String module, int mid) {
        super.init("admin.resource", mid);
        this.categoriesTree.init("admin.resource", mid);
        this.categoriesTree.setData();
    }

    @Override
    public void setData() {
        String date = this.date.getDateString();
        if (Utils.isBlankString(date)) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
            return;
        }
        String categoryId = this.categoriesTree.getSelectedId();
        if (Utils.isBlankString(categoryId)) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("FreeIPResourceList");
        request.setModuleId(this.getModuleId());
        request.setAttribute("date", date);
        request.setAttribute("category_id", categoryId);
        if ("range".equals(this.rangeCb.getSelectedId())) {
            request.setAttribute("rangeSize", String.valueOf(this.rangeSize.getValue()));
            this.rangeSize.setText(String.valueOf(this.rangeSize.getValue()));
        } else if ("mask1".equals(this.rangeCb.getSelectedId())) {
            int mask = 32 - Long.numberOfTrailingZeros(this.maskMask.getIPValue());
            request.setAttribute("mask", String.valueOf(mask));
        } else if ("mask2".equals(this.rangeCb.getSelectedId())) {
            request.setAttribute("mask", String.valueOf(this.mask2Mask.getValue()));
            this.mask2Mask.setText(String.valueOf(this.mask2Mask.getValue()));
        }
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.result, this.resultModel, XMLUtils.selectElement(doc, "//list"));
            this.countLabel.setText(String.valueOf(this.resultModel.getSize()));
        }
    }

    public void setDate(Calendar date) {
        this.date.setDateCalendar(date);
    }

    public Calendar getDate() {
        return this.date.getDateCalendar();
    }

    public String[] getIPs() {
        BGUListItem li = this.result.getSelectedValue();
        if (li != null) {
            return new String[]{(String)li.getAttribute("hostMin"), (String)li.getAttribute("hostMax")};
        }
        return new String[]{"", ""};
    }

    public void setActionListener(ActionListener value) {
        this.actionListener = value;
    }

    private void stopSelect(boolean ok) {
        if (ok) {
            if (this.date.getDateCalendar() == null) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430");
                return;
            }
            if (this.result.getSelectedIndex() < 0) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0430\u0434\u0440\u0435\u0441");
                return;
            }
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "ok"));
        } else {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "cancel"));
        }
    }

    public int getMask2() {
        BGUListItem li = this.result.getSelectedValue();
        if (li != null) {
            return Integer.valueOf((String)li.getAttribute("bitmask"));
        }
        return 0;
    }

    public void setOnlyNets(boolean onlyNets) {
        this.onlyNets = onlyNets;
        this.buildRangeCmb();
    }

    private void buildRangeCmb() {
        this.rangeCb.removeAllItems();
        if (!this.onlyNets) {
            this.rangeCb.addItem(new ComboBoxItem("range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
        }
        this.rangeCb.addItem(new ComboBoxItem("mask2", "\u041f\u043e\u0434\u0441\u0435\u0442\u044c"));
        this.rangeCb.addItem(new ComboBoxItem("mask1", "\u041f\u043e\u0434\u0441\u0435\u0442\u044c (\u043c\u0430\u0441\u043a\u0430)"));
    }
}

