/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComponent;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.LogRequestParameters;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.LogEntry;
import ru.bitel.common.model.LoggableService;

public class BGLoggedEditor
extends BGEditor {
    private Class<? extends LoggableService> service = null;

    public BGLoggedEditor(String defaultName, Class<? extends LoggableService> service) {
        super(defaultName);
        this.service = service;
    }

    public JComponent addEmptyForm(String title, LogRequestParameters params) {
        BGUPanel component = new BGUPanel(){

            @Override
            protected void jbInit() {
            }
        };
        component.setName(title);
        return this.addForm((JComponent)component, params);
    }

    public JComponent addForm(JComponent component, LogRequestParameters params) {
        return this.addForm(component, component.getName(), params);
    }

    public JComponent addForm(JComponent component, Object constraints, final LogRequestParameters params) {
        if (component instanceof BGUPanel) {
            BGUPanel pane = (BGUPanel)component;
            final String name = (String)constraints;
            final BGLogTable logPane = new BGLogTable();
            logPane.getActionMap().put("close", new BGUAction("close", "\u041d\u0430\u0437\u0430\u0434"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BGLoggedEditor.this.show(name);
                }
            });
            super.addForm(logPane, "log." + name);
            pane.getActionMap().put("left.history", new BGUAction("left.history", "\u0418\u0441\u0442\u043e\u0440\u0438\u044f"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        logPane.setData(((ClientContext)BGLoggedEditor.this.getContext()).getPort(BGLoggedEditor.this.service).logList(params.getFilter(), params.getArgs()));
                        BGLoggedEditor.this.show("log." + name);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            });
        }
        return super.addForm(component, constraints);
    }

    private class BGLogTable
    extends BGUPanel {
        private BGUTable table;
        private BGTableModel<LogEntry> model;

        private BGLogTable() {
        }

        @Override
        protected void jbInit() {
            this.setLayout(new GridBagLayout());
            this.model = new BGTableModel<LogEntry>("history"){

                @Override
                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0414\u0430\u0442\u0430", Column.DateTime.class, 160, 160, 200, "date", true);
                    this.addColumn("\u041a\u043e\u0434 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", 100, 100, 100, "objectId", true, DecimalTableCellRenderer.INTEGER());
                    this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435", 100, 100, 100, "action", true, HorizontalAlignmentTableCellRenderer.CENTER());
                    this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "description", true, HorizontalAlignmentTableCellRenderer.LEFT());
                    this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 140, 140, 180, "userName", true, HorizontalAlignmentTableCellRenderer.LEFT());
                }

                @Override
                public Object getValue(LogEntry val, int column) throws BGException {
                    switch (this.getIdentifier(column)) {
                        case "action": {
                            switch (val.getAction()) {
                                case 0: {
                                    return "\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435";
                                }
                                case 2: {
                                    return "\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435";
                                }
                                case 1: {
                                    return "\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435";
                                }
                            }
                        }
                    }
                    return super.getValue(val, column);
                }
            };
            this.table = new BGUTable(this.model);
            this.add((Component)BGSwingUtilites.wrapScrollPane(this.table, 200, 400), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        protected void initActions() {
        }

        public void setData(List<LogEntry> data) {
            this.model.setData(data);
        }
    }
}

