/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.server;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.kernel.admin.mail.common.bean.MailConfig;
import ru.bitel.bgbilling.kernel.admin.mail.common.handler.MailConfigAbstractHandler;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailConfigCache;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.admin.mail.server.handler.MailConfigDefaultHandler;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;

public class MailMsg
extends BGLogger {
    private String encoding;
    private MimeMessage msg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailMsg(Preferences setup) throws BGException {
        block8: {
            try {
                BGNestedContext.push("mail");
                String fromAddress = setup.get("mail.from.email", null);
                String fromName = setup.get("mail.from.name", "BGBilling server");
                this.encoding = setup.get("mail.encoding", "UTF-8");
                String user = setup.get("mail.smtp.user", null);
                String pswd = setup.get("mail.smtp.pswd", null);
                if (fromAddress != null) {
                    Properties props = new Properties();
                    props.setProperty("mail.debug", String.valueOf(setup.getBoolean("mail.debug", false)));
                    props.setProperty("mail.smtp.host", setup.get("mail.smtp.host", null));
                    props.setProperty("mail.smtp.port", setup.get("mail.smtp.port", "25"));
                    props.setProperty("mail.smtp.localhost", setup.get("mail.smtp.localhost", ""));
                    props.setProperty("mail.smtp.starttls.enable", String.valueOf(setup.getBoolean("mail.smtp.starttls.enable", false)));
                    for (Map.Entry<String, String> entry : setup.sub("mail.properties.").entrySet()) {
                        props.put(entry.getKey(), entry.getValue());
                    }
                    Authenticator authenticator = null;
                    if (Utils.notBlankString(user) && Utils.notBlankString(pswd)) {
                        authenticator = new Authenticator(user, pswd);
                        props.setProperty("mail.smtp.auth", "true");
                        props.setProperty("mail.smtp.submitter", authenticator.getPasswordAuthentication().getUserName());
                    }
                    Session session = Session.getInstance((Properties)props, authenticator);
                    this.msg = new MimeMessage(session);
                    try {
                        this.msg.setFrom((Address)new InternetAddress(fromAddress, fromName, this.encoding));
                        this.msg.setSentDate(new Date());
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                    break block8;
                }
                this.getLogger().error("Not set parameter: mail.from.email");
                throw new BGException("Not set parameter: mail.from.email");
            }
            finally {
                BGNestedContext.pop();
            }
        }
    }

    @Deprecated
    public void sendMessage(String recipients, String subject, String text) throws BGException {
        BGNestedContext.push("mail");
        MimeMultipart multipart = new MimeMultipart();
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(text, this.encoding);
            multipart.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (MessagingException e) {
            throw new BGException("error send message", e);
        }
        finally {
            BGNestedContext.pop();
        }
        this.sendMessage(recipients, subject, (Multipart)multipart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendMessage(MailData mailData) throws BGException {
        try {
            BGNestedContext.push("mail");
            String componentId = null;
            String mailDataClassName = mailData.getClass().getName();
            if (mailDataClassName.startsWith("ru.bitel.bgbilling.kernel.admin.mail.server.mail")) {
                componentId = "kernel";
            } else if (mailDataClassName.startsWith("ru.bitel.bgbilling.modules.")) {
                componentId = mailDataClassName.replaceAll("^ru\\.bitel\\.bgbilling\\.modules\\.([^.]+)\\.server\\.mail$", "$1");
            } else if (mailDataClassName.startsWith("ru.bitel.bgbilling.plugins.")) {
                componentId = mailDataClassName.replaceAll("^(ru\\.bitel\\.bgbilling\\.plugins\\.[^.]+)\\.server\\.mail$", "$1");
            } else if (mailDataClassName.startsWith("ru.bitel.bgbilling.kernel.admin.mail.server.bean")) {
                componentId = "none";
            }
            MailConfig mailConfig = MailConfigCache.getMailConfig(componentId, mailData.getModuleId(), mailData.getMailKey());
            if (mailConfig != null) {
                MailConfig defaultMailConfig = MailConfigCache.getMailConfig("default", mailData.getModuleId(), "default");
                if (defaultMailConfig != null) {
                    mailConfig.setPatternDefault(defaultMailConfig.getPatternCustom());
                    mailConfig.setHandlerDefault(defaultMailConfig.getHandlerCustom());
                }
                MailConfigDefaultHandler mailConfigDefaultHandler = new MailConfigDefaultHandler();
                mailConfigDefaultHandler.applyMailConfig(mailData, mailConfig);
                String handlerClassName = null;
                if (mailConfig.getHandlerMode() == MailConfig.HandlerMode.DEFAULT) {
                    if (Utils.notBlankString(mailConfig.getHandlerDefault())) {
                        handlerClassName = mailConfig.getHandlerDefault();
                    }
                } else if (mailConfig.getHandlerMode() == MailConfig.HandlerMode.CUSTOM && Utils.notBlankString(mailConfig.getHandlerCustom())) {
                    handlerClassName = mailConfig.getHandlerCustom();
                }
                if (handlerClassName != null) {
                    DynamicClassManager.getInstance().newInstance(MailConfigAbstractHandler.class, handlerClassName).applyMailConfig(mailData, defaultMailConfig);
                }
            }
            String string = this.sendMessage(mailData.getRecipients(), mailData.getSubject(), mailData.getMultipart());
            return string;
        }
        finally {
            BGNestedContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendMessage(String recipients, String subject, Multipart multipart) throws BGException {
        try {
            BGNestedContext.push("mail");
            if (this.msg == null) {
                this.getLogger().error("mail not configured! (set config parameters mail.from.email, ...)");
                throw new BGException("msg == null");
            }
            boolean logSendEmail = Setup.getSetup().getBoolean("mail.send.log", true);
            ArrayList<CallSite> sendResult = new ArrayList<CallSite>();
            StringTokenizer st = new StringTokenizer(recipients, ";,\n\r");
            while (st.hasMoreTokens()) {
                String mail = st.nextToken().trim();
                try {
                    this.getLogger().debug("Message send to {}...", (Object)mail);
                    InternetAddress[] addresses = null;
                    try {
                        addresses = InternetAddress.parse((String)mail);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error parse address - {} [{}]", (Object)mail, (Object)e.getLocalizedMessage());
                        sendResult.add((CallSite)((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043d\u0430 \"" + mail + "\" => \u041e\u0428\u0418\u0411\u041a\u0410 [" + e.getLocalizedMessage() + "]")));
                        continue;
                    }
                    if (addresses == null || addresses.length <= 0) continue;
                    this.msg.setSubject(subject, this.encoding);
                    this.msg.setContent(multipart);
                    this.encodingPersonal(addresses);
                    this.msg.setRecipients(Message.RecipientType.TO, (Address[])addresses);
                    Transport.send((Message)this.msg);
                    sendResult.add((CallSite)((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043d\u0430 \"" + mail + "\" => \u041e\u0422\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u041e")));
                    if (!logSendEmail) continue;
                    this.getLogger().info("Recipient: {}; Subject: {}; BodyPartCount: {}", (Object)mail, (Object)subject, (Object)multipart.getCount());
                }
                catch (Exception ex) {
                    this.getLogger().error("Error send message to " + mail);
                    sendResult.add((CallSite)((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043d\u0430 \"" + mail + "\" => \u041e\u0428\u0418\u0411\u041a\u0410 [" + ex.getLocalizedMessage() + "]")));
                }
            }
            String string = Utils.toString(sendResult, "\n");
            return string;
        }
        finally {
            BGNestedContext.pop();
        }
    }

    private void encodingPersonal(InternetAddress[] addresses) {
        if (addresses != null) {
            for (InternetAddress address : addresses) {
                try {
                    address.setPersonal(address.getPersonal(), "utf-8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new BGRuntimeException("error encoding personal", uee);
                }
            }
        }
    }

    private static class Authenticator
    extends jakarta.mail.Authenticator {
        private PasswordAuthentication authentication;

        public Authenticator(String user, String password) {
            this.authentication = new PasswordAuthentication(user, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

